/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.merge;

import com.jxdinfo.hussar.formdesign.jgit.diff.RawText;
import com.jxdinfo.hussar.formdesign.jgit.merge.EolAwareOutputStream;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeChunk;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeResult;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;

class MergeFormatterPass {
    private final EolAwareOutputStream out;
    private final MergeResult<RawText> res;
    private final List<String> seqName;
    private final Charset charset;
    private final boolean threeWayMerge;
    private String lastConflictingName;

    MergeFormatterPass(OutputStream out, MergeResult<RawText> res, List<String> seqName, Charset charset) {
        this.out = new EolAwareOutputStream(out);
        this.res = res;
        this.seqName = seqName;
        this.charset = charset;
        this.threeWayMerge = res.getSequences().size() == 3;
    }

    void formatMerge() throws IOException {
        boolean missingNewlineAtEnd = false;
        for (MergeChunk chunk : this.res) {
            RawText seq = this.res.getSequences().get(chunk.getSequenceIndex());
            this.writeConflictMetadata(chunk);
            for (int i = chunk.getBegin(); i < chunk.getEnd(); ++i) {
                this.writeLine(seq, i);
            }
            missingNewlineAtEnd = seq.isMissingNewlineAtEnd();
        }
        if (this.lastConflictingName != null) {
            this.writeConflictEnd();
        }
        if (!missingNewlineAtEnd) {
            this.out.beginln();
        }
    }

    private void writeConflictMetadata(MergeChunk chunk) throws IOException {
        if (this.lastConflictingName != null && chunk.getConflictState() != MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE) {
            this.writeConflictEnd();
        }
        if (chunk.getConflictState() == MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE) {
            this.writeConflictStart(chunk);
        } else if (chunk.getConflictState() == MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE) {
            this.writeConflictChange(chunk);
        }
    }

    private void writeConflictEnd() throws IOException {
        this.writeln(">>>>>>> " + this.lastConflictingName);
        this.lastConflictingName = null;
    }

    private void writeConflictStart(MergeChunk chunk) throws IOException {
        this.lastConflictingName = this.seqName.get(chunk.getSequenceIndex());
        this.writeln("<<<<<<< " + this.lastConflictingName);
    }

    private void writeConflictChange(MergeChunk chunk) throws IOException {
        this.lastConflictingName = this.seqName.get(chunk.getSequenceIndex());
        this.writeln(this.threeWayMerge ? "=======" : "======= " + this.lastConflictingName);
    }

    private void writeln(String s) throws IOException {
        this.out.beginln();
        this.out.write((s + "\n").getBytes(this.charset));
    }

    private void writeLine(RawText seq, int i) throws IOException {
        this.out.beginln();
        seq.writeLine(this.out, i);
        if (this.out.isBeginln()) {
            this.out.write(10);
        }
    }
}

