/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.internal.storage.file;

import com.jxdinfo.hussar.formdesign.jgit.annotations.NonNull;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheIterator;
import com.jxdinfo.hussar.formdesign.jgit.errors.CancelledException;
import com.jxdinfo.hussar.formdesign.jgit.errors.CorruptObjectException;
import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.FileReftableDatabase;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.FileRepository;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.GcLog;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.ObjectDirectory;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.ObjectDirectoryInserter;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.Pack;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.PackFile;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.PackIndex;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.RefDirectory;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.pack.PackExt;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.pack.PackWriter;
import com.jxdinfo.hussar.formdesign.jgit.lib.NullProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectIdSet;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectLoader;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectReader;
import com.jxdinfo.hussar.formdesign.jgit.lib.ProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.RefDatabase;
import com.jxdinfo.hussar.formdesign.jgit.lib.ReflogEntry;
import com.jxdinfo.hussar.formdesign.jgit.lib.ReflogReader;
import com.jxdinfo.hussar.formdesign.jgit.lib.internal.WorkQueue;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.ObjectWalk;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevObject;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.storage.pack.PackConfig;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.TreeFilter;
import com.jxdinfo.hussar.formdesign.jgit.util.FileUtils;
import com.jxdinfo.hussar.formdesign.jgit.util.GitDateParser;
import com.jxdinfo.hussar.formdesign.jgit.util.SystemReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GC {
    private static final Logger LOG = LoggerFactory.getLogger(GC.class);
    private static final String PRUNE_EXPIRE_DEFAULT = "2.weeks.ago";
    private static final String PRUNE_PACK_EXPIRE_DEFAULT = "1.hour.ago";
    private static final Pattern PATTERN_LOOSE_OBJECT = Pattern.compile("[0-9a-fA-F]{38}");
    private static final String PACK_EXT = "." + PackExt.PACK.getExtension();
    private static final String BITMAP_EXT = "." + PackExt.BITMAP_INDEX.getExtension();
    private static final String INDEX_EXT = "." + PackExt.INDEX.getExtension();
    private static final String KEEP_EXT = "." + PackExt.KEEP.getExtension();
    private static final int DEFAULT_AUTOPACKLIMIT = 50;
    private static final int DEFAULT_AUTOLIMIT = 6700;
    private static volatile ExecutorService executor;
    private final FileRepository repo;
    private ProgressMonitor pm;
    private long expireAgeMillis = -1L;
    private Date expire;
    private long packExpireAgeMillis = -1L;
    private Date packExpire;
    private PackConfig pconfig;
    private Collection<Ref> lastPackedRefs;
    private long lastRepackTime;
    private boolean automatic;
    private boolean background;

    public static void setExecutor(ExecutorService e) {
        executor = e;
    }

    public GC(FileRepository repo) {
        this.repo = repo;
        this.pconfig = new PackConfig(repo);
        this.pm = NullProgressMonitor.INSTANCE;
    }

    public Collection<Pack> gc() throws IOException, ParseException {
        if (!this.background) {
            return this.doGc();
        }
        GcLog gcLog = new GcLog(this.repo);
        if (!gcLog.lock()) {
            return Collections.emptyList();
        }
        Callable<Collection> gcTask = () -> {
            try {
                Object message;
                Collection<Pack> newPacks = this.doGc();
                if (this.automatic && this.tooManyLooseObjects()) {
                    message = JGitText.get().gcTooManyUnpruned;
                    gcLog.write((String)message);
                    gcLog.commit();
                }
                message = newPacks;
                return message;
            }
            catch (IOException | ParseException e) {
                try {
                    gcLog.write(e.getMessage());
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    gcLog.write(sw.toString());
                    gcLog.commit();
                }
                catch (IOException e2) {
                    e2.addSuppressed(e);
                    LOG.error(e2.getMessage(), (Throwable)e2);
                }
            }
            finally {
                gcLog.unlock();
            }
            return Collections.emptyList();
        };
        this.executor().submit(gcTask);
        return Collections.emptyList();
    }

    private ExecutorService executor() {
        return executor != null ? executor : WorkQueue.getExecutor();
    }

    private Collection<Pack> doGc() throws IOException, ParseException {
        if (this.automatic && !this.needGc()) {
            return Collections.emptyList();
        }
        this.pm.start(6);
        this.packRefs();
        Collection<Pack> newPacks = this.repack();
        this.prune(Collections.emptySet());
        return newPacks;
    }

    private void loosen(ObjectDirectoryInserter inserter, ObjectReader reader, Pack pack, HashSet<ObjectId> existing) throws IOException {
        for (PackIndex.MutableEntry entry : pack) {
            ObjectId oid = entry.toObjectId();
            if (existing.contains(oid)) continue;
            existing.add(oid);
            ObjectLoader loader = reader.open(oid);
            inserter.insert(loader.getType(), loader.getSize(), loader.openStream(), true);
        }
    }

    private void deleteOldPacks(Collection<Pack> oldPacks, Collection<Pack> newPacks) throws ParseException, IOException {
        HashSet<ObjectId> ids = new HashSet<ObjectId>();
        for (Pack pack : newPacks) {
            for (PackIndex.MutableEntry entry : pack) {
                ids.add(entry.toObjectId());
            }
        }
        ObjectReader reader = this.repo.newObjectReader();
        ObjectDirectory dir = this.repo.getObjectDatabase();
        ObjectDirectoryInserter inserter = dir.newInserter();
        boolean shouldLoosen = !"now".equals(this.getPruneExpireStr()) && this.getExpireDate() < Long.MAX_VALUE;
        this.prunePreserved();
        long packExpireDate = this.getPackExpireDate();
        block2: for (Pack oldPack : oldPacks) {
            this.checkCancelled();
            String oldName = oldPack.getPackName();
            for (Pack newPack : newPacks) {
                if (!oldName.equals(newPack.getPackName())) continue;
                continue block2;
            }
            if (oldPack.shouldBeKept() || this.repo.getFS().lastModifiedInstant(oldPack.getPackFile()).toEpochMilli() >= packExpireDate) continue;
            if (shouldLoosen) {
                this.loosen(inserter, reader, oldPack, ids);
            }
            oldPack.close();
            this.prunePack(oldPack.getPackFile());
        }
        this.repo.getObjectDatabase().close();
    }

    private void removeOldPack(PackFile packFile, int deleteOptions) throws IOException {
        if (this.pconfig.isPreserveOldPacks()) {
            File oldPackDir = this.repo.getObjectDatabase().getPreservedDirectory();
            FileUtils.mkdir(oldPackDir, true);
            PackFile oldPackFile = packFile.createPreservedForDirectory(oldPackDir);
            FileUtils.rename(packFile, oldPackFile);
        } else {
            FileUtils.delete(packFile, deleteOptions);
        }
    }

    private void prunePreserved() {
        if (this.pconfig.isPrunePreserved()) {
            try {
                FileUtils.delete(this.repo.getObjectDatabase().getPreservedDirectory(), 7);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void prunePack(PackFile packFile) {
        try {
            int deleteOptions = 6;
            this.removeOldPack(packFile.create(PackExt.PACK), deleteOptions);
            deleteOptions |= 8;
            for (PackExt ext : PackExt.values()) {
                if (PackExt.PACK.equals((Object)ext)) continue;
                this.removeOldPack(packFile.create(ext), deleteOptions);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prunePacked() throws IOException {
        ObjectDirectory objdb = this.repo.getObjectDatabase();
        Collection<Pack> packs = objdb.getPacks();
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout != null && fanout.length > 0) {
            this.pm.beginTask(JGitText.get().pruneLoosePackedObjects, fanout.length);
            try {
                for (String d : fanout) {
                    String[] entries;
                    this.checkCancelled();
                    this.pm.update(1);
                    if (d.length() != 2 || (entries = new File(objects, d).list()) == null) continue;
                    for (String e : entries) {
                        ObjectId id;
                        this.checkCancelled();
                        if (e.length() != 38) continue;
                        try {
                            id = ObjectId.fromString(d + e);
                        }
                        catch (IllegalArgumentException notAnObject) {
                            continue;
                        }
                        boolean found = false;
                        for (Pack p : packs) {
                            this.checkCancelled();
                            if (!p.hasObject(id)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        FileUtils.delete(objdb.fileFor(id), 14);
                    }
                }
            }
            finally {
                this.pm.endTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(Set<ObjectId> objectsToKeep) throws IOException, ParseException {
        Collection<Ref> newRefs;
        long expireDate = this.getExpireDate();
        HashMap<ObjectId, File> deletionCandidates = new HashMap<ObjectId, File>();
        Set<ObjectId> indexObjects = null;
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout == null || fanout.length == 0) {
            return;
        }
        this.pm.beginTask(JGitText.get().pruneLooseUnreferencedObjects, fanout.length);
        try {
            for (String d : fanout) {
                this.checkCancelled();
                this.pm.update(1);
                if (d.length() != 2) continue;
                File dir = new File(objects, d);
                File[] entries = dir.listFiles();
                if (entries == null || entries.length == 0) {
                    FileUtils.delete(dir, 8);
                    continue;
                }
                for (File f : entries) {
                    this.checkCancelled();
                    String fName = f.getName();
                    if (fName.length() != 38 || this.repo.getFS().lastModifiedInstant(f).toEpochMilli() >= expireDate) continue;
                    try {
                        ObjectId id = ObjectId.fromString(d + fName);
                        if (objectsToKeep.contains(id)) continue;
                        if (indexObjects == null) {
                            indexObjects = this.listNonHEADIndexObjects();
                        }
                        if (indexObjects.contains(id)) continue;
                        deletionCandidates.put(id, f);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.pm.endTask();
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        this.checkCancelled();
        if (this.lastPackedRefs == null || this.lastPackedRefs.isEmpty()) {
            newRefs = this.getAllRefs();
        } else {
            HashMap<String, Ref> last = new HashMap<String, Ref>();
            for (Ref r : this.lastPackedRefs) {
                last.put(r.getName(), r);
            }
            newRefs = new ArrayList<Ref>();
            for (Ref r : this.getAllRefs()) {
                Object old;
                if (GC.equals(r, (Ref)(old = (Ref)last.get(r.getName())))) continue;
                newRefs.add(r);
            }
        }
        if (!newRefs.isEmpty()) {
            ObjectWalk w = new ObjectWalk(this.repo);
            try {
                for (Ref cr : newRefs) {
                    this.checkCancelled();
                    w.markStart(w.parseAny(cr.getObjectId()));
                }
                if (this.lastPackedRefs != null) {
                    for (Ref lpr : this.lastPackedRefs) {
                        w.markUninteresting(w.parseAny(lpr.getObjectId()));
                    }
                }
                this.removeReferenced(deletionCandidates, w);
            }
            finally {
                w.dispose();
            }
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        ObjectWalk w = new ObjectWalk(this.repo);
        try {
            for (Ref ar : this.getAllRefs()) {
                for (ObjectId id : this.listRefLogObjects(ar, this.lastRepackTime)) {
                    this.checkCancelled();
                    w.markStart(w.parseAny(id));
                }
            }
            if (this.lastPackedRefs != null) {
                for (Ref lpr : this.lastPackedRefs) {
                    this.checkCancelled();
                    w.markUninteresting(w.parseAny(lpr.getObjectId()));
                }
            }
            this.removeReferenced(deletionCandidates, w);
        }
        finally {
            w.dispose();
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        this.checkCancelled();
        HashSet<File> touchedFanout = new HashSet<File>();
        for (File f : deletionCandidates.values()) {
            if (f.lastModified() >= expireDate) continue;
            f.delete();
            touchedFanout.add(f.getParentFile());
        }
        for (File f : touchedFanout) {
            FileUtils.delete(f, 24);
        }
        this.repo.getObjectDatabase().close();
    }

    private long getExpireDate() throws ParseException {
        long expireDate = Long.MAX_VALUE;
        if (this.expire == null && this.expireAgeMillis == -1L) {
            String pruneExpireStr = this.getPruneExpireStr();
            if (pruneExpireStr == null) {
                pruneExpireStr = PRUNE_EXPIRE_DEFAULT;
            }
            this.expire = GitDateParser.parse(pruneExpireStr, null, SystemReader.getInstance().getLocale());
            this.expireAgeMillis = -1L;
        }
        if (this.expire != null) {
            expireDate = this.expire.getTime();
        }
        if (this.expireAgeMillis != -1L) {
            expireDate = System.currentTimeMillis() - this.expireAgeMillis;
        }
        return expireDate;
    }

    private String getPruneExpireStr() {
        return this.repo.getConfig().getString("gc", null, "pruneexpire");
    }

    private long getPackExpireDate() throws ParseException {
        long packExpireDate = Long.MAX_VALUE;
        if (this.packExpire == null && this.packExpireAgeMillis == -1L) {
            String prunePackExpireStr = this.repo.getConfig().getString("gc", null, "prunepackexpire");
            if (prunePackExpireStr == null) {
                prunePackExpireStr = PRUNE_PACK_EXPIRE_DEFAULT;
            }
            this.packExpire = GitDateParser.parse(prunePackExpireStr, null, SystemReader.getInstance().getLocale());
            this.packExpireAgeMillis = -1L;
        }
        if (this.packExpire != null) {
            packExpireDate = this.packExpire.getTime();
        }
        if (this.packExpireAgeMillis != -1L) {
            packExpireDate = System.currentTimeMillis() - this.packExpireAgeMillis;
        }
        return packExpireDate;
    }

    private void removeReferenced(Map<ObjectId, File> id2File, ObjectWalk w) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject ro = w.next();
        while (ro != null) {
            this.checkCancelled();
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.next();
        }
        ro = w.nextObject();
        while (ro != null) {
            this.checkCancelled();
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.nextObject();
        }
    }

    private static boolean equals(Ref r1, Ref r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.isSymbolic()) {
            return r2.isSymbolic() && r1.getTarget().getName().equals(r2.getTarget().getName());
        }
        return !r2.isSymbolic() && Objects.equals(r1.getObjectId(), r2.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packRefs() throws IOException {
        RefDatabase refDb = this.repo.getRefDatabase();
        if (refDb instanceof FileReftableDatabase) {
            this.pm.beginTask(JGitText.get().packRefs, 1);
            try {
                ((FileReftableDatabase)refDb).compactFully();
            }
            finally {
                this.pm.endTask();
            }
            return;
        }
        List<Ref> refs = refDb.getRefsByPrefix("refs/");
        ArrayList<String> refsToBePacked = new ArrayList<String>(refs.size());
        this.pm.beginTask(JGitText.get().packRefs, refs.size());
        try {
            for (Ref ref : refs) {
                this.checkCancelled();
                if (!ref.isSymbolic() && ref.getStorage().isLoose()) {
                    refsToBePacked.add(ref.getName());
                }
                this.pm.update(1);
            }
            ((RefDirectory)this.repo.getRefDatabase()).pack(refsToBePacked);
        }
        finally {
            this.pm.endTask();
        }
    }

    public Collection<Pack> repack() throws IOException {
        Pack txn;
        Pack rest;
        Collection<Pack> toBeDeleted = this.repo.getObjectDatabase().getPacks();
        long time = System.currentTimeMillis();
        Collection<Ref> refsBefore = this.getAllRefs();
        HashSet allHeadsAndTags = new HashSet();
        HashSet<ObjectId> allHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> allTags = new HashSet<ObjectId>();
        HashSet<ObjectId> nonHeads = new HashSet<ObjectId>();
        HashSet txnHeads = new HashSet();
        HashSet<ObjectId> tagTargets = new HashSet<ObjectId>();
        Set<ObjectId> indexObjects = this.listNonHEADIndexObjects();
        for (Ref ref : refsBefore) {
            this.checkCancelled();
            nonHeads.addAll(this.listRefLogObjects(ref, 0L));
            if (ref.isSymbolic() || ref.getObjectId() == null) continue;
            if (GC.isHead(ref)) {
                allHeads.add(ref.getObjectId());
            } else if (GC.isTag(ref)) {
                allTags.add(ref.getObjectId());
            } else {
                nonHeads.add(ref.getObjectId());
            }
            if (ref.getPeeledObjectId() == null) continue;
            tagTargets.add(ref.getPeeledObjectId());
        }
        LinkedList<ObjectIdSet> excluded = new LinkedList<ObjectIdSet>();
        for (Pack p : this.repo.getObjectDatabase().getPacks()) {
            this.checkCancelled();
            if (!p.shouldBeKept()) continue;
            excluded.add(p.getIndex());
        }
        allTags.removeAll(allHeads);
        allHeadsAndTags.addAll(allHeads);
        allHeadsAndTags.addAll(allTags);
        tagTargets.addAll(allHeadsAndTags);
        nonHeads.addAll(indexObjects);
        if (this.pconfig.getSinglePack()) {
            allHeadsAndTags.addAll(nonHeads);
            nonHeads.clear();
        }
        ArrayList<Pack> arrayList = new ArrayList<Pack>(2);
        Pack heads = null;
        if (!allHeadsAndTags.isEmpty() && (heads = this.writePack(allHeadsAndTags, PackWriter.NONE, allTags, tagTargets, excluded)) != null) {
            arrayList.add(heads);
            excluded.add(0, heads.getIndex());
        }
        if (!nonHeads.isEmpty() && (rest = this.writePack(nonHeads, allHeadsAndTags, PackWriter.NONE, tagTargets, excluded)) != null) {
            arrayList.add(rest);
        }
        if (!txnHeads.isEmpty() && (txn = this.writePack(txnHeads, PackWriter.NONE, PackWriter.NONE, null, excluded)) != null) {
            arrayList.add(txn);
        }
        try {
            this.deleteOldPacks(toBeDeleted, arrayList);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        this.prunePacked();
        if (this.repo.getRefDatabase() instanceof RefDirectory) {
            this.deleteEmptyRefsFolders();
        }
        this.deleteOrphans();
        this.deleteTempPacksIdx();
        this.lastPackedRefs = refsBefore;
        this.lastRepackTime = time;
        return arrayList;
    }

    private static boolean isHead(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    private static boolean isTag(Ref ref) {
        return ref.getName().startsWith("refs/tags/");
    }

    private void deleteEmptyRefsFolders() throws IOException {
        Path refs = this.repo.getDirectory().toPath().resolve("refs/");
        Instant threshold = Instant.now().minus(30L, ChronoUnit.SECONDS);
        try (Stream<Path> entries = Files.list(refs).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Stream<Path> s = Files.list((Path)iterator.next());
                Throwable throwable = null;
                try {
                    s.filter(path -> this.canBeSafelyDeleted((Path)path, threshold)).forEach(this::deleteDir);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s == null) continue;
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    s.close();
                }
            }
        }
    }

    private boolean canBeSafelyDeleted(Path path, Instant threshold) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().isBefore(threshold);
        }
        catch (IOException e) {
            LOG.warn(MessageFormat.format(JGitText.get().cannotAccessLastModifiedForSafeDeletion, path), (Throwable)e);
            return false;
        }
    }

    private void deleteDir(Path dir) {
        try (Stream<Path> dirs = Files.walk(dir, new FileVisitOption[0]);){
            dirs.filter(this::isDirectory).sorted(Comparator.reverseOrder()).forEach(this::delete);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isDirectory(Path p) {
        return p.toFile().isDirectory();
    }

    private void delete(Path d) {
        try {
            Files.delete(d);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
        }
        catch (IOException e) {
            LOG.error(MessageFormat.format(JGitText.get().cannotDeleteFile, d), (Throwable)e);
        }
    }

    private void deleteOrphans() {
        Path packDir = this.repo.getObjectDatabase().getPackDirectory().toPath();
        List fileNames = null;
        try {
            Stream<Path> files = Files.list(packDir);
            Object object = null;
            try {
                fileNames = files.map(path -> path.getFileName().toString()).filter(name -> name.endsWith(PACK_EXT) || name.endsWith(BITMAP_EXT) || name.endsWith(INDEX_EXT) || name.endsWith(KEEP_EXT)).sorted(Collections.reverseOrder()).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (files != null) {
                    if (object != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        files.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return;
        }
        if (fileNames == null) {
            return;
        }
        String latestId = null;
        for (String n : fileNames) {
            PackFile pf = new PackFile(packDir.toFile(), n);
            PackExt ext = pf.getPackExt();
            if (ext.equals((Object)PackExt.PACK) || ext.equals((Object)PackExt.KEEP)) {
                latestId = pf.getId();
            }
            if (latestId != null && pf.getId().equals(latestId)) continue;
            try {
                FileUtils.delete(pf, 6);
                LOG.warn(JGitText.get().deletedOrphanInPackDir, (Object)pf);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void deleteTempPacksIdx() {
        Path packDir = this.repo.getObjectDatabase().getPackDirectory().toPath();
        Instant threshold = Instant.now().minus(1L, ChronoUnit.DAYS);
        if (!Files.exists(packDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(packDir, "gc_*_tmp");){
            stream.forEach(t -> {
                try {
                    Instant lastModified = Files.getLastModifiedTime(t, new LinkOption[0]).toInstant();
                    if (lastModified.isBefore(threshold)) {
                        Files.deleteIfExists(t);
                    }
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private Set<ObjectId> listRefLogObjects(Ref ref, long minTime) throws IOException {
        ReflogReader reflogReader = this.repo.getReflogReader(ref.getName());
        if (reflogReader == null) {
            return Collections.emptySet();
        }
        List<ReflogEntry> rlEntries = reflogReader.getReverseEntries();
        if (rlEntries == null || rlEntries.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ObjectId> ret = new HashSet<ObjectId>();
        for (ReflogEntry e : rlEntries) {
            ObjectId oldId;
            if (e.getWho().getWhen().getTime() < minTime) break;
            ObjectId newId = e.getNewId();
            if (newId != null && !ObjectId.zeroId().equals(newId)) {
                ret.add(newId);
            }
            if ((oldId = e.getOldId()) == null || ObjectId.zeroId().equals(oldId)) continue;
            ret.add(oldId);
        }
        return ret;
    }

    private Collection<Ref> getAllRefs() throws IOException {
        RefDatabase refdb = this.repo.getRefDatabase();
        List<Ref> refs = refdb.getRefs();
        List<Ref> addl = refdb.getAdditionalRefs();
        if (!addl.isEmpty()) {
            ArrayList<Ref> all = new ArrayList<Ref>(refs.size() + addl.size());
            all.addAll(refs);
            for (Ref r : addl) {
                this.checkCancelled();
                if (!r.getName().startsWith("refs/")) continue;
                all.add(r);
            }
            return all;
        }
        return refs;
    }

    private Set<ObjectId> listNonHEADIndexObjects() throws CorruptObjectException, IOException {
        if (this.repo.isBare()) {
            return Collections.emptySet();
        }
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            Serializable serializable;
            treeWalk.addTree(new DirCacheIterator(this.repo.readDirCache()));
            ObjectId headID = this.repo.resolve("HEAD");
            if (headID != null) {
                RevWalk revWalk = new RevWalk(this.repo);
                serializable = null;
                try {
                    treeWalk.addTree(revWalk.parseTree(headID));
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (revWalk != null) {
                        if (serializable != null) {
                            try {
                                revWalk.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            revWalk.close();
                        }
                    }
                }
            }
            treeWalk.setFilter(TreeFilter.ANY_DIFF);
            treeWalk.setRecursive(true);
            HashSet<ObjectId> ret = new HashSet<ObjectId>();
            block22: while (treeWalk.next()) {
                this.checkCancelled();
                ObjectId objectId = treeWalk.getObjectId(0);
                switch (treeWalk.getRawMode(0) & 0xF000) {
                    case 0: 
                    case 57344: {
                        continue block22;
                    }
                    case 16384: 
                    case 32768: 
                    case 40960: {
                        ret.add(objectId);
                        continue block22;
                    }
                }
                throw new IOException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", treeWalk.getRawMode(0)), objectId == null ? "null" : objectId.name(), treeWalk.getPathString(), this.repo.getIndexFile()));
            }
            serializable = ret;
            return serializable;
        }
    }

    /*
     * Exception decompiling
     */
    private Pack writePack(@NonNull Set<? extends ObjectId> want, @NonNull Set<? extends ObjectId> have, @NonNull Set<ObjectId> tags, Set<ObjectId> tagTargets, List<ObjectIdSet> excludeObjects) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 44[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkCancelled() throws CancelledException {
        if (this.pm.isCancelled() || Thread.currentThread().isInterrupted()) {
            throw new CancelledException(JGitText.get().operationCanceled);
        }
    }

    public RepoStatistics getStatistics() throws IOException {
        RepoStatistics ret = new RepoStatistics();
        Collection<Pack> packs = this.repo.getObjectDatabase().getPacks();
        for (Pack p : packs) {
            ret.numberOfPackedObjects += p.getIndex().getObjectCount();
            ++ret.numberOfPackFiles;
            ret.sizeOfPackedObjects += p.getPackFile().length();
            if (p.getBitmapIndex() == null) continue;
            ret.numberOfBitmaps += (long)p.getBitmapIndex().getBitmapCount();
        }
        File objDir = this.repo.getObjectsDirectory();
        String[] fanout = objDir.list();
        if (fanout != null && fanout.length > 0) {
            for (String d : fanout) {
                File[] entries;
                if (d.length() != 2 || (entries = new File(objDir, d).listFiles()) == null) continue;
                for (File f : entries) {
                    if (f.getName().length() != 38) continue;
                    ++ret.numberOfLooseObjects;
                    ret.sizeOfLooseObjects += f.length();
                }
            }
        }
        RefDatabase refDb = this.repo.getRefDatabase();
        for (Ref r : refDb.getRefs()) {
            Ref.Storage storage = r.getStorage();
            if (storage == Ref.Storage.LOOSE || storage == Ref.Storage.LOOSE_PACKED) {
                ++ret.numberOfLooseRefs;
            }
            if (storage != Ref.Storage.PACKED && storage != Ref.Storage.LOOSE_PACKED) continue;
            ++ret.numberOfPackedRefs;
        }
        return ret;
    }

    public GC setProgressMonitor(ProgressMonitor pm) {
        this.pm = pm == null ? NullProgressMonitor.INSTANCE : pm;
        return this;
    }

    public void setExpireAgeMillis(long expireAgeMillis) {
        this.expireAgeMillis = expireAgeMillis;
        this.expire = null;
    }

    public void setPackExpireAgeMillis(long packExpireAgeMillis) {
        this.packExpireAgeMillis = packExpireAgeMillis;
        this.expire = null;
    }

    public void setPackConfig(@NonNull PackConfig pconfig) {
        this.pconfig = pconfig;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
        this.expireAgeMillis = -1L;
    }

    public void setPackExpire(Date packExpire) {
        this.packExpire = packExpire;
        this.packExpireAgeMillis = -1L;
    }

    public void setAuto(boolean auto) {
        this.automatic = auto;
    }

    void setBackground(boolean background) {
        this.background = background;
    }

    private boolean needGc() {
        if (!this.tooManyPacks()) {
            return this.tooManyLooseObjects();
        }
        this.addRepackAllOption();
        return true;
    }

    private void addRepackAllOption() {
    }

    boolean tooManyPacks() {
        int autopacklimit = this.repo.getConfig().getInt("gc", "autopacklimit", 50);
        if (autopacklimit <= 0) {
            return false;
        }
        return this.repo.getObjectDatabase().getPacks().size() > autopacklimit + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean tooManyLooseObjects() {
        int auto = this.getLooseObjectLimit();
        if (auto <= 0) {
            return false;
        }
        int n = 0;
        int threshold = (auto + 255) / 256;
        Path dir = this.repo.getObjectsDirectory().toPath().resolve("17");
        if (!dir.toFile().exists()) {
            return false;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, file -> {
            Path fileName = file.getFileName();
            return file.toFile().isFile() && fileName != null && PATTERN_LOOSE_OBJECT.matcher(fileName.toString()).matches();
        });){
            Iterator<Path> iter = stream.iterator();
            while (iter.hasNext()) {
                if (++n > threshold) {
                    boolean bl = true;
                    return bl;
                }
                iter.next();
            }
            return false;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private int getLooseObjectLimit() {
        return this.repo.getConfig().getInt("gc", "auto", 6700);
    }

    private static /* synthetic */ int lambda$writePack$6(PackExt o1, PackExt o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == PackExt.INDEX) {
            return 1;
        }
        if (o2 == PackExt.INDEX) {
            return -1;
        }
        return Integer.signum(o1.hashCode() - o2.hashCode());
    }

    public static class RepoStatistics {
        public long numberOfPackedObjects;
        public long numberOfPackFiles;
        public long numberOfLooseObjects;
        public long sizeOfLooseObjects;
        public long sizeOfPackedObjects;
        public long numberOfLooseRefs;
        public long numberOfPackedRefs;
        public long numberOfBitmaps;

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("numberOfPackedObjects=").append(this.numberOfPackedObjects);
            b.append(", numberOfPackFiles=").append(this.numberOfPackFiles);
            b.append(", numberOfLooseObjects=").append(this.numberOfLooseObjects);
            b.append(", numberOfLooseRefs=").append(this.numberOfLooseRefs);
            b.append(", numberOfPackedRefs=").append(this.numberOfPackedRefs);
            b.append(", sizeOfLooseObjects=").append(this.sizeOfLooseObjects);
            b.append(", sizeOfPackedObjects=").append(this.sizeOfPackedObjects);
            b.append(", numberOfBitmaps=").append(this.numberOfBitmaps);
            return b.toString();
        }
    }
}

