/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.InvalidRefNameException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoHeadException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.StashApplyFailureException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.WrongRepositoryStateException;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCache;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuilder;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheCheckout;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheEntry;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheIterator;
import com.jxdinfo.hussar.formdesign.jgit.errors.CheckoutConflictException;
import com.jxdinfo.hussar.formdesign.jgit.events.WorkingTreeModifiedEvent;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.CoreConfig;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectReader;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.merge.ContentMergeStrategy;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeStrategy;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevTree;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.AbstractTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.FileTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;

public class StashApplyCommand
extends GitCommand<ObjectId> {
    private static final String DEFAULT_REF = "stash@{0}";
    private String stashRef;
    private boolean restoreIndex = true;
    private boolean restoreUntracked = true;
    private boolean ignoreRepositoryState;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;

    public StashApplyCommand(Repository repo) {
        super(repo);
    }

    public StashApplyCommand setStashRef(String stashRef) {
        this.stashRef = stashRef;
        return this;
    }

    public StashApplyCommand ignoreRepositoryState(boolean willIgnoreRepositoryState) {
        this.ignoreRepositoryState = willIgnoreRepositoryState;
        return this;
    }

    private ObjectId getStashId() throws GitAPIException {
        ObjectId stashId;
        String revision = this.stashRef != null ? this.stashRef : DEFAULT_REF;
        try {
            stashId = this.repo.resolve(revision);
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision), e);
        }
        if (stashId == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision));
        }
        return stashId;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ObjectId call() throws GitAPIException, WrongRepositoryStateException, NoHeadException, StashApplyFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public void setApplyIndex(boolean applyIndex) {
        this.restoreIndex = applyIndex;
    }

    public StashApplyCommand setRestoreIndex(boolean restoreIndex) {
        this.restoreIndex = restoreIndex;
        return this;
    }

    public StashApplyCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public StashApplyCommand setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.checkCallable();
        this.contentStrategy = strategy;
        return this;
    }

    @Deprecated
    public void setApplyUntracked(boolean applyUntracked) {
        this.restoreUntracked = applyUntracked;
    }

    public StashApplyCommand setRestoreUntracked(boolean restoreUntracked) {
        this.restoreUntracked = restoreUntracked;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIndex(RevTree tree) throws IOException {
        DirCache dc = this.repo.lockDirCache();
        try (TreeWalk walk = new TreeWalk(this.repo);){
            DirCacheBuilder builder = dc.builder();
            walk.addTree(tree);
            walk.addTree(new DirCacheIterator(dc));
            walk.setRecursive(true);
            while (walk.next()) {
                AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                DirCacheIterator dcIter = walk.getTree(1, DirCacheIterator.class);
                if (dcIter != null && dcIter.idEqual(cIter)) {
                    DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
                    entry.setLastModified(indexEntry.getLastModifiedInstant());
                    entry.setLength(indexEntry.getLength());
                }
                builder.add(entry);
            }
            builder.commit();
        }
        finally {
            dc.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUntracked(RevTree tree) throws CheckoutConflictException, IOException {
        HashSet<String> actuallyModifiedPaths = new HashSet<String>();
        try (TreeWalk walk = new TreeWalk(this.repo);){
            walk.addTree(tree);
            walk.addTree(new FileTreeIterator(this.repo));
            walk.setRecursive(true);
            ObjectReader reader = walk.getObjectReader();
            while (walk.next()) {
                AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                CoreConfig.EolStreamType eolStreamType = walk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
                DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                FileTreeIterator fIter = walk.getTree(1, FileTreeIterator.class);
                if (fIter != null && fIter.isModified(entry, true, reader)) {
                    throw new CheckoutConflictException(entry.getPathString());
                }
                this.checkoutPath(entry, reader, new DirCacheCheckout.CheckoutMetadata(eolStreamType, null));
                actuallyModifiedPaths.add(entry.getPathString());
            }
        }
        finally {
            if (!actuallyModifiedPaths.isEmpty()) {
                this.repo.fireEvent(new WorkingTreeModifiedEvent(actuallyModifiedPaths, null));
            }
        }
    }

    private void checkoutPath(DirCacheEntry entry, ObjectReader reader, DirCacheCheckout.CheckoutMetadata checkoutMetadata) {
        try {
            DirCacheCheckout.checkoutEntry(this.repo, entry, reader, true, checkoutMetadata);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, entry.getPathString()), e);
        }
    }
}

