/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.lib;

import com.jxdinfo.hussar.formdesign.jgit.annotations.NonNull;
import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ObjectIdSerializer {
    private static final byte NULL_MARKER = 0;
    private static final byte NON_NULL_MARKER = 1;

    public static void write(OutputStream out, @Nullable AnyObjectId id) throws IOException {
        if (id != null) {
            out.write(1);
            ObjectIdSerializer.writeWithoutMarker(out, id);
        } else {
            out.write(0);
        }
    }

    public static void writeWithoutMarker(OutputStream out, @NonNull AnyObjectId id) throws IOException {
        id.copyRawTo(out);
    }

    @Nullable
    public static ObjectId read(InputStream in) throws IOException {
        byte marker = (byte)in.read();
        switch (marker) {
            case 0: {
                return null;
            }
            case 1: {
                return ObjectIdSerializer.readWithoutMarker(in);
            }
        }
        throw new IOException("Invalid flag before ObjectId: " + marker);
    }

    @NonNull
    public static ObjectId readWithoutMarker(InputStream in) throws IOException {
        byte[] b = new byte[20];
        IO.readFully(in, b, 0, 20);
        return ObjectId.fromRaw(b);
    }

    private ObjectIdSerializer() {
    }
}

