/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.dircache;

import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuilder;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheIterator;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheTree;
import com.jxdinfo.hussar.formdesign.jgit.errors.CorruptObjectException;
import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectReader;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.AbstractTreeIterator;
import java.io.IOException;

public class DirCacheBuildIterator
extends DirCacheIterator {
    private final DirCacheBuilder builder;

    public DirCacheBuildIterator(DirCacheBuilder dcb) {
        super(dcb.getDirCache());
        this.builder = dcb;
    }

    DirCacheBuildIterator(DirCacheBuildIterator p, DirCacheTree dct) {
        super(p, dct);
        this.builder = p.builder;
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheBuildIterator(this, this.currentSubtree);
    }

    @Override
    public void skip() throws CorruptObjectException {
        if (this.currentSubtree != null) {
            this.builder.keep(this.ptr, this.currentSubtree.getEntrySpan());
        } else {
            this.builder.keep(this.ptr, 1);
        }
        this.next(1);
    }

    @Override
    public void stopWalk() {
        int cur = this.ptr;
        int cnt = this.cache.getEntryCount();
        if (cur < cnt) {
            this.builder.keep(cur, cnt - cur);
        }
    }

    @Override
    protected boolean needsStopWalk() {
        return this.ptr < this.cache.getEntryCount();
    }
}

