/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.blame;

import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import java.io.IOException;

final class ReverseWalk
extends RevWalk {
    ReverseWalk(Repository repo) {
        super(repo);
    }

    @Override
    public ReverseCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ReverseCommit c = (ReverseCommit)super.next();
        if (c == null) {
            return null;
        }
        for (int pIdx = 0; pIdx < c.getParentCount(); ++pIdx) {
            ((ReverseCommit)c.getParent(pIdx)).addChild(c);
        }
        return c;
    }

    @Override
    protected RevCommit createCommit(AnyObjectId id) {
        return new ReverseCommit(id);
    }

    static final class ReverseCommit
    extends RevCommit {
        private static final ReverseCommit[] NO_CHILDREN = new ReverseCommit[0];
        private ReverseCommit[] children = NO_CHILDREN;

        ReverseCommit(AnyObjectId id) {
            super(id);
        }

        void addChild(ReverseCommit c) {
            int cnt = this.children.length;
            switch (cnt) {
                case 0: {
                    this.children = new ReverseCommit[]{c};
                    break;
                }
                case 1: {
                    this.children = new ReverseCommit[]{c, this.children[0]};
                    break;
                }
                default: {
                    ReverseCommit[] n = new ReverseCommit[1 + cnt];
                    n[0] = c;
                    System.arraycopy(this.children, 0, n, 1, cnt);
                    this.children = n;
                }
            }
        }

        int getChildCount() {
            return this.children.length;
        }

        ReverseCommit getChild(int nth) {
            return this.children[nth];
        }
    }
}

