/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.util.io;

import com.jxdinfo.hussar.formdesign.jgit.diff.RawText;
import java.io.IOException;
import java.io.OutputStream;

public class AutoCRLFOutputStream
extends OutputStream {
    static final int BUFFER_SIZE = 8000;
    private final OutputStream out;
    private int buf = -1;
    private byte[] binbuf = new byte[8000];
    private byte[] onebytebuf = new byte[1];
    private int binbufcnt = 0;
    private boolean detectBinary;
    private boolean isBinary;

    public AutoCRLFOutputStream(OutputStream out) {
        this(out, true);
    }

    public AutoCRLFOutputStream(OutputStream out, boolean detectBinary) {
        this.out = out;
        this.detectBinary = detectBinary;
    }

    @Override
    public void write(int b) throws IOException {
        this.onebytebuf[0] = (byte)b;
        this.write(this.onebytebuf, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        int overflow = this.buffer(b, 0, b.length);
        if (overflow > 0) {
            this.write(b, b.length - overflow, overflow);
        }
    }

    @Override
    public void write(byte[] b, int startOff, int startLen) throws IOException {
        int overflow = this.buffer(b, startOff, startLen);
        if (overflow < 0) {
            return;
        }
        int off = startOff + startLen - overflow;
        int len = overflow;
        if (len == 0) {
            return;
        }
        int lastw = off;
        if (this.isBinary) {
            this.out.write(b, off, len);
            return;
        }
        block4: for (int i = off; i < off + len; ++i) {
            byte c = b[i];
            switch (c) {
                case 13: {
                    this.buf = 13;
                    continue block4;
                }
                case 10: {
                    if (this.buf != 13) {
                        if (lastw < i) {
                            this.out.write(b, lastw, i - lastw);
                        }
                        this.out.write(13);
                        lastw = i;
                    }
                    this.buf = -1;
                    continue block4;
                }
                default: {
                    this.buf = -1;
                }
            }
        }
        if (lastw < off + len) {
            this.out.write(b, lastw, off + len - lastw);
        }
        if (b[off + len - 1] == 13) {
            this.buf = 13;
        }
    }

    private int buffer(byte[] b, int off, int len) throws IOException {
        if (this.binbufcnt > this.binbuf.length) {
            return len;
        }
        int copy = Math.min(this.binbuf.length - this.binbufcnt, len);
        System.arraycopy(b, off, this.binbuf, this.binbufcnt, copy);
        this.binbufcnt += copy;
        int remaining = len - copy;
        if (remaining > 0) {
            this.decideMode();
        }
        return remaining;
    }

    private void decideMode() throws IOException {
        if (this.detectBinary) {
            this.isBinary = RawText.isBinary(this.binbuf, this.binbufcnt);
            this.detectBinary = false;
        }
        int cachedLen = this.binbufcnt;
        this.binbufcnt = this.binbuf.length + 1;
        this.write(this.binbuf, 0, cachedLen);
    }

    @Override
    public void flush() throws IOException {
        if (this.binbufcnt <= this.binbuf.length) {
            this.decideMode();
        }
        this.buf = -1;
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

