/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.util;

import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.errors.ConfigInvalidException;
import com.jxdinfo.hussar.formdesign.jgit.util.SystemReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitoring {
    private static final Logger LOG = LoggerFactory.getLogger(Monitoring.class);

    @Nullable
    public static ObjectInstance registerMBean(Object mbean, String metricName) {
        boolean register = false;
        try {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = mbean.getClass().getInterfaces()) {
                register = SystemReader.getInstance().getUserConfig().getBoolean("jmx", i.getSimpleName(), false);
                if (!register) {
                    continue;
                }
                break;
            }
        }
        catch (ConfigInvalidException | IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (!register) {
            return null;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mbeanName = Monitoring.objectName(mbean.getClass(), metricName);
            if (server.isRegistered(mbeanName)) {
                server.unregisterMBean(mbeanName);
            }
            return server.registerMBean(mbean, mbeanName);
        }
        catch (InstanceAlreadyExistsException | InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static ObjectName objectName(Class mbean, String metricName) throws MalformedObjectNameException {
        return new ObjectName(String.format("com.jxdinfo.hussar.formdesign.jgit/%s:type=%s", metricName, mbean.getSimpleName()));
    }
}

