/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.treewalk;

import com.jxdinfo.hussar.formdesign.jgit.lib.Config;
import com.jxdinfo.hussar.formdesign.jgit.lib.CoreConfig;

public class WorkingTreeOptions {
    public static final Config.SectionParser<WorkingTreeOptions> KEY = WorkingTreeOptions::new;
    private final boolean fileMode;
    private final CoreConfig.AutoCRLF autoCRLF;
    private final CoreConfig.EOL eol;
    private final CoreConfig.CheckStat checkStat;
    private final CoreConfig.SymLinks symlinks;
    private final CoreConfig.HideDotFiles hideDotFiles;
    private final boolean dirNoGitLinks;

    private WorkingTreeOptions(Config rc) {
        this.fileMode = rc.getBoolean("core", "filemode", true);
        this.autoCRLF = rc.getEnum("core", null, "autocrlf", CoreConfig.AutoCRLF.FALSE);
        this.eol = rc.getEnum("core", null, "eol", CoreConfig.EOL.NATIVE);
        this.checkStat = rc.getEnum("core", null, "checkstat", CoreConfig.CheckStat.DEFAULT);
        this.symlinks = rc.getEnum("core", null, "symlinks", CoreConfig.SymLinks.TRUE);
        this.hideDotFiles = rc.getEnum("core", null, "hidedotfiles", CoreConfig.HideDotFiles.DOTGITONLY);
        this.dirNoGitLinks = rc.getBoolean("core", null, "dirNoGitLinks", false);
    }

    public boolean isFileMode() {
        return this.fileMode;
    }

    public CoreConfig.AutoCRLF getAutoCRLF() {
        return this.autoCRLF;
    }

    public CoreConfig.EOL getEOL() {
        return this.eol;
    }

    public CoreConfig.CheckStat getCheckStat() {
        return this.checkStat;
    }

    public CoreConfig.SymLinks getSymLinks() {
        return this.symlinks;
    }

    public CoreConfig.HideDotFiles getHideDotFiles() {
        return this.hideDotFiles;
    }

    public boolean isDirNoGitLinks() {
        return this.dirNoGitLinks;
    }
}

