/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.merge;

import com.jxdinfo.hussar.formdesign.jgit.annotations.NonNull;
import com.jxdinfo.hussar.formdesign.jgit.diff.DiffAlgorithm;
import com.jxdinfo.hussar.formdesign.jgit.diff.Edit;
import com.jxdinfo.hussar.formdesign.jgit.diff.EditList;
import com.jxdinfo.hussar.formdesign.jgit.diff.HistogramDiff;
import com.jxdinfo.hussar.formdesign.jgit.diff.Sequence;
import com.jxdinfo.hussar.formdesign.jgit.diff.SequenceComparator;
import com.jxdinfo.hussar.formdesign.jgit.merge.ContentMergeStrategy;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeChunk;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeResult;
import com.jxdinfo.hussar.formdesign.jgit.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;

public final class MergeAlgorithm {
    private final DiffAlgorithm diffAlg;
    @NonNull
    private ContentMergeStrategy strategy = ContentMergeStrategy.CONFLICT;
    private static final Edit END_EDIT = new Edit(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public MergeAlgorithm() {
        this(new HistogramDiff());
    }

    public MergeAlgorithm(DiffAlgorithm diff) {
        this.diffAlg = diff;
    }

    @NonNull
    public ContentMergeStrategy getContentMergeStrategy() {
        return this.strategy;
    }

    public void setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.strategy = strategy == null ? ContentMergeStrategy.CONFLICT : strategy;
    }

    private static boolean isEndEdit(Edit edit) {
        return edit == END_EDIT;
    }

    public <S extends Sequence> MergeResult<S> merge(SequenceComparator<S> cmp, S base, S ours, S theirs) {
        ArrayList<S> sequences = new ArrayList<S>(3);
        sequences.add(base);
        sequences.add(ours);
        sequences.add(theirs);
        MergeResult result = new MergeResult(sequences);
        if (ours.size() == 0) {
            if (theirs.size() != 0) {
                EditList theirsEdits = this.diffAlg.diff(cmp, base, theirs);
                if (!theirsEdits.isEmpty()) {
                    switch (this.strategy) {
                        case OURS: {
                            result.add(1, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
                            break;
                        }
                        case THEIRS: {
                            result.add(2, 0, theirs.size(), MergeChunk.ConflictState.NO_CONFLICT);
                            break;
                        }
                        default: {
                            result.add(1, 0, 0, MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
                            result.add(2, 0, theirs.size(), MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
                            break;
                        }
                    }
                } else {
                    result.add(1, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
                }
            } else {
                result.add(1, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
            }
            return result;
        }
        if (theirs.size() == 0) {
            EditList oursEdits = this.diffAlg.diff(cmp, base, ours);
            if (!oursEdits.isEmpty()) {
                switch (this.strategy) {
                    case OURS: {
                        result.add(1, 0, ours.size(), MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    case THEIRS: {
                        result.add(2, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    default: {
                        result.add(1, 0, ours.size(), MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
                        result.add(2, 0, 0, MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
                        break;
                    }
                }
            } else {
                result.add(2, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
            }
            return result;
        }
        EditList oursEdits = this.diffAlg.diff(cmp, base, ours);
        Iterator<Edit> baseToOurs = oursEdits.iterator();
        EditList theirsEdits = this.diffAlg.diff(cmp, base, theirs);
        Iterator<Edit> baseToTheirs = theirsEdits.iterator();
        int current = 0;
        Edit oursEdit = MergeAlgorithm.nextEdit(baseToOurs);
        Edit theirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
        while (!MergeAlgorithm.isEndEdit(theirsEdit) || !MergeAlgorithm.isEndEdit(oursEdit)) {
            int commonSuffix;
            int commonPrefix;
            int minBSize;
            int BSizeDelta;
            if (oursEdit.getEndA() <= theirsEdit.getBeginA() && oursEdit.getBeginA() < theirsEdit.getEndA()) {
                result.add(0, current, oursEdit.getBeginA(), MergeChunk.ConflictState.NO_CONFLICT);
                result.add(1, oursEdit.getBeginB(), oursEdit.getEndB(), MergeChunk.ConflictState.NO_CONFLICT);
                current = oursEdit.getEndA();
                oursEdit = MergeAlgorithm.nextEdit(baseToOurs);
                continue;
            }
            if (theirsEdit.getEndA() <= oursEdit.getBeginA() && theirsEdit.getBeginA() < oursEdit.getEndA()) {
                result.add(0, current, theirsEdit.getBeginA(), MergeChunk.ConflictState.NO_CONFLICT);
                result.add(2, theirsEdit.getBeginB(), theirsEdit.getEndB(), MergeChunk.ConflictState.NO_CONFLICT);
                current = theirsEdit.getEndA();
                theirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
                continue;
            }
            result.add(0, current, Math.min(oursEdit.getBeginA(), theirsEdit.getBeginA()), MergeChunk.ConflictState.NO_CONFLICT);
            int oursBeginB = oursEdit.getBeginB();
            int theirsBeginB = theirsEdit.getBeginB();
            int baseBeginA = Math.min(oursEdit.getBeginA(), theirsEdit.getBeginA());
            if (oursEdit.getBeginA() < theirsEdit.getBeginA()) {
                theirsBeginB -= theirsEdit.getBeginA() - oursEdit.getBeginA();
            } else {
                oursBeginB -= oursEdit.getBeginA() - theirsEdit.getBeginA();
            }
            Edit nextOursEdit = MergeAlgorithm.nextEdit(baseToOurs);
            Edit nextTheirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
            while (true) {
                if (oursEdit.getEndA() > nextTheirsEdit.getBeginA()) {
                    theirsEdit = nextTheirsEdit;
                    nextTheirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
                    continue;
                }
                if (theirsEdit.getEndA() <= nextOursEdit.getBeginA()) break;
                oursEdit = nextOursEdit;
                nextOursEdit = MergeAlgorithm.nextEdit(baseToOurs);
            }
            int baseEndA = Math.max(oursEdit.getEndA(), theirsEdit.getEndA());
            int oursEndB = oursEdit.getEndB();
            int theirsEndB = theirsEdit.getEndB();
            if (oursEdit.getEndA() < theirsEdit.getEndA()) {
                oursEndB += theirsEdit.getEndA() - oursEdit.getEndA();
            } else {
                theirsEndB += oursEdit.getEndA() - theirsEdit.getEndA();
            }
            if (oursEndB - oursBeginB == 0 && theirsEndB - theirsBeginB > 0 && baseEndA - baseBeginA > 0) {
                if (this.compareDiffChars(theirs, theirsBeginB, theirsEndB, base, baseBeginA, baseEndA, true)) {
                    result.add(1, oursBeginB, oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(0, baseEndA, baseEndA, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(2, theirsBeginB + (baseEndA - baseBeginA), theirsEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    current = baseEndA;
                    oursEdit = nextOursEdit;
                    theirsEdit = nextTheirsEdit;
                    continue;
                }
                if (this.compareDiffChars(theirs, theirsBeginB, theirsEndB, base, baseBeginA, baseEndA, false)) {
                    result.add(2, theirsBeginB, theirsEndB - (baseEndA - baseBeginA), MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(0, baseBeginA, baseBeginA, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(1, oursBeginB, oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    current = baseEndA;
                    oursEdit = nextOursEdit;
                    theirsEdit = nextTheirsEdit;
                    continue;
                }
            }
            if (oursEndB - oursBeginB > 0 && theirsEndB - theirsBeginB == 0 && baseEndA - baseBeginA > 0) {
                String baseText = base.getString(baseBeginA, baseEndA, true);
                String oursText = ours.getString(oursBeginB, oursEndB, true);
                if (this.compareDiffChars(ours, oursBeginB, oursEndB, base, baseBeginA, baseEndA, true)) {
                    result.add(2, theirsBeginB, theirsEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(0, baseEndA, baseEndA, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(1, oursBeginB + (baseEndA - baseBeginA), oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    current = baseEndA;
                    oursEdit = nextOursEdit;
                    theirsEdit = nextTheirsEdit;
                    continue;
                }
                if (this.compareDiffChars(ours, oursBeginB, oursEndB, base, baseBeginA, baseEndA, false)) {
                    result.add(1, oursBeginB, oursEndB - (baseEndA - baseBeginA), MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(0, baseBeginA, baseBeginA, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(2, theirsBeginB, theirsEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    current = baseEndA;
                    oursEdit = nextOursEdit;
                    theirsEdit = nextTheirsEdit;
                    continue;
                }
            }
            if (baseEndA - baseBeginA == 0) {
                if (this.compareDiffChars(ours, oursBeginB, oursEndB, theirs, theirsBeginB, theirsEndB, true)) {
                    result.add(1, oursBeginB, oursBeginB + (theirsEndB - theirsBeginB), MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(0, baseBeginA, baseEndA, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(1, oursBeginB + (theirsEndB - theirsBeginB), oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    current = baseEndA;
                    oursEdit = nextOursEdit;
                    theirsEdit = nextTheirsEdit;
                    continue;
                }
                if (this.compareDiffChars(ours, oursBeginB, oursEndB, theirs, theirsBeginB, theirsEndB, false)) {
                    result.add(1, oursBeginB, oursEndB - (theirsEndB - theirsBeginB), MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(0, baseBeginA, baseEndA, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(1, oursEndB - (theirsEndB - theirsBeginB), oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    current = baseEndA;
                    oursEdit = nextOursEdit;
                    theirsEdit = nextTheirsEdit;
                    continue;
                }
                if (this.compareDiffChars(theirs, theirsBeginB, theirsEndB, ours, oursBeginB, oursEndB, true)) {
                    result.add(1, oursBeginB, oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(0, baseBeginA, baseEndA, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(2, theirsBeginB + (oursEndB - oursBeginB), theirsEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    current = baseEndA;
                    oursEdit = nextOursEdit;
                    theirsEdit = nextTheirsEdit;
                    continue;
                }
                if (this.compareDiffChars(theirs, theirsBeginB, theirsEndB, ours, oursBeginB, oursEndB, false)) {
                    result.add(2, theirsBeginB, theirsEndB - (oursEndB - oursBeginB), MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(0, baseBeginA, baseEndA, MergeChunk.ConflictState.NO_CONFLICT);
                    result.add(1, oursBeginB, oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
                    current = baseEndA;
                    oursEdit = nextOursEdit;
                    theirsEdit = nextTheirsEdit;
                    continue;
                }
            }
            if ((BSizeDelta = (minBSize = oursEndB - oursBeginB) - (theirsEndB - theirsBeginB)) > 0) {
                minBSize -= BSizeDelta;
            }
            for (commonPrefix = 0; commonPrefix < minBSize && cmp.equals(ours, oursBeginB + commonPrefix, theirs, theirsBeginB + commonPrefix); ++commonPrefix) {
            }
            minBSize -= commonPrefix;
            for (commonSuffix = 0; commonSuffix < minBSize && cmp.equals(ours, oursEndB - commonSuffix - 1, theirs, theirsEndB - commonSuffix - 1); ++commonSuffix) {
            }
            minBSize -= commonSuffix;
            if (commonPrefix > 0) {
                result.add(1, oursBeginB, oursBeginB + commonPrefix, MergeChunk.ConflictState.NO_CONFLICT);
            }
            if (minBSize > 0 || BSizeDelta != 0) {
                switch (this.strategy) {
                    case OURS: {
                        result.add(1, oursBeginB + commonPrefix, oursEndB - commonSuffix, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    case THEIRS: {
                        result.add(2, theirsBeginB + commonPrefix, theirsEndB - commonSuffix, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    default: {
                        result.add(1, oursBeginB + commonPrefix, oursEndB - commonSuffix, MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
                        result.add(2, theirsBeginB + commonPrefix, theirsEndB - commonSuffix, MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
                    }
                }
            }
            if (commonSuffix > 0) {
                result.add(1, oursEndB - commonSuffix, oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
            }
            current = Math.max(oursEdit.getEndA(), theirsEdit.getEndA());
            oursEdit = nextOursEdit;
            theirsEdit = nextTheirsEdit;
        }
        if (current < base.size()) {
            result.add(0, current, base.size(), MergeChunk.ConflictState.NO_CONFLICT);
        }
        return result;
    }

    public <S extends Sequence> boolean compareDiffChars(S ours, int oBegin, int oEnd, S their, int tBegin, int tEnd, boolean positive) {
        if (oEnd - oBegin <= tEnd - tBegin) {
            return false;
        }
        boolean isEquals = true;
        int maxLine = tEnd - tBegin;
        for (int i = 0; maxLine > i && isEquals; ++i) {
            isEquals = StringUtils.equals(this.getCompareLineStr(ours, oBegin, oEnd, i, positive), this.getCompareLineStr(their, tBegin, tEnd, i, positive));
        }
        return isEquals;
    }

    private <S extends Sequence> String getCompareLineStr(S seq, int begin, int end, int i, boolean positive) {
        int lineNum = positive ? begin + i : end - i - 1;
        return seq.getString(lineNum, lineNum + 1, true).replaceAll("\\s+", "");
    }

    public <S extends Sequence> MergeResult<S> oldMerge(SequenceComparator<S> cmp, S base, S ours, S theirs) {
        ArrayList<S> sequences = new ArrayList<S>(3);
        sequences.add(base);
        sequences.add(ours);
        sequences.add(theirs);
        MergeResult result = new MergeResult(sequences);
        if (ours.size() == 0) {
            if (theirs.size() != 0) {
                EditList theirsEdits = this.diffAlg.diff(cmp, base, theirs);
                if (!theirsEdits.isEmpty()) {
                    switch (this.strategy) {
                        case OURS: {
                            result.add(1, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
                            break;
                        }
                        case THEIRS: {
                            result.add(2, 0, theirs.size(), MergeChunk.ConflictState.NO_CONFLICT);
                            break;
                        }
                        default: {
                            result.add(1, 0, 0, MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
                            result.add(2, 0, theirs.size(), MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
                            break;
                        }
                    }
                } else {
                    result.add(1, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
                }
            } else {
                result.add(1, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
            }
            return result;
        }
        if (theirs.size() == 0) {
            EditList oursEdits = this.diffAlg.diff(cmp, base, ours);
            if (!oursEdits.isEmpty()) {
                switch (this.strategy) {
                    case OURS: {
                        result.add(1, 0, ours.size(), MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    case THEIRS: {
                        result.add(2, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    default: {
                        result.add(1, 0, ours.size(), MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
                        result.add(2, 0, 0, MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
                        break;
                    }
                }
            } else {
                result.add(2, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
            }
            return result;
        }
        EditList oursEdits = this.diffAlg.diff(cmp, base, ours);
        Iterator<Edit> baseToOurs = oursEdits.iterator();
        EditList theirsEdits = this.diffAlg.diff(cmp, base, theirs);
        Iterator<Edit> baseToTheirs = theirsEdits.iterator();
        int current = 0;
        Edit oursEdit = MergeAlgorithm.nextEdit(baseToOurs);
        Edit theirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
        while (!MergeAlgorithm.isEndEdit(theirsEdit) || !MergeAlgorithm.isEndEdit(oursEdit)) {
            int commonSuffix;
            int commonPrefix;
            if (oursEdit.getEndA() < theirsEdit.getBeginA()) {
                if (current != oursEdit.getBeginA()) {
                    result.add(0, current, oursEdit.getBeginA(), MergeChunk.ConflictState.NO_CONFLICT);
                }
                result.add(1, oursEdit.getBeginB(), oursEdit.getEndB(), MergeChunk.ConflictState.NO_CONFLICT);
                current = oursEdit.getEndA();
                oursEdit = MergeAlgorithm.nextEdit(baseToOurs);
                continue;
            }
            if (theirsEdit.getEndA() < oursEdit.getBeginA()) {
                if (current != theirsEdit.getBeginA()) {
                    result.add(0, current, theirsEdit.getBeginA(), MergeChunk.ConflictState.NO_CONFLICT);
                }
                result.add(2, theirsEdit.getBeginB(), theirsEdit.getEndB(), MergeChunk.ConflictState.NO_CONFLICT);
                current = theirsEdit.getEndA();
                theirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
                continue;
            }
            if (oursEdit.getBeginA() != current && theirsEdit.getBeginA() != current) {
                result.add(0, current, Math.min(oursEdit.getBeginA(), theirsEdit.getBeginA()), MergeChunk.ConflictState.NO_CONFLICT);
            }
            int oursBeginB = oursEdit.getBeginB();
            int theirsBeginB = theirsEdit.getBeginB();
            if (oursEdit.getBeginA() < theirsEdit.getBeginA()) {
                theirsBeginB -= theirsEdit.getBeginA() - oursEdit.getBeginA();
            } else {
                oursBeginB -= oursEdit.getBeginA() - theirsEdit.getBeginA();
            }
            Edit nextOursEdit = MergeAlgorithm.nextEdit(baseToOurs);
            Edit nextTheirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
            while (true) {
                if (oursEdit.getEndA() >= nextTheirsEdit.getBeginA()) {
                    theirsEdit = nextTheirsEdit;
                    nextTheirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
                    continue;
                }
                if (theirsEdit.getEndA() < nextOursEdit.getBeginA()) break;
                oursEdit = nextOursEdit;
                nextOursEdit = MergeAlgorithm.nextEdit(baseToOurs);
            }
            int oursEndB = oursEdit.getEndB();
            int theirsEndB = theirsEdit.getEndB();
            if (oursEdit.getEndA() < theirsEdit.getEndA()) {
                oursEndB += theirsEdit.getEndA() - oursEdit.getEndA();
            } else {
                theirsEndB += oursEdit.getEndA() - theirsEdit.getEndA();
            }
            int minBSize = oursEndB - oursBeginB;
            int BSizeDelta = minBSize - (theirsEndB - theirsBeginB);
            if (BSizeDelta > 0) {
                minBSize -= BSizeDelta;
            }
            for (commonPrefix = 0; commonPrefix < minBSize && cmp.equals(ours, oursBeginB + commonPrefix, theirs, theirsBeginB + commonPrefix); ++commonPrefix) {
            }
            minBSize -= commonPrefix;
            for (commonSuffix = 0; commonSuffix < minBSize && cmp.equals(ours, oursEndB - commonSuffix - 1, theirs, theirsEndB - commonSuffix - 1); ++commonSuffix) {
            }
            minBSize -= commonSuffix;
            if (commonPrefix > 0) {
                result.add(1, oursBeginB, oursBeginB + commonPrefix, MergeChunk.ConflictState.NO_CONFLICT);
            }
            if (minBSize > 0 || BSizeDelta != 0) {
                switch (this.strategy) {
                    case OURS: {
                        result.add(1, oursBeginB + commonPrefix, oursEndB - commonSuffix, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    case THEIRS: {
                        result.add(2, theirsBeginB + commonPrefix, theirsEndB - commonSuffix, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    default: {
                        result.add(1, oursBeginB + commonPrefix, oursEndB - commonSuffix, MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
                        result.add(2, theirsBeginB + commonPrefix, theirsEndB - commonSuffix, MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
                    }
                }
            }
            if (commonSuffix > 0) {
                result.add(1, oursEndB - commonSuffix, oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
            }
            current = Math.max(oursEdit.getEndA(), theirsEdit.getEndA());
            oursEdit = nextOursEdit;
            theirsEdit = nextTheirsEdit;
        }
        if (current < base.size()) {
            result.add(0, current, base.size(), MergeChunk.ConflictState.NO_CONFLICT);
        }
        return result;
    }

    private static Edit nextEdit(Iterator<Edit> it) {
        return it.hasNext() ? it.next() : END_EDIT;
    }
}

