/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.lib;

import com.jxdinfo.hussar.formdesign.jgit.errors.ConfigInvalidException;
import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.Config;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectLoader;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectReader;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevTree;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.util.RawParseUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;

public class BlobBasedConfig
extends Config {
    public BlobBasedConfig(Config base, byte[] blob) throws ConfigInvalidException {
        super(base);
        String decoded = this.isUtf8(blob) ? RawParseUtils.decode(StandardCharsets.UTF_8, blob, 3, blob.length) : RawParseUtils.decode(blob);
        this.fromText(decoded);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId objectId) throws IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, objectId));
    }

    private static byte[] read(Repository db, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectReader or = db.newObjectReader();){
            byte[] byArray = BlobBasedConfig.read(or, blobId);
            return byArray;
        }
    }

    private static byte[] read(ObjectReader or, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader loader = or.open(blobId, 3);
        return loader.getCachedBytes(Integer.MAX_VALUE);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId treeish, String path) throws FileNotFoundException, IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, treeish, path));
    }

    private static byte[] read(Repository db, AnyObjectId treeish, String path) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectReader or = db.newObjectReader();){
            TreeWalk tree = TreeWalk.forPath(or, path, BlobBasedConfig.asTree(or, treeish));
            if (tree == null) {
                throw new FileNotFoundException(MessageFormat.format(JGitText.get().entryNotFoundByPath, path));
            }
            byte[] byArray = BlobBasedConfig.read(or, (AnyObjectId)tree.getObjectId(0));
            return byArray;
        }
    }

    private static AnyObjectId asTree(ObjectReader or, AnyObjectId treeish) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (treeish instanceof RevTree) {
            return treeish;
        }
        if (treeish instanceof RevCommit && ((RevCommit)treeish).getTree() != null) {
            return ((RevCommit)treeish).getTree();
        }
        try (RevWalk rw = new RevWalk(or);){
            ObjectId objectId = rw.parseTree(treeish).getId();
            return objectId;
        }
    }
}

