/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.CloneCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.FetchCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.Git;
import com.jxdinfo.hussar.formdesign.jgit.api.MergeCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.RebaseCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.TransportCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.CheckoutConflictException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.ConcurrentRefUpdateException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.InvalidConfigurationException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.InvalidMergeHeadsException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoHeadException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoMessageException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.RefNotFoundException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.WrongRepositoryStateException;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheCheckout;
import com.jxdinfo.hussar.formdesign.jgit.errors.ConfigInvalidException;
import com.jxdinfo.hussar.formdesign.jgit.lib.ProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.RefUpdate;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeStrategy;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.submodule.SubmoduleWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SubmoduleUpdateCommand
extends TransportCommand<SubmoduleUpdateCommand, Collection<String>> {
    private ProgressMonitor monitor;
    private final Collection<String> paths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private CloneCommand.Callback callback;
    private FetchCommand.Callback fetchCallback;
    private boolean fetch = false;

    public SubmoduleUpdateCommand(Repository repo) {
        super(repo);
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SubmoduleUpdateCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    private Repository getOrCloneSubmodule(SubmoduleWalk generator, String url) throws IOException, GitAPIException {
        Repository repository = generator.getRepository();
        if (repository == null) {
            if (this.callback != null) {
                this.callback.cloningSubmodule(generator.getPath());
            }
            CloneCommand clone = Git.cloneRepository();
            this.configure(clone);
            clone.setURI(url);
            clone.setDirectory(generator.getDirectory());
            clone.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), generator.getPath()));
            if (this.monitor != null) {
                clone.setProgressMonitor(this.monitor);
            }
            repository = clone.call().getRepository();
        } else if (this.fetch) {
            if (this.fetchCallback != null) {
                this.fetchCallback.fetchingSubmodule(generator.getPath());
            }
            FetchCommand fetchCommand = Git.wrap(repository).fetch();
            if (this.monitor != null) {
                fetchCommand.setProgressMonitor(this.monitor);
            }
            this.configure(fetchCommand);
            fetchCommand.call();
        }
        return repository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> call() throws InvalidConfigurationException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException, NoHeadException, RefNotFoundException, GitAPIException {
        this.checkCallable();
        try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            ArrayList<String> updated = new ArrayList<String>();
            while (generator.next()) {
                block44: {
                    String url;
                    if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                    try (Repository submoduleRepo = this.getOrCloneSubmodule(generator, url);
                         RevWalk walk = new RevWalk(submoduleRepo);){
                        RevCommit commit = walk.parseCommit(generator.getObjectId());
                        String update = generator.getConfigUpdate();
                        if ("merge".equals(update)) {
                            MergeCommand merge = new MergeCommand(submoduleRepo);
                            merge.include(commit);
                            merge.setProgressMonitor(this.monitor);
                            merge.setStrategy(this.strategy);
                            merge.call();
                            break block44;
                        }
                        if ("rebase".equals(update)) {
                            RebaseCommand rebase = new RebaseCommand(submoduleRepo);
                            rebase.setUpstream(commit);
                            rebase.setProgressMonitor(this.monitor);
                            rebase.setStrategy(this.strategy);
                            rebase.call();
                            break block44;
                        }
                        DirCacheCheckout co = new DirCacheCheckout(submoduleRepo, submoduleRepo.lockDirCache(), commit.getTree());
                        co.setFailOnConflict(true);
                        co.setProgressMonitor(this.monitor);
                        co.checkout();
                        RefUpdate refUpdate = submoduleRepo.updateRef("HEAD", true);
                        refUpdate.setNewObjectId(commit);
                        refUpdate.forceUpdate();
                        if (this.callback != null) {
                            this.callback.checkingOut(commit, generator.getPath());
                        }
                    }
                }
                updated.add(generator.getPath());
            }
            ArrayList<String> arrayList = updated;
            return arrayList;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public SubmoduleUpdateCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public SubmoduleUpdateCommand setCallback(CloneCommand.Callback callback) {
        this.callback = callback;
        return this;
    }

    public SubmoduleUpdateCommand setFetchCallback(FetchCommand.Callback callback) {
        this.fetchCallback = callback;
        return this;
    }
}

