/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.PackBitmapIndexV1;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.PackIndex;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.PackReverseIndex;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.util.io.SilentFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public abstract class PackBitmapIndex {
    public static final int FLAG_REUSE = 1;
    byte[] packChecksum;

    public static PackBitmapIndex open(File idxFile, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        Throwable throwable = null;
        try (SilentFileInputStream fd = new SilentFileInputStream(idxFile);){
            PackBitmapIndex packBitmapIndex = PackBitmapIndex.read(fd, packIndex, reverseIndex);
            return packBitmapIndex;
        }
        catch (IOException ioe) {
            try {
                throw new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, idxFile.getAbsolutePath()), ioe);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static PackBitmapIndex read(InputStream fd, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        return new PackBitmapIndexV1(fd, packIndex, reverseIndex);
    }

    public abstract int findPosition(AnyObjectId var1);

    public abstract ObjectId getObject(int var1) throws IllegalArgumentException;

    public abstract EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap var1, int var2);

    public abstract EWAHCompressedBitmap getBitmap(AnyObjectId var1);

    public abstract int getObjectCount();

    public abstract int getBitmapCount();
}

