/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.api.Git;
import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.MergeResult;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.CheckoutConflictException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.ConcurrentRefUpdateException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.InvalidMergeHeadsException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoHeadException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoMessageException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.WrongRepositoryStateException;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheCheckout;
import com.jxdinfo.hussar.formdesign.jgit.events.WorkingTreeModifiedEvent;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.Config;
import com.jxdinfo.hussar.formdesign.jgit.lib.NullProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectIdRef;
import com.jxdinfo.hussar.formdesign.jgit.lib.ProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.RefUpdate;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.merge.ContentMergeStrategy;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeConfig;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeMessageFormatter;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeStrategy;
import com.jxdinfo.hussar.formdesign.jgit.merge.Merger;
import com.jxdinfo.hussar.formdesign.jgit.merge.ResolveMerger;
import com.jxdinfo.hussar.formdesign.jgit.merge.SquashMessageFormatter;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalkUtils;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.FileTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.util.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MergeCommand
extends GitCommand<MergeResult> {
    private MergeStrategy mergeStrategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;
    private List<Ref> commits = new LinkedList<Ref>();
    private Boolean squash;
    private FastForwardMode fastForwardMode;
    private String message;
    private boolean insertChangeId;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private Boolean commit;

    protected MergeCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MergeResult call() throws GitAPIException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException {
        this.checkCallable();
        this.fallBackToConfiguration();
        this.checkParameters();
        DirCacheCheckout dco = null;
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Object msg;
            boolean noProblems;
            Ref head = this.repo.exactRef("HEAD");
            if (head == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            StringBuilder refLogMessage = new StringBuilder("merge ");
            Ref ref = this.commits.get(0);
            refLogMessage.append(ref.getName());
            ref = this.repo.getRefDatabase().peel(ref);
            ObjectId objectId = ref.getPeeledObjectId();
            if (objectId == null) {
                objectId = ref.getObjectId();
            }
            RevCommit srcCommit = revWalk.lookupCommit(objectId);
            ObjectId headId = head.getObjectId();
            if (headId == null) {
                revWalk.parseHeaders(srcCommit);
                dco = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), srcCommit.getTree());
                dco.setFailOnConflict(true);
                dco.setProgressMonitor(this.monitor);
                dco.checkout();
                RefUpdate refUpdate = this.repo.updateRef(head.getTarget().getName());
                refUpdate.setNewObjectId(objectId);
                refUpdate.setExpectedOldObjectId(null);
                refUpdate.setRefLogMessage("initial pull", false);
                if (refUpdate.update() != RefUpdate.Result.NEW) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                this.setCallable(false);
                MergeResult mergeResult = new MergeResult(srcCommit, srcCommit, new ObjectId[]{null, srcCommit}, MergeResult.MergeStatus.FAST_FORWARD, this.mergeStrategy, null, null);
                return mergeResult;
            }
            RevCommit headCommit = revWalk.lookupCommit(headId);
            if (revWalk.isMergedInto(srcCommit, headCommit)) {
                this.setCallable(false);
                MergeResult mergeResult = new MergeResult(headCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, this.mergeStrategy, null, null);
                return mergeResult;
            }
            if (revWalk.isMergedInto(headCommit, srcCommit) && this.fastForwardMode != FastForwardMode.NO_FF) {
                Object squashedCommits;
                ObjectId newHead;
                refLogMessage.append(": " + (Object)((Object)MergeResult.MergeStatus.FAST_FORWARD));
                dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), srcCommit.getTree());
                dco.setProgressMonitor(this.monitor);
                dco.setFailOnConflict(true);
                dco.checkout();
                String msg2 = null;
                ObjectId base = null;
                MergeResult.MergeStatus mergeStatus = null;
                if (!this.squash.booleanValue()) {
                    this.updateHead(refLogMessage, srcCommit, headId);
                    newHead = base = srcCommit;
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                } else {
                    msg2 = JGitText.get().squashCommitNotUpdatingHEAD;
                    newHead = base = headId;
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD_SQUASHED;
                    squashedCommits = RevWalkUtils.find(revWalk, srcCommit, headCommit);
                    String squashMessage = new SquashMessageFormatter().format((List<RevCommit>)squashedCommits, head);
                    this.repo.writeSquashCommitMsg(squashMessage);
                }
                this.setCallable(false);
                squashedCommits = new MergeResult(newHead, base, new ObjectId[]{headCommit, srcCommit}, mergeStatus, this.mergeStrategy, null, msg2);
                return squashedCommits;
            }
            if (this.fastForwardMode == FastForwardMode.FF_ONLY) {
                MergeResult msg2 = new MergeResult(headCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.ABORTED, this.mergeStrategy, null, null);
                return msg2;
            }
            String mergeMessage = "";
            if (!this.squash.booleanValue()) {
                mergeMessage = this.message != null ? this.message : new MergeMessageFormatter().format(this.commits, head);
                this.repo.writeMergeCommitMsg(mergeMessage);
                this.repo.writeMergeHeads(Arrays.asList(ref.getObjectId()));
            } else {
                List<RevCommit> squashedCommits = RevWalkUtils.find(revWalk, srcCommit, headCommit);
                String squashMessage = new SquashMessageFormatter().format(squashedCommits, head);
                this.repo.writeSquashCommitMsg(squashMessage);
            }
            Merger merger = this.mergeStrategy.newMerger(this.repo);
            merger.setProgressMonitor(this.monitor);
            Map<String, com.jxdinfo.hussar.formdesign.jgit.merge.MergeResult<?>> lowLevelResults = null;
            Map<String, ResolveMerger.MergeFailureReason> failingPaths = null;
            List<String> unmergedPaths = null;
            if (merger instanceof ResolveMerger) {
                ResolveMerger resolveMerger = (ResolveMerger)merger;
                resolveMerger.setContentMergeStrategy(this.contentStrategy);
                resolveMerger.setCommitNames(new String[]{"BASE", "HEAD", ref.getName()});
                resolveMerger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                noProblems = merger.merge(headCommit, srcCommit);
                lowLevelResults = resolveMerger.getMergeResults();
                failingPaths = resolveMerger.getFailingPaths();
                unmergedPaths = resolveMerger.getUnmergedPaths();
                if (!resolveMerger.getModifiedFiles().isEmpty()) {
                    this.repo.fireEvent(new WorkingTreeModifiedEvent(resolveMerger.getModifiedFiles(), null));
                }
            } else {
                noProblems = merger.merge(headCommit, srcCommit);
            }
            refLogMessage.append(": Merge made by ");
            if (!revWalk.isMergedInto(headCommit, srcCommit)) {
                refLogMessage.append(this.mergeStrategy.getName());
            } else {
                refLogMessage.append("recursive");
            }
            refLogMessage.append('.');
            if (noProblems) {
                dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                dco.setFailOnConflict(true);
                dco.setProgressMonitor(this.monitor);
                dco.checkout();
                msg = null;
                ObjectId newHeadId = null;
                MergeResult.MergeStatus mergeStatus = null;
                if (!this.commit.booleanValue() && this.squash.booleanValue()) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                }
                if (!this.commit.booleanValue() && !this.squash.booleanValue()) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_NOT_COMMITTED;
                }
                if (this.commit.booleanValue() && !this.squash.booleanValue()) {
                    try (Git git = new Git(this.getRepository());){
                        newHeadId = git.commit().setReflogComment(refLogMessage.toString()).setInsertChangeId(this.insertChangeId).call().getId();
                    }
                    mergeStatus = MergeResult.MergeStatus.MERGED;
                    this.getRepository().autoGC(this.monitor);
                }
                if (this.commit.booleanValue() && this.squash.booleanValue()) {
                    msg = JGitText.get().squashCommitNotUpdatingHEAD;
                    newHeadId = headCommit.getId();
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED;
                }
                MergeResult mergeResult = new MergeResult(newHeadId, null, new ObjectId[]{headCommit.getId(), srcCommit.getId()}, mergeStatus, this.mergeStrategy, null, (String)msg);
                return mergeResult;
            }
            if (failingPaths != null) {
                this.repo.writeMergeCommitMsg(null);
                this.repo.writeMergeHeads(null);
                msg = new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.FAILED, this.mergeStrategy, lowLevelResults, failingPaths, null);
                return msg;
            }
            String mergeMessageWithConflicts = new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths);
            this.repo.writeMergeCommitMsg(mergeMessageWithConflicts);
            MergeResult mergeResult = new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.CONFLICTING, this.mergeStrategy, lowLevelResults, null);
            return mergeResult;
        }
        catch (com.jxdinfo.hussar.formdesign.jgit.errors.CheckoutConflictException e) {
            List<String> conflicts = dco == null ? Collections.emptyList() : dco.getConflicts();
            throw new CheckoutConflictException(conflicts, e);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfMergeCommand, e), e);
        }
    }

    private void checkParameters() throws InvalidMergeHeadsException {
        if (this.squash.booleanValue() && this.fastForwardMode == FastForwardMode.NO_FF) {
            throw new JGitInternalException(JGitText.get().cannotCombineSquashWithNoff);
        }
        if (this.commits.size() != 1) {
            throw new InvalidMergeHeadsException(this.commits.isEmpty() ? JGitText.get().noMergeHeadSpecified : MessageFormat.format(JGitText.get().mergeStrategyDoesNotSupportHeads, this.mergeStrategy.getName(), this.commits.size()));
        }
    }

    private void fallBackToConfiguration() {
        MergeConfig config = MergeConfig.getConfigForCurrentBranch(this.repo);
        if (this.squash == null) {
            this.squash = config.isSquash();
        }
        if (this.commit == null) {
            this.commit = config.isCommit();
        }
        if (this.fastForwardMode == null) {
            this.fastForwardMode = config.getFastForwardMode();
        }
    }

    private void updateHead(StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID) throws IOException, ConcurrentRefUpdateException {
        RefUpdate refUpdate = this.repo.updateRef("HEAD");
        refUpdate.setNewObjectId(newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId(oldHeadID);
        RefUpdate.Result rc = refUpdate.update();
        switch (rc) {
            case NEW: 
            case FAST_FORWARD: {
                return;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", newHeadId.toString(), rc}));
    }

    public MergeCommand setStrategy(MergeStrategy mergeStrategy) {
        this.checkCallable();
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    public MergeCommand setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.checkCallable();
        this.contentStrategy = strategy;
        return this;
    }

    public MergeCommand include(Ref aCommit) {
        this.checkCallable();
        this.commits.add(aCommit);
        return this;
    }

    public MergeCommand include(AnyObjectId aCommit) {
        return this.include(aCommit.getName(), aCommit);
    }

    public MergeCommand include(String name, AnyObjectId aCommit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, aCommit.copy()));
    }

    public MergeCommand setSquash(boolean squash) {
        this.checkCallable();
        this.squash = squash;
        return this;
    }

    public MergeCommand setFastForward(@Nullable FastForwardMode fastForwardMode) {
        this.checkCallable();
        this.fastForwardMode = fastForwardMode;
        return this;
    }

    public MergeCommand setCommit(boolean commit) {
        this.commit = commit;
        return this;
    }

    public MergeCommand setMessage(String message) {
        this.message = message;
        return this;
    }

    public MergeCommand setInsertChangeId(boolean insertChangeId) {
        this.checkCallable();
        this.insertChangeId = insertChangeId;
        return this;
    }

    public MergeCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public static enum FastForwardMode implements Config.ConfigEnum
    {
        FF,
        NO_FF,
        FF_ONLY;


        @Override
        public String toConfigValue() {
            return "--" + this.name().toLowerCase(Locale.ROOT).replace('_', '-');
        }

        @Override
        public boolean matchConfigValue(String in) {
            if (StringUtils.isEmptyOrNull(in)) {
                return false;
            }
            if (!in.startsWith("--")) {
                return false;
            }
            return this.name().equalsIgnoreCase(in.substring(2).replace('-', '_'));
        }

        public static FastForwardMode valueOf(Merge ffMode) {
            switch (ffMode) {
                case FALSE: {
                    return NO_FF;
                }
                case ONLY: {
                    return FF_ONLY;
                }
            }
            return FF;
        }

        public static enum Merge {
            TRUE,
            FALSE,
            ONLY;


            public static Merge valueOf(FastForwardMode ffMode) {
                switch (ffMode) {
                    case NO_FF: {
                        return FALSE;
                    }
                    case FF_ONLY: {
                        return ONLY;
                    }
                }
                return TRUE;
            }
        }
    }

    public static enum ConflictStyle {
        MERGE,
        DIFF3;

    }
}

