/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableIndex;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerModelFunction;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerQueryDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerEditDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.index.SqlServerDataModelIndex;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class SqlServerDataModelUtil {
    public static final String SLAVE_PAGE_VO = "SlavePageVO";
    public static final String PAGE_VO = "PageVO";
    private static final Pattern TPATTERN = Pattern.compile("[A-Z0-9]");

    public static SqlServerDataModelBase transfer(DataModelBase dataModelBase) throws LcdpException {
        SqlServerModelFunction modelFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        return modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)dataModelBase.getId()));
    }

    public static SqlServerDataModelBase transfer(JSONObject jsonObject) throws LcdpException {
        SqlServerModelFunction modelFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(String.valueOf(jsonObject.get((Object)"functionType")));
        return modelFunction.parseDataModel(jsonObject);
    }

    public static SqlServerDataModelBase transfer(String jsonData) throws LcdpException {
        DataModelBase dataModel = (DataModelBase)JSONObject.parseObject((String)jsonData, DataModelBase.class);
        SqlServerModelFunction modelFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        return modelFunction.parseDataModel(JSONObject.parseObject((String)jsonData));
    }

    public static SqlServerDataModelField getModelFieldById(List<SqlServerDataModelField> fields, String fieldId) {
        return fields.stream().filter(field -> field.getId().equals(fieldId)).findFirst().orElseGet(SqlServerDataModelField::new);
    }

    public static void addQueryPageVo(SqlServerDataModelBaseDTO dataModelBaseDTO) {
        SqlServerQueryDTO queryDTO = new SqlServerQueryDTO();
        queryDTO.setFtlPath("template/sqlserver/backcode/code/page.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }

    public static void addSlaveQueryPageVo(SqlServerDataModelBaseDTO dataModelBaseDTO, SqlServerDataModelOperation dataModelOperation) {
        SqlServerQueryDTO queryDTO = new SqlServerQueryDTO();
        queryDTO.setFtlPath("template/sqlserver/backcode/code/slave_page.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + SLAVE_PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + SLAVE_PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }

    public static String camelToUnderLine(String str) {
        Matcher matcher = TPATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static void addQueryPageViewVo(SqlServerDataModelBaseDTO dataModelBaseDTO) {
        SqlServerDataModelUtil.addQueryPageVo(dataModelBaseDTO);
    }

    public static void addQueryPageMsVo(SqlServerDataModelBaseDTO msdataModelBaseDTO) {
        SqlServerDataModelUtil.addQueryPageVo(msdataModelBaseDTO);
    }

    public static SqlServerQueryDTO getQueryDto(DataSet dataSet, SqlServerDataModelBaseDTO dataModelDTO) {
        SqlServerQueryDTO queryDto;
        block4: {
            block3: {
                queryDto = new SqlServerQueryDTO();
                queryDto.setId(dataSet.getId());
                queryDto.setName(EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
                queryDto.setComment(dataSet.getComment());
                Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
                queryDto.setPackageInfo(packageInfo.get("dto"));
                queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
                queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
                queryDto.setFtlPath("template/sqlserver/backcode/code/queryDto.ftl");
                HashMap<String, Object> params = new HashMap<String, Object>();
                HashMap<String, Boolean> table = new HashMap<String, Boolean>();
                table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
                params.put("table", table);
                params.put("queryDto", queryDto);
                queryDto.setParams(params);
                queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
                if (!dataSet.getDataSetObject().getObjectType().equals(ComponentData.DataSetObjectTypeEnum.DATA_MODEL.getValue())) break block3;
                queryDto.setDataModel(true);
                if (!ToolUtil.isNotEmpty(dataModelDTO.getFields())) break block4;
                for (SqlServerDataModelFieldDto field : dataModelDTO.getFields()) {
                    SqlServerQueryFieldDTO queryVOFieldDto = new SqlServerQueryFieldDTO();
                    queryVOFieldDto.setComment(field.getComment());
                    queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)field.getColumnType().getType()));
                    queryVOFieldDto.setPropertyName(field.getName());
                    queryDto.addVOField(queryVOFieldDto);
                }
                break block4;
            }
            if (ToolUtil.isNotEmpty((Object)dataSet.getDataSetObject().getProperties())) {
                List<SqlServerQueryFieldDTO> queryVOFields = SqlServerDataModelUtil.addQueryVOField(dataSet.getDataSetObject().getProperties(), queryDto);
                for (SqlServerQueryFieldDTO queryVOField : queryVOFields) {
                    queryDto.addVOField(queryVOField);
                }
            }
        }
        return queryDto;
    }

    public static SqlServerQueryDTO getFilterDto(SqlServerDataModelBaseDTO dataModelDTO) {
        SqlServerQueryDTO queryDto = new SqlServerQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setImports(Collections.singleton(dataModelDTO.getImportInfo().get("Entity")));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setFtlPath("template/sqlserver/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        params.put("queryDto", queryDto);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static SqlServerQueryDTO getTotalQueryDto(SqlServerDataModelBaseDTO dataModelDTO) {
        SqlServerQueryDTO queryDto = new SqlServerQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelDTO.getName() + "TotalQuery"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setFtlPath("template/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryDto", queryDto);
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static List<SqlServerQueryFieldDTO> addQueryVOField(List<ValueObjectProperty> properties, SqlServerQueryDTO queryDto) {
        ArrayList<SqlServerQueryFieldDTO> children = new ArrayList<SqlServerQueryFieldDTO>();
        for (ValueObjectProperty property : properties) {
            SqlServerQueryFieldDTO queryVOFieldDto = new SqlServerQueryFieldDTO();
            queryVOFieldDto.setComment(property.getComment());
            queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)property.getBaseDataType()));
            queryVOFieldDto.setType(property.getBaseDataType());
            queryVOFieldDto.setPropertyName(property.getName());
            if (ToolUtil.isNotEmpty((Object)property.getProperties())) {
                queryVOFieldDto.setChildren(SqlServerDataModelUtil.addQueryVOField(property.getProperties(), queryDto));
            }
            children.add(queryVOFieldDto);
            if (null == queryVOFieldDto.getDbColumnType() || null == queryVOFieldDto.getDbColumnType().getImportT()) continue;
            queryDto.addImport(queryVOFieldDto.getDbColumnType().getImportT());
        }
        return children;
    }

    public static PropertyType getEntityPropertyType(String type, SqlServerDataModelBaseDTO dataModelDto) {
        PropertyType propertyType = null;
        if (ToolUtil.isNotEmpty((Object)type)) {
            propertyType = new PropertyType();
            propertyType.setImportT(dataModelDto.getImportInfo().get("Entity"));
            String modelName = dataModelDto.getEntityName();
            if (type.equals("array")) {
                propertyType.setType("List<${model}>".replace("${model}", modelName));
            } else if (type.equals("object")) {
                propertyType.setType(modelName);
            }
        }
        return propertyType;
    }

    public static ContrastVO<SqlServerDataModelField> contrastWith(List<TableField> tableFields, List<SqlServerDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList delFields = new ArrayList();
        ArrayList<SqlServerDataModelField> modifyFields = new ArrayList<SqlServerDataModelField>();
        ArrayList fieldList = new ArrayList();
        CollectionUtils.addAll(fieldList, (Object[])new Object[modelFields.size()]);
        Collections.copy(fieldList, modelFields);
        for (TableField tableField : tableFields) {
            SqlServerDataModelField field = fieldList.stream().filter(e -> e.getSourceFieldName().equalsIgnoreCase(tableField.getName())).findFirst().orElseGet(SqlServerDataModelField::new);
            if (!ToolUtil.isNotEmpty((Object)((Object)field)) || field.getSourceFieldName() == null) continue;
            fieldList.remove((Object)field);
            addTableFields.remove(tableField);
            if (field.getSourceDataType().equalsIgnoreCase(tableField.getType()) && field.getDataIsEmpty() == tableField.getDataIsEmpty() && field.getDataLength() == tableField.getDataLength() && field.getDataDot() == tableField.getDataDot() && HussarUtils.equals((Object)field.getComment(), (Object)tableField.getComment()) && "primary".equals(field.getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableField.getPrimarys())) continue;
            modifyFields.add(SqlServerDataModelUtil.tabTransmodelOne(tableField, field.getId()));
        }
        if (!fieldList.isEmpty()) {
            delFields.addAll(fieldList);
        }
        List<SqlServerDataModelField> addFields = SqlServerDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<SqlServerDataModelField> pushContrastWith(List<TableField> tableFields, List<SqlServerDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<SqlServerDataModelField> delFields = new ArrayList<SqlServerDataModelField>();
        ArrayList<SqlServerDataModelField> modifyFields = new ArrayList<SqlServerDataModelField>();
        for (SqlServerDataModelField modelField : modelFields) {
            boolean flag = false;
            for (TableField tableField : tableFields) {
                if (!modelField.getSourceFieldName().equalsIgnoreCase(tableField.getName())) continue;
                flag = true;
                addTableFields.remove(tableField);
                if (modelField.getSourceDataType().equalsIgnoreCase(tableField.getType()) && modelField.getDataIsEmpty() == tableField.getDataIsEmpty() && "primary".equals(modelField.getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableField.getPrimarys())) break;
                modifyFields.add(SqlServerDataModelUtil.tabTransmodelOne(tableField, modelField.getId()));
            }
            if (flag) continue;
            delFields.add(modelField);
        }
        List<SqlServerDataModelField> addFields = SqlServerDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<SqlServerDataModelField> contrastWithView(List<TableField> tableFields, List<SqlServerDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<SqlServerDataModelField> delFields = new ArrayList<SqlServerDataModelField>();
        ArrayList<SqlServerDataModelField> modifyFields = new ArrayList<SqlServerDataModelField>();
        for (SqlServerDataModelField modelField : modelFields) {
            boolean flag = false;
            for (TableField tableField : tableFields) {
                if (!modelField.getSourceFieldName().equalsIgnoreCase(tableField.getName())) continue;
                flag = true;
                addTableFields.remove(tableField);
                if (modelField.getSourceDataType().equalsIgnoreCase(tableField.getType()) && modelField.getDataIsEmpty() == tableField.getDataIsEmpty() && modelField.getDataLength() == tableField.getDataLength() && modelField.getDataDot() == tableField.getDataDot()) break;
                modifyFields.add(SqlServerDataModelUtil.tabTransmodelOne(tableField, modelField.getId()));
            }
            if (flag) continue;
            delFields.add(modelField);
        }
        List<SqlServerDataModelField> addFields = SqlServerDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<SqlServerDataModelField> contrastWithIgnoreCase(List<TableField> tableFields, List<SqlServerDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<SqlServerDataModelField> delFields = new ArrayList<SqlServerDataModelField>();
        ArrayList<SqlServerDataModelField> modifyFields = new ArrayList<SqlServerDataModelField>();
        for (SqlServerDataModelField modelField : modelFields) {
            boolean flag = false;
            for (TableField tableField : tableFields) {
                if (!modelField.getSourceFieldName().equals(tableField.getName())) continue;
                flag = true;
                addTableFields.remove(tableField);
                if (modelField.getSourceDataType().equalsIgnoreCase(tableField.getType()) && modelField.getDataIsEmpty() == tableField.getDataIsEmpty() && modelField.getDataLength() == tableField.getDataLength() && modelField.getDataDot() == tableField.getDataDot()) break;
                modifyFields.add(SqlServerDataModelUtil.tabTransmodelOne(tableField, modelField.getId()));
            }
            if (flag) continue;
            delFields.add(modelField);
        }
        List<SqlServerDataModelField> addFields = SqlServerDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<SqlServerDataModelField> mcontrastWith(List<TableField> tableFields, List<SqlServerDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<SqlServerDataModelField> addFields = new ArrayList<SqlServerDataModelField>();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<SqlServerDataModelField> modifyFields = new ArrayList<SqlServerDataModelField>();
        for (SqlServerDataModelField modelField : modelFields) {
            boolean flag = false;
            for (TableField tableField : tableFields) {
                if (!modelField.getSourceFieldName().equals(tableField.getName())) continue;
                flag = true;
                addTableFields.remove(tableField);
                if (modelField.getSourceDataType().equalsIgnoreCase(tableField.getType()) && modelField.getDataIsEmpty() == tableField.getDataIsEmpty() && modelField.getDataLength() == tableField.getDataLength() && modelField.getDataDot() == tableField.getDataDot() && HussarUtils.equals((Object)modelField.getComment(), (Object)tableField.getComment()) && "primary".equals(modelField.getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableField.getPrimarys())) break;
                modifyFields.add(modelField);
            }
            if (flag) continue;
            addFields.add(modelField);
        }
        List<SqlServerDataModelField> delFields = SqlServerDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastIndexVO<SqlServerDataModelIndex> contrastIndexWith(List<TableIndex> tableIndexs, List<SqlServerDataModelIndex> modelIndexs, TableCorrespond modelFislds) {
        boolean flag;
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<SqlServerDataModelIndex> addIndexs = new ArrayList<SqlServerDataModelIndex>();
        ArrayList<SqlServerDataModelIndex> delIndexs = new ArrayList<SqlServerDataModelIndex>();
        if (!HussarUtils.isEmpty(tableIndexs)) {
            if (!HussarUtils.isEmpty(modelIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(modelIndexs.get(i));
                        addIndexs.add(SqlServerDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                    }
                    if (flag) continue;
                    delIndexs.add(modelIndexs.get(i));
                }
                addIndexs.addAll(SqlServerDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(SqlServerDataModelUtil.tabTransmodelIndex(tableIndexs));
            }
        } else if (!HussarUtils.isEmpty(modelIndexs)) {
            delIndexs.addAll(modelIndexs);
        }
        if (HussarUtils.isNotEmpty((Object)modelFislds)) {
            List modifyFields;
            ArrayList fields = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)modelFislds.getAddFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getAddFields(), SqlServerDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)modelFislds.getDelFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getDelFields(), SqlServerDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)(modifyFields = JSONArray.parseArray((String)modelFislds.getModifyFields(), SqlServerEditDataModelField.class)))) {
                fields.addAll(modifyFields.stream().map(SqlServerEditDataModelField::getNewField).collect(Collectors.toList()));
            }
            flag = false;
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(delIndexs)) {
                Iterator iterator = delIndexs.iterator();
                while (iterator.hasNext()) {
                    SqlServerDataModelIndex delIndex = (SqlServerDataModelIndex)((Object)iterator.next());
                    for (SqlServerDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(delIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(addIndexs)) {
                Iterator iterator = addIndexs.iterator();
                while (iterator.hasNext()) {
                    SqlServerDataModelIndex addIndex = (SqlServerDataModelIndex)((Object)iterator.next());
                    for (SqlServerDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(addIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static ContrastIndexVO<SqlServerDataModelIndex> mcontrastIndexWith(List<TableIndex> tableIndexs, List<SqlServerDataModelIndex> modelIndexs) {
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<SqlServerDataModelIndex> addIndexs = new ArrayList<SqlServerDataModelIndex>();
        ArrayList<SqlServerDataModelIndex> delIndexs = new ArrayList<SqlServerDataModelIndex>();
        if (!HussarUtils.isEmpty(modelIndexs)) {
            if (!HussarUtils.isEmpty(tableIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    boolean flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(SqlServerDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                        addIndexs.add(modelIndexs.get(i));
                    }
                    if (flag) continue;
                    addIndexs.add(modelIndexs.get(i));
                }
                delIndexs.addAll(SqlServerDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(modelIndexs);
            }
        } else if (!HussarUtils.isEmpty(tableIndexs)) {
            delIndexs.addAll(SqlServerDataModelUtil.tabTransmodelIndex(tableIndexs));
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static List<SqlServerDataModelField> tabTransmodel(List<TableField> tableFields) {
        ArrayList<SqlServerDataModelField> modelFields = new ArrayList<SqlServerDataModelField>();
        tableFields.forEach(tab -> {
            SqlServerDataModelField field = new SqlServerDataModelField();
            field.setSourceFieldName(tab.getName());
            field.setDataIsEmpty(tab.getDataIsEmpty());
            field.setDataLength(tab.getDataLength());
            field.setDataDot(tab.getDataDot());
            field.setComment(tab.getComment());
            field.setSourceDataType(tab.getType().toUpperCase());
            if ("PRI".equals(tab.getPrimarys())) {
                field.setUsage("primary");
            }
            field.setDataDefaultValue(tab.getDataDefaultValue());
            modelFields.add(field);
        });
        return modelFields;
    }

    public static SqlServerDataModelField tabTransmodelOne(TableField tableFields, String id) {
        SqlServerDataModelField field = new SqlServerDataModelField();
        field.setId(id);
        field.setSourceFieldName(tableFields.getName());
        field.setDataIsEmpty(tableFields.getDataIsEmpty());
        field.setDataLength(tableFields.getDataLength());
        field.setDataDot(tableFields.getDataDot());
        field.setComment(tableFields.getComment());
        if ("PRI".equals(tableFields.getPrimarys())) {
            field.setUsage("primary");
        }
        field.setDataDefaultValue(tableFields.getDataDefaultValue());
        field.setSourceDataType(tableFields.getType().toUpperCase());
        return field;
    }

    public static List<SqlServerDataModelIndex> tabTransmodelIndex(List<TableIndex> tableIndexs) {
        ArrayList<SqlServerDataModelIndex> modelIndexs = new ArrayList<SqlServerDataModelIndex>();
        if (tableIndexs != null) {
            tableIndexs.forEach(tab -> {
                SqlServerDataModelIndex index = new SqlServerDataModelIndex();
                index.setIndexName(tab.getIndexName().toUpperCase());
                index.setChkUnique(tab.getIsNonUnique() == 0);
                index.setTableSchema(tab.getTableSchema());
                index.setColumnName(tab.getColumnName().toUpperCase());
                index.setIndexType(tab.getIndexType());
                index.setTableName(tab.getTableName().toUpperCase());
                modelIndexs.add(index);
            });
        }
        return modelIndexs;
    }

    public static SqlServerDataModelIndex tabTransmodelIndexOne(TableIndex tableIndex, String indexName) {
        SqlServerDataModelIndex index = new SqlServerDataModelIndex();
        index.setIndexName(indexName.toUpperCase());
        index.setChkUnique(tableIndex.getIsNonUnique() == 0);
        index.setTableSchema(tableIndex.getTableSchema());
        index.setColumnName(tableIndex.getColumnName().toUpperCase());
        index.setIndexType(tableIndex.getIndexType());
        index.setTableName(tableIndex.getTableName().toUpperCase());
        return index;
    }
}

