/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.service.WorkFlowVisitorService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerModelFunction;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerFlowCodeGeneratorModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerFlowTableServerModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerModelBeanUtil;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.CallActivityTable;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerWorkFlowVisitorServiceImpl
implements WorkFlowVisitorService {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerWorkFlowVisitorServiceImpl.class);
    private static final Pattern regex = Pattern.compile("@\\{([^@]|[^}]@)*}@");
    private static final String FTL_NAME = "template/sqlserver/workflow/visitor/code_bpm_generator.ftl";
    private static final String FTL_NAME_NEW = "template/sqlserver/workflow/visitor/code_bpm_generator_new.ftl";
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        FlowModel flowModel;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (ToolUtil.isNotEmpty((Object)modelName) && !File.separator.equals(modelName.substring(0, 1))) {
            modelName = File.separator + modelName;
        }
        if ((flowModel = this.readWfd(modelName, workFlowName)) == null) {
            return result;
        }
        String keyName = identityKey.split(":")[0] + identityKey.split(":")[1];
        keyName = keyName.replace("-", "").replace("_", "");
        workFlowName = identityKey.split(":")[0];
        workFlowName = workFlowName.replace("_", "");
        String saveJavaFilePathPrefix = this.pathStrategy.javaPathService().backProjectJava(new String[]{"bpmvisitor", modelName, workFlowName}).getLocalPath().toLowerCase();
        String saveJavaFilePath = FileUtil.systemPath((String[])new String[]{saveJavaFilePathPrefix, keyName.toLowerCase()});
        List flowObjects = flowModel.getSlots().getElement();
        Map<String, String> map = this.getOldVisitorKey(saveJavaFilePathPrefix, identityKey, oldVersion);
        String startNode = "";
        String firstNode = "";
        ArrayList annoUseVariables = new ArrayList();
        for (FlowObject flowObject1 : flowModel.getSlots().getElement()) {
            if (BpmNodeTypeUtil.isStart((String)flowObject1.getName())) {
                startNode = flowObject1.getInstanceKey();
            }
            if (!BpmNodeTypeUtil.isAnnotation((String)flowObject1.getName()) || !ToolUtil.isNotEmpty((Object)flowObject1.getProps().getUseVariables())) continue;
            annoUseVariables.addAll(flowObject1.getProps().getUseVariables());
        }
        for (FlowSequence flowSequence : flowModel.getSlots().getPath()) {
            if (!flowSequence.getStart().getKey().equals(startNode)) continue;
            firstNode = flowSequence.getEnd().getKey();
        }
        for (FlowObject flowObject : flowObjects) {
            FlowRecipients flowRecipients;
            List<FlowVariables> flowVariables;
            File old;
            String oldFileName;
            String oldPartentPath;
            HashMap<String, String> file;
            Map.Entry<Boolean, String> entry;
            if (BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) {
                List subFlowObjects = flowObject.getSlots().getElement();
                for (FlowObject subFlowObject : subFlowObjects) {
                    FlowRecipients flowRecipients2;
                    List<FlowVariables> flowVariables2;
                    if (!BpmNodeTypeUtil.isUserTask((String)subFlowObject.getName())) continue;
                    List list = flowVariables2 = subFlowObject.getProps().getUseVariables() == null ? new ArrayList() : subFlowObject.getProps().getUseVariables();
                    if (flowModel.getProps().getUseVariables() != null) {
                        flowVariables2.addAll(flowModel.getProps().getUseVariables());
                    }
                    HashSet functionIds = new HashSet();
                    FlowAssignment flowAssignment = subFlowObject.getProps().getFlowAssignment();
                    if (ToolUtil.isNotEmpty((Object)flowAssignment)) {
                        this.getFunctionIds(flowAssignment.getDefaultBackCondtion(), functionIds);
                        if (ToolUtil.isNotEmpty((Object)flowAssignment.getJudgeBackCondition())) {
                            for (Object judgeBackCondition : flowAssignment.getJudgeBackCondition()) {
                                this.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                            }
                        }
                    }
                    if (ToolUtil.isNotEmpty((Object)(flowRecipients2 = subFlowObject.getProps().getFlowRecipients()))) {
                        this.getFunctionIds(flowRecipients2.getDefaultCcCondtion(), functionIds);
                        if (ToolUtil.isNotEmpty((Object)flowRecipients2.getJudgeCcCondition())) {
                            Object judgeBackCondition;
                            judgeBackCondition = flowRecipients2.getJudgeCcCondition().iterator();
                            while (judgeBackCondition.hasNext()) {
                                JudgeBackCondition judgeBackCondition2 = (JudgeBackCondition)judgeBackCondition.next();
                                this.getFunctionIds(judgeBackCondition2.getJudgeSpellCondition(), functionIds);
                            }
                        }
                    }
                    List flowFunctionConfigs = subFlowObject.getProps().getFlowFunctionConfig();
                    ArrayList functionUserVariables = new ArrayList();
                    if (ToolUtil.isNotEmpty((Object)flowFunctionConfigs)) {
                        Iterator iterator = flowFunctionConfigs.iterator();
                        while (iterator.hasNext()) {
                            FlowFunctionConfig flowFunctionConfig = (FlowFunctionConfig)iterator.next();
                            if (!functionIds.contains(flowFunctionConfig.getId()) || !ToolUtil.isNotEmpty((Object)flowFunctionConfig.getUseVariables())) continue;
                            functionUserVariables.addAll(flowFunctionConfig.getUseVariables());
                        }
                    }
                    if (ToolUtil.isNotEmpty(functionUserVariables)) {
                        flowVariables2.addAll(functionUserVariables);
                    }
                    String instanceKey = ToolUtil.isEmpty((Object)subFlowObject.getProps().getNodeId()) ? subFlowObject.getInstanceKey() : subFlowObject.getProps().getNodeId();
                    ArrayList<FlowVariables> delFlowVariables = new ArrayList<FlowVariables>();
                    for (FlowVariables flowVariable : flowVariables2) {
                        if (!"bpm_next_node".equals(flowVariable.getVariable())) continue;
                        delFlowVariables.add(flowVariable);
                    }
                    flowVariables2.removeAll(delFlowVariables);
                    CallActivityTable callActivityTable = subFlowObject.getProps().getCallActivityTable();
                    if (flowVariables2.isEmpty() && (callActivityTable == null || HussarUtils.isEmpty((Object)callActivityTable.getTableId()))) continue;
                    String codeGeneratorModelName = FileUtil.systemPath((String[])new String[]{this.pathStrategy.javaPathService().getJavaPath(), "bpmvisitor", modelName, workFlowName}).toLowerCase();
                    SqlServerFlowCodeGeneratorModel sqlServerFlowCodeGeneratorModel = this.getData(codeGeneratorModelName, identityKey, instanceKey, flowVariables2, modelId, callActivityTable, false);
                    if (sqlServerFlowCodeGeneratorModel == null) {
                        return null;
                    }
                    String fileName = keyName.substring(0, 1).toUpperCase() + keyName.substring(1) + sqlServerFlowCodeGeneratorModel.getInstanceKey().substring(0, 1).toUpperCase() + sqlServerFlowCodeGeneratorModel.getInstanceKey().substring(1) + "Visitor.java";
                    this.setParam(sqlServerFlowCodeGeneratorModel, modelId);
                    Map<Boolean, String> newResult = this.newJavaFile(sqlServerFlowCodeGeneratorModel, saveJavaFilePath + File.separator + fileName, workflowId);
                    entry = newResult.entrySet().iterator().next();
                    if (Boolean.FALSE.equals(entry.getKey())) {
                        return result;
                    }
                    file = new HashMap<String, String>();
                    file.put("newFilePath", saveJavaFilePath + File.separator + fileName);
                    if (HussarUtils.isEmpty((Object)organId)) {
                        file.put("dataId", identityKey.split(":")[0] + (String)instanceKey);
                    } else {
                        file.put("dataId", identityKey.split(":")[0] + "-" + organId + "-" + (String)instanceKey);
                    }
                    if (HussarUtils.isEmpty((Object)newOrganId)) {
                        file.put("newDataId", identityKey.split(":")[0] + (String)instanceKey);
                    } else {
                        file.put("newDataId", identityKey.split(":")[0] + "-" + newOrganId + "-" + (String)instanceKey);
                    }
                    file.put("fileContent", entry.getValue());
                    if (map != null) {
                        oldPartentPath = map.get("parentPath");
                        oldFileName = fileName.replace(keyName.substring(0, 1).toUpperCase() + keyName.substring(1), map.get("oldKey").substring(0, 1).toUpperCase() + map.get("oldKey").substring(1));
                        old = new File(oldPartentPath + File.separator + oldFileName);
                        if (FileUtils.exists((File)old)) {
                            file.put("oldFilePath", oldPartentPath + File.separator + oldFileName);
                        }
                    }
                    result.add(file);
                }
            } else if (!BpmNodeTypeUtil.isUserTask((String)flowObject.getName()) && !BpmNodeTypeUtil.isCallActivity((String)flowObject.getName())) continue;
            boolean isCallActivity = BpmNodeTypeUtil.isCallActivity((String)flowObject.getName());
            List list = flowVariables = flowObject.getProps().getUseVariables() == null ? new ArrayList() : flowObject.getProps().getUseVariables();
            if (flowModel.getProps().getUseVariables() != null) {
                flowVariables.addAll(flowModel.getProps().getUseVariables());
            }
            HashSet<String> functionIds = new HashSet<String>();
            FlowAssignment flowAssignment = flowObject.getProps().getFlowAssignment();
            if (ToolUtil.isNotEmpty((Object)flowAssignment)) {
                this.getFunctionIds(flowAssignment.getDefaultBackCondtion(), functionIds);
                if (ToolUtil.isNotEmpty((Object)flowAssignment.getJudgeBackCondition())) {
                    for (Object judgeBackCondition : flowAssignment.getJudgeBackCondition()) {
                        this.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)(flowRecipients = flowObject.getProps().getFlowRecipients()))) {
                this.getFunctionIds(flowRecipients.getDefaultCcCondtion(), functionIds);
                if (ToolUtil.isNotEmpty((Object)flowRecipients.getJudgeCcCondition())) {
                    Object judgeBackCondition;
                    judgeBackCondition = flowRecipients.getJudgeCcCondition().iterator();
                    while (judgeBackCondition.hasNext()) {
                        JudgeBackCondition judgeBackCondition3 = (JudgeBackCondition)judgeBackCondition.next();
                        this.getFunctionIds(judgeBackCondition3.getJudgeSpellCondition(), functionIds);
                    }
                }
            }
            List flowFunctionConfigs = flowObject.getProps().getFlowFunctionConfig();
            ArrayList functionUserVariables = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)flowFunctionConfigs)) {
                for (FlowFunctionConfig flowFunctionConfig : flowFunctionConfigs) {
                    if (!functionIds.contains(flowFunctionConfig.getId()) || !ToolUtil.isNotEmpty((Object)flowFunctionConfig.getUseVariables())) continue;
                    functionUserVariables.addAll(flowFunctionConfig.getUseVariables());
                }
            }
            if (ToolUtil.isNotEmpty(functionUserVariables)) {
                flowVariables.addAll(functionUserVariables);
            }
            if (flowObject.getInstanceKey().equals(firstNode)) {
                flowVariables.addAll(annoUseVariables);
            }
            String instanceKey = ToolUtil.isEmpty((Object)flowObject.getProps().getNodeId()) ? flowObject.getInstanceKey() : flowObject.getProps().getNodeId();
            ArrayList<FlowVariables> delFlowVariables = new ArrayList<FlowVariables>();
            for (FlowVariables flowVariable : flowVariables) {
                if (!"bpm_next_node".equals(flowVariable.getVariable())) continue;
                delFlowVariables.add(flowVariable);
            }
            flowVariables.removeAll(delFlowVariables);
            CallActivityTable callActivityTable = flowObject.getProps().getCallActivityTable();
            if (flowVariables.isEmpty() && (callActivityTable == null || HussarUtils.isEmpty((Object)callActivityTable.getTableId()))) continue;
            String codeGeneratorModelName = FileUtil.systemPath((String[])new String[]{this.pathStrategy.javaPathService().getJavaPath(), "bpmvisitor", modelName, workFlowName}).toLowerCase();
            SqlServerFlowCodeGeneratorModel sqlServerFlowCodeGeneratorModel = this.getData(codeGeneratorModelName, identityKey, instanceKey, flowVariables, modelId, callActivityTable, isCallActivity);
            if (sqlServerFlowCodeGeneratorModel == null) {
                return null;
            }
            String fileName = keyName.substring(0, 1).toUpperCase() + keyName.substring(1) + sqlServerFlowCodeGeneratorModel.getInstanceKey().substring(0, 1).toUpperCase() + sqlServerFlowCodeGeneratorModel.getInstanceKey().substring(1) + "Visitor.java";
            String fileNameNew = keyName.substring(0, 1).toUpperCase() + keyName.substring(1) + "Visitor.java";
            this.setParam(sqlServerFlowCodeGeneratorModel, modelId);
            Map<Boolean, String> newResult = this.newJavaFile(sqlServerFlowCodeGeneratorModel, saveJavaFilePath + File.separator + fileName, workflowId);
            Map<Boolean, String> newResult2 = this.newJavaFileNew(sqlServerFlowCodeGeneratorModel, saveJavaFilePath + File.separator + fileNameNew, workflowId);
            entry = newResult.entrySet().iterator().next();
            if (!entry.getKey().booleanValue()) {
                return result;
            }
            file = new HashMap();
            file.put("newFilePath", saveJavaFilePath + File.separator + fileName);
            if (HussarUtils.isEmpty((Object)organId)) {
                file.put("dataId", identityKey.split(":")[0] + instanceKey);
            } else {
                file.put("dataId", identityKey.split(":")[0] + "-" + organId + "-" + instanceKey);
            }
            if (HussarUtils.isEmpty((Object)newOrganId)) {
                file.put("newDataId", identityKey.split(":")[0] + instanceKey);
            } else {
                file.put("newDataId", identityKey.split(":")[0] + "-" + newOrganId + "-" + instanceKey);
            }
            file.put("fileContent", entry.getValue());
            if (map != null) {
                oldPartentPath = map.get("parentPath");
                oldFileName = fileName.replace(keyName.substring(0, 1).toUpperCase() + keyName.substring(1), map.get("oldKey").substring(0, 1).toUpperCase() + map.get("oldKey").substring(1));
                old = new File(oldPartentPath + File.separator + oldFileName);
                if (FileUtils.exists((File)old)) {
                    file.put("oldFilePath", oldPartentPath + File.separator + oldFileName);
                }
            }
            result.add(file);
        }
        return result;
    }

    private FlowModel readWfd(String moduleName, String workflowName) {
        if (((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).getScenes().isSharedStorage()) {
            return this.readRemoteWfd(moduleName, workflowName);
        }
        return this.readLocalWfd(moduleName, workflowName);
    }

    private FlowModel readLocalWfd(String moduleName, String workflowName) {
        String path = this.pathStrategy.resourcePathService().projectStoreCode(new String[]{moduleName, workflowName}).getLocalPath();
        File bpmFile = new File(path);
        try {
            String xml = FileUtils.readFileToString((File)bpmFile, (Charset)StandardCharsets.UTF_8);
            return (FlowModel)JSON.parseObject((String)String.valueOf(xml), FlowModel.class);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u672c\u5730\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private FlowModel readRemoteWfd(String moduleName, String workflowName) {
        String path = this.pathStrategy.resourcePathService().projectStoreCode(new String[]{moduleName, workflowName}).getRemotePath();
        StorageResult result = ((StorageService)SpringContextUtil.getBean(StorageService.class)).downloadByPath(path);
        if (result.isSuccess()) {
            String json = new String((byte[])result.getData(), StandardCharsets.UTF_8);
            return (FlowModel)JSON.parseObject((String)json, FlowModel.class);
        }
        return null;
    }

    private void getFunctionIds(String assignee, Set<String> functionsIds) {
        if (ToolUtil.isNotEmpty((Object)assignee) && assignee.contains("@")) {
            Matcher matcher = regex.matcher(assignee);
            while (matcher.find()) {
                functionsIds.add(matcher.group().substring(2, matcher.group().length() - 2));
            }
        }
    }

    private SqlServerFlowCodeGeneratorModel getData(String modelName, String identityKey, String instanceKey, List<FlowVariables> flowVariablesList, String modelId, CallActivityTable callActivityTable, boolean isCallActivity) {
        ArrayList<SqlServerFlowTableServerModel> tableServerModels = new ArrayList<SqlServerFlowTableServerModel>();
        ArrayList<String> importClassNames = new ArrayList<String>();
        String tableNames = "";
        String functionType = "";
        SqlServerFlowCodeGeneratorModel codeGeneratorModel = new SqlServerFlowCodeGeneratorModel();
        HashMap<String, String> slaveSecurityLevel = new HashMap<String, String>();
        StringBuffer securityLevelField = new StringBuffer();
        if (".".equals((modelName = modelName.replace("\\", ".").replace("/", ".")).substring(0, 1))) {
            modelName = modelName.substring(1);
        }
        String[] ids = identityKey.split(":");
        modelName = modelName + "." + ids[0].replace("_", "").replace("-", "").toLowerCase() + ids[1];
        codeGeneratorModel.setModelName(modelName);
        codeGeneratorModel.setComponentId(ids[0] + ":" + ids[1]);
        codeGeneratorModel.setIdentityKey(ids[0] + ":" + ids[1]);
        codeGeneratorModel.setInstanceKey(instanceKey);
        if (flowVariablesList == null) {
            flowVariablesList = new ArrayList<FlowVariables>();
        }
        HashSet<String> names = new HashSet<String>();
        HashSet<String> callTableVariableName = new HashSet<String>();
        if (isCallActivity) {
            for (FlowVariables flowVariables : flowVariablesList) {
                if (flowVariables.getSlaveTableName() == null || "".equals(flowVariables.getSlaveTableName())) continue;
                callTableVariableName.add(flowVariables.getVariable());
            }
        }
        if (callActivityTable != null && ToolUtil.isNotEmpty((Object)callActivityTable.getTableId()) && !"".equals(modelId)) {
            try {
                codeGeneratorModel.setDataType("");
                JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
                functionType = String.valueOf(dataModelJson.get((Object)"functionType"));
                SqlServerModelFunction currentFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(functionType);
                SqlServerDataModelBase sqlserverMsDataModel = currentFunction.parseDataModel(dataModelJson);
                if (HussarUtils.equals((Object)"MASTER_SLAVE", (Object)functionType) || HussarUtils.equals((Object)"FLOW_MASTER_SLAVE", (Object)functionType) || HussarUtils.equals((Object)"TASK_MASTER_SLAVE", (Object)functionType)) {
                    SqlServerMsDataModelDTO dataModelDto = (SqlServerMsDataModelDTO)currentFunction.enclosure().enclosure(sqlserverMsDataModel);
                    boolean isFindTable = false;
                    for (SqlServerDataModelField field : sqlserverMsDataModel.getFields()) {
                        if (HussarUtils.equals((Object)"securityLevel", (Object)field.getUsage())) {
                            codeGeneratorModel.setSecurityLevelField(field.getName());
                        }
                        if (!HussarUtils.equals((Object)"array", (Object)field.getDataType()) || !callActivityTable.getTableId().equals(field.getName())) continue;
                        SqlServerDataModelBaseDTO sqlServerDataModelBaseDTO = dataModelDto.getDataModelDtoMap().get(field.getSourceDataModelId());
                        ArrayList<SqlServerDataModelFieldDto> list = new ArrayList<SqlServerDataModelFieldDto>();
                        for (SqlServerDataModelFieldDto sqlServerDataModelFieldDto : sqlServerDataModelBaseDTO.getFields()) {
                            if ("primary".equals(sqlServerDataModelFieldDto.getFill()) || callTableVariableName.contains(sqlServerDataModelFieldDto.getPropertyName())) {
                                list.add(sqlServerDataModelFieldDto);
                                continue;
                            }
                            if (!"securityLevel".equals(sqlServerDataModelFieldDto.getFill())) continue;
                            slaveSecurityLevel.put(field.getName(), sqlServerDataModelFieldDto.getPropertyName());
                        }
                        sqlServerDataModelBaseDTO.setFields(list);
                        codeGeneratorModel.setSlaveTable(sqlServerDataModelBaseDTO);
                        codeGeneratorModel.setSlaveTableAlias(field.getName());
                        isFindTable = true;
                        codeGeneratorModel.setTableType("one-to-many");
                        break;
                    }
                    if (!isFindTable) {
                        codeGeneratorModel.setTableType("one-to-one");
                        for (SqlServerDataModelBaseDTO sqlServerDataModelBaseDTO : dataModelDto.getDataModelDtoMap().values()) {
                            if (!callActivityTable.getTableId().equals(sqlServerDataModelBaseDTO.getName())) continue;
                            ArrayList<SqlServerDataModelFieldDto> list = new ArrayList<SqlServerDataModelFieldDto>();
                            for (SqlServerDataModelFieldDto sqlServerDataModelFieldDto : sqlServerDataModelBaseDTO.getFields()) {
                                if ("primary".equals(sqlServerDataModelFieldDto.getFill()) || callTableVariableName.contains(sqlServerDataModelFieldDto.getPropertyName())) {
                                    list.add(sqlServerDataModelFieldDto);
                                    continue;
                                }
                                if (!"securityLevel".equals(sqlServerDataModelFieldDto.getFill())) continue;
                                slaveSecurityLevel.put(sqlServerDataModelBaseDTO.getName(), sqlServerDataModelFieldDto.getPropertyName());
                            }
                            sqlServerDataModelBaseDTO.setFields(list);
                            codeGeneratorModel.setSlaveTable(sqlServerDataModelBaseDTO);
                            codeGeneratorModel.setSlaveTableAlias(callActivityTable.getTableId());
                        }
                    }
                }
                if (codeGeneratorModel.getDataType() == null) {
                    return null;
                }
                tableNames = callActivityTable.getPrimaryTable();
                if ("TASK".equals(functionType) || "TASK_MASTER_SLAVE".equals(functionType)) {
                    tableNames = tableNames + "Task";
                }
                tableNames = NamingStrategy.underlineToCamel((String)tableNames);
                tableNames = tableNames.substring(0, 1).toUpperCase() + tableNames.substring(1);
                String path = FileUtil.packagePath((String[])new String[]{this.pathStrategy.javaPathService().getJavaPath(), ((FileMappingService)SpringContextUtil.getBean(FileMappingService.class)).getFormatPath(callActivityTable.getModelPath()), callActivityTable.getPrimaryTable()}).toLowerCase();
                importClassNames.add(path + ".model." + tableNames);
                importClassNames.add(path + ".service." + tableNames + "Service");
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u6a21\u578b\u6570\u636e\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }
        boolean isExistArray = false;
        SqlServerDataModelBase sqlserverMsDataModel = null;
        for (FlowVariables flowVariables : flowVariablesList) {
            if (!names.add(flowVariables.getVariable())) {
                if (flowVariables.getTable() != null) {
                    for (SqlServerFlowTableServerModel tableServerModel : tableServerModels) {
                        if (!tableServerModel.getSelectName().equals(flowVariables.getVariable())) continue;
                        if ("".equals(tableServerModel.getTableName())) {
                            tableServerModel.setTableName(flowVariables.getTable());
                            tableServerModel.setGetName(("boolean".equalsIgnoreCase(flowVariables.getVarType()) ? "is" : "get") + PrimaryFieldUtil.getPrimaryField(flowVariables.getVariable()));
                            tableServerModel.setVarFrom(flowVariables.getVarFrom());
                            tableServerModel.setSelectName(flowVariables.getVariable());
                            tableServerModel.setVarType(flowVariables.getVarType());
                        }
                        break;
                    }
                }
            } else if (!isCallActivity || flowVariables.getSlaveTableName() == null || "".equals(flowVariables.getSlaveTableName())) {
                SqlServerFlowTableServerModel tableServerModel = new SqlServerFlowTableServerModel();
                tableServerModel.setSelectName(flowVariables.getVariable());
                if (flowVariables.getTable() != null) {
                    tableServerModel.setGetName(("boolean".equalsIgnoreCase(flowVariables.getVarType()) ? "is" : "get") + PrimaryFieldUtil.getPrimaryField(flowVariables.getVariable()));
                }
                tableServerModel.setTableName(flowVariables.getTable() == null ? "" : flowVariables.getTable());
                tableServerModel.setVarFrom(flowVariables.getVarFrom());
                tableServerModel.setVarType(flowVariables.getVarType());
                if ("ArrayPrimary".equals(flowVariables.getVarType()) && flowVariables.getTable() != null) {
                    isExistArray = true;
                }
                tableServerModels.add(tableServerModel);
            }
            if (!tableNames.isEmpty() || !ToolUtil.isNotEmpty((Object)flowVariables.getTable()) || "".equals(modelId)) continue;
            try {
                codeGeneratorModel.setDataType("");
                JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
                functionType = String.valueOf(dataModelJson.get((Object)"functionType"));
                SqlServerModelFunction currentFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(functionType);
                sqlserverMsDataModel = currentFunction.parseDataModel(dataModelJson);
                if (!this.hasFormQuery(sqlserverMsDataModel)) continue;
                if (codeGeneratorModel.getDataType() == null) {
                    return null;
                }
                tableNames = flowVariables.getTable();
                if ("TASK".equals(functionType) || "TASK_MASTER_SLAVE".equals(functionType)) {
                    tableNames = tableNames + "Task";
                }
                tableNames = NamingStrategy.underlineToCamel((String)tableNames);
                tableNames = tableNames.substring(0, 1).toUpperCase() + tableNames.substring(1);
                String path = FileUtil.packagePath((String[])new String[]{this.pathStrategy.javaPathService().getJavaPath(), ((FileMappingService)SpringContextUtil.getBean(FileMappingService.class)).getFormatPath(flowVariables.getModulePath()), flowVariables.getTable()}).toLowerCase();
                importClassNames.add(path + ".model." + tableNames);
                importClassNames.add(path + ".service." + tableNames + "Service");
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u6a21\u578b\u6570\u636e\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }
        if (HussarUtils.isEmpty((Object)codeGeneratorModel.getSecurityLevelField()) && sqlserverMsDataModel != null) {
            List collect = flowVariablesList.stream().map(FlowVariables::getVariable).collect(Collectors.toList());
            if (sqlserverMsDataModel instanceof SqlServerMsDataModel) {
                sqlserverMsDataModel.getFields().stream().filter(filed -> collect.contains(filed.getName()) && "securityLevel".equals(filed.getUsage())).findFirst().ifPresent(fieldUsage -> securityLevelField.append(fieldUsage.getName()));
                List<SqlServerDataModelBase> slaveTables = ((SqlServerMsDataModel)sqlserverMsDataModel).getSlaveTables();
                for (SqlServerDataModelBase slaveTable : slaveTables) {
                    for (SqlServerDataModelField dmDataModelField : slaveTable.getFields()) {
                        if (!collect.contains(dmDataModelField.getName()) || !HussarUtils.equals((Object)"securityLevel", (Object)dmDataModelField.getUsage())) continue;
                        securityLevelField.append(",").append(dmDataModelField.getName());
                    }
                }
                if (securityLevelField.length() > 0) {
                    codeGeneratorModel.setSecurityLevelField(securityLevelField.toString());
                }
            } else {
                sqlserverMsDataModel.getFields().stream().filter(filed -> collect.contains(filed.getName()) && "securityLevel".equals(filed.getUsage())).findFirst().ifPresent(fieldUsage -> codeGeneratorModel.setSecurityLevelField(fieldUsage.getName()));
            }
        }
        if (isExistArray) {
            importClassNames.add("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
            importClassNames.add("java.util.Arrays");
        }
        codeGeneratorModel.setTableNames(tableNames);
        codeGeneratorModel.setImportClassNames(importClassNames);
        if (HussarUtils.isNotEmpty(slaveSecurityLevel)) {
            codeGeneratorModel.setSlaveSecurityLevel(slaveSecurityLevel);
        }
        codeGeneratorModel.setTableServerModels(tableServerModels);
        if ("TASK".equals(functionType) || "TASK_MASTER_SLAVE".equals(functionType)) {
            codeGeneratorModel.setDataType(functionType);
        }
        return codeGeneratorModel;
    }

    private Map<Boolean, String> newJavaFile(SqlServerFlowCodeGeneratorModel sqlServerFlowCodeGeneratorModel, String javaPathName, String id) {
        HashMap<Boolean, String> result = new HashMap<Boolean, String>();
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_29);
        try {
            configuration.setClassForTemplateLoading(SqlServerWorkFlowVisitorServiceImpl.class, "/");
            configuration.setDefaultEncoding("UTF-8");
            Template template = configuration.getTemplate(FTL_NAME);
            javaPathName = javaPathName.replace("/", File.separator).replace("\\", File.separator);
            StringWriter stringWriter = new StringWriter();
            BufferedWriter writer = new BufferedWriter(stringWriter);
            template.process((Object)sqlServerFlowCodeGeneratorModel, (Writer)writer);
            String fileContent = stringWriter.toString();
            writer.flush();
            writer.close();
            result.put(true, fileContent);
            return result;
        }
        catch (TemplateException | IOException e) {
            logger.error("\u751f\u6210\u6587\u4ef6\u76ee\u5f55\u53ca\u6587\u4ef6\u540d", e);
            result.put(false, "");
            return result;
        }
    }

    private Map<Boolean, String> newJavaFileNew(SqlServerFlowCodeGeneratorModel sqlServerFlowCodeGeneratorModel, String javaPathName, String id) {
        HashMap<Boolean, String> result = new HashMap<Boolean, String>();
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_29);
        try {
            configuration.setClassForTemplateLoading(SqlServerWorkFlowVisitorServiceImpl.class, "/");
            configuration.setDefaultEncoding("UTF-8");
            Template templatenew = configuration.getTemplate(FTL_NAME_NEW);
            javaPathName = javaPathName.replace("/", File.separator).replace("\\", File.separator);
            StringWriter stringWriter = new StringWriter();
            BufferedWriter writer = new BufferedWriter(stringWriter);
            templatenew.process((Object)sqlServerFlowCodeGeneratorModel, (Writer)writer);
            String fileContent = stringWriter.toString();
            writer.flush();
            writer.close();
            filePublishService.writeStringToFile(fileContent, javaPathName + "BPM", id);
            result.put(true, fileContent);
            return result;
        }
        catch (TemplateException | IOException e) {
            logger.error("\u751f\u6210\u6587\u4ef6\u76ee\u5f55\u53ca\u6587\u4ef6\u540d", e);
            result.put(false, "");
            return result;
        }
    }

    private Map<String, String> getOldVisitorKey(String saveJavaPath, String keyName, String oldVersion) {
        keyName = keyName.replace("-", "");
        HashMap<String, String> map = new HashMap<String, String>(4);
        String oldKeyPrefix = keyName.split(":")[0].replace("_", "");
        if (HussarUtils.isNotEmpty((Object)oldVersion)) {
            File file = new File(saveJavaPath + File.separator + oldKeyPrefix + oldVersion);
            if (!file.exists()) {
                return null;
            }
            map.put("parentPath", file.getPath());
            map.put("oldKey", file.getName());
            return map;
        }
        File file = new File(saveJavaPath);
        File[] files = FileUtils.listFiles((File)file);
        if (ToolUtil.isEmpty((Object)files)) {
            return null;
        }
        int num = 0;
        String parentPath = null;
        String oldKey = null;
        for (File value : files) {
            int valueNum;
            if (!value.getName().startsWith(oldKeyPrefix) || value.getName().length() <= oldKeyPrefix.length() || (valueNum = Integer.parseInt(value.getName().substring(oldKeyPrefix.length()))) <= num) continue;
            parentPath = value.getPath();
            oldKey = value.getName();
            num = valueNum;
        }
        if (num > 0) {
            map.put("parentPath", parentPath);
            map.put("oldKey", oldKey);
            return map;
        }
        return null;
    }

    private boolean hasFormQuery(SqlServerDataModelBase dataModelBase) {
        for (SqlServerDataModelOperation operation : dataModelBase.getOperations()) {
            if (!"formQuery".equals(operation.getName())) continue;
            return true;
        }
        logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u8868\u5355\u67e5\u8be2\u65b9\u6cd5\u3002");
        return false;
    }

    private void setParam(SqlServerFlowCodeGeneratorModel sqlServerFlowCodeGeneratorModel, String modelId) {
        try {
            if (HussarUtils.isEmpty((Object)modelId) || sqlServerFlowCodeGeneratorModel.getDataType() == null) {
                return;
            }
            sqlServerFlowCodeGeneratorModel.setParams(SqlServerWorkFlowVisitorServiceImpl.pushParam(sqlServerFlowCodeGeneratorModel, modelId, "formQuery"));
        }
        catch (LcdpException | IOException | CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> pushParam(SqlServerFlowCodeGeneratorModel sqlServerFlowCodeGeneratorModel, String modelId, String operationName) throws LcdpException, IOException, CloneNotSupportedException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
        String functionType = String.valueOf(dataModelJson.get((Object)"functionType"));
        SqlServerModelFunction currentFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(functionType);
        SqlServerDataModelBase dataModelBase = currentFunction.parseDataModel(dataModelJson);
        SqlServerDataModelBaseDTO dataModelDto = currentFunction.enclosure().enclosure(dataModelBase);
        if ("TASK_MASTER_SLAVE".equals(sqlServerFlowCodeGeneratorModel.getDataType())) {
            dataModelDto = ((SqlServerTaskMsDataModelDTO)dataModelDto).getDataModelDtoMap().get(modelId);
        }
        if (HussarUtils.isEmpty(dataModelBase.getOperations())) {
            return new HashMap<String, Object>();
        }
        SqlServerDataModelOperation operation = dataModelBase.getOperations().stream().filter(o -> operationName.equals(o.getName())).findFirst().orElseGet(SqlServerDataModelOperation::new);
        Map<String, Object> operationParams = operation.getParams();
        if (HussarUtils.isEmpty(operationParams)) {
            return new HashMap<String, Object>();
        }
        SqlServerDataModelBaseDTO slaveTable = sqlServerFlowCodeGeneratorModel.getSlaveTable();
        Map slaveTablePlusSave = (Map)operationParams.get("slaveTablePlusSave");
        boolean isPlusQuery = false;
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!Boolean.TRUE.equals(slaveTablePlusSave.get(key))) continue;
                if (ToolUtil.isNotEmpty((Object)slaveTable) && ToolUtil.isNotEmpty((Object)slaveTable.getId()) && key.equals(slaveTable.getId())) {
                    isPlusQuery = true;
                    break;
                }
                if (!ToolUtil.isEmpty((Object)slaveTable)) continue;
                isPlusQuery = true;
                break;
            }
        }
        if (isPlusQuery) {
            params.put("returnValue", String.format("%s%s", dataModelDto.getEntityName(), "FormVO"));
            params.put("PageDTO", String.format("%s%s", dataModelDto.getEntityName(), "PageDTO"));
            params.put("primaryType", dataModelDto.getKeyField().getPropertyType());
            HashSet<String> imports = new HashSet<String>();
            imports.add(String.format("%s.%s", dataModelDto.getPackageInfo().get("dto"), params.get("PageDTO")));
            imports.add(String.format("%s.%s", dataModelDto.getPackageInfo().get("VO"), params.get("returnValue")));
            if (HussarUtils.isNotEmpty((Object)slaveTable)) {
                imports.add(String.format("%s.%sVO", dataModelDto.getPackageInfo().get("VO"), slaveTable.getEntityName()));
            }
            params.put("imports", imports);
        }
        return params;
    }
}

