@Override
@HussarTransactional
public ApiResponse<Boolean> ${name!}(Increment<${returnValue!}> tableData) {
    try {
        List<${returnValue!}> itemList = tableData.getDel();
        if(HussarUtils.isNotEmpty(itemList)){
        <#if  delFlag?? && delFlag!>
            for (${returnValue!} ${table.entityName?uncap_first}:itemList) {
                ${flagDeleteCode}
            }
            this.updateBatchById(itemList);
        <#else>
            List<String> ids = new ArrayList<>();
            for (${returnValue!} item:itemList) {
                ids.add(String.valueOf(item.get${primaryField!}()));
            }
            this.removeByIds(ids);
        </#if>
        }
        List<${returnValue!}> insertAndUpdateList = new ArrayList<>();
        List<${returnValue!}> insertList = tableData.getAdd();
        List<${returnValue!}> updateList = tableData.getEdit();
        if (HussarUtils.isNotEmpty(insertList)){
            insertAndUpdateList.addAll(insertList);
        }
        if (HussarUtils.isNotEmpty(updateList)){
            insertAndUpdateList.addAll(updateList);
        }
        <#if  logicallyDelete?? && logicallyDelete!>
            <#if fillCode??>
                for (${returnValue!} ${table.entityName?uncap_first} : insertAndUpdateList) {
                ${fillCode!}
                }
            </#if>
            /* @begin ${name!} #自定义代码 */
            /* @end ${name!} */
            return ApiResponse.success(this.saveOrUpdateBatch(insertAndUpdateList));
        <#else>
            <#if fillCode??>
                for (${returnValue!} ${table.entityName?uncap_first} : insertAndUpdateList) {${fillCode!}}
            </#if>
            /* @begin ${name!} #自定义代码 */
            /* @end ${name!} */
            return ApiResponse.success(this.saveOrUpdateBatch(insertAndUpdateList));
        </#if>
    } catch (Exception e) {
        <#if table?? && table.transDisposition?? && table.transDisposition>
        throw new HussarException(TfModelEnum.TF_EDITABLE_TABLE_FAILED_TO_SAVE.getMessage(),e);
        <#else>
        throw new HussarException("可编辑表格保存失败",e);
        </#if>
    }
}

@Override
@HussarTransactional
public ApiResponse<Boolean> ${oldName!}(JSONObject tableData) {
    try {
        List<${returnValue!}> itemList = JSONObject.parseArray(tableData.getString("del"), ${returnValue!}.class);
        if(HussarUtils.isNotEmpty(itemList)){
        <#if  delFlag?? && delFlag!>
            for (${returnValue!} ${table.entityName?uncap_first}:itemList) {
                ${flagDeleteCode}
            }
            this.updateBatchById(itemList);
        <#else>
            List<String> ids = new ArrayList<>();
            for (${returnValue!} ${table.entityName?uncap_first}:itemList) {
                ids.add(String.valueOf(${table.entityName?uncap_first}.get${primaryField!}()));
            }
            this.removeByIds(ids);
        </#if>
        }
        List<${returnValue!}> insertAndUpdateList = JSONObject.parseArray(tableData.getString("insertAndUpdate"), ${returnValue!}.class);
        <#if  logicallyDelete?? && logicallyDelete!>
            <#if fillCode??>
                for (${returnValue!} ${table.entityName?uncap_first} : insertAndUpdateList) {
                ${fillCode!}
                }
            </#if>
            /* @begin ${oldName!} #自定义代码 */
            /* @end ${oldName!} */
            return ApiResponse.success(this.saveOrUpdateBatch(insertAndUpdateList));
        <#else>
            <#if fillCode??>
                for (${returnValue!} ${table.entityName?uncap_first} : insertAndUpdateList) {${fillCode!}}
            </#if>
            /* @begin ${oldName!} #自定义代码 */
            /* @end ${oldName!} */
            return ApiResponse.success(this.saveOrUpdateBatch(insertAndUpdateList));
        </#if>
        } catch (Exception e) {
        <#if table?? && table.transDisposition?? && table.transDisposition>
        throw new HussarException(TfModelEnum.TF_EDITABLE_TABLE_FAILED_TO_SAVE.getMessage(),e);
        <#else>
        throw new HussarException("可编辑表格保存失败",e);
        </#if>
        }
    }
