/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.processor;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.sqlserver.code.SqlServerCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerModelFunction;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.result.SqlServerCodeResult;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SqlServerModelProcessor
implements DataModelProcessor<SqlServerCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(SqlServerModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"SQL_SERVER", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<SqlServerCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> backCtx = this.getSqlServerBackCtx(publishCtx);
        SqlServerModelProcessor.init(backCtx, dataModelBase);
        SqlServerModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    private SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> getSqlServerBackCtx(PublishCtx<SqlServerCodeResult> publishCtx) {
        SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> backCtx = new SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        if (publishCtx.getPublishDTO() != null) {
            backCtx.setPublishDTO(publishCtx.getPublishDTO());
        }
        return backCtx;
    }

    public static void init(SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        SqlServerModelFunction currentFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        SqlServerDataModelBase currentModelBase = SqlServerDataModelUtil.transfer(dataModelBase);
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, SqlServerDataModelBaseDTO> useDtoMap = new HashMap<String, SqlServerDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> backCtx, PublishCtx<SqlServerCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        SqlServerModelProcessor.visit(backCtx);
        SqlServerModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        SqlServerDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        SqlServerDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PageInfoNode pageInfoNode = null;
        if (backCtx.getUseDataModelBase().getIsPublishResource()) {
            pageInfoNode = DataModelUtil.getDataModelNode((String)useDataModelBase.getId());
        }
        for (SqlServerDataModelOperation operation : useDataModelBase.getOperations()) {
            SqlServerOperationVisitor<SqlServerDataModelBase, SqlServerDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("SQL_SERVER", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            try {
                backCtx.getModelFunction().accept(visitor, backCtx, operation);
            }
            catch (Exception var) {
                logger.error("\u6a21\u578b\uff1a{}\uff0c\u65b9\u6cd5\uff1a{} \u6e32\u67d3\u5931\u8d25\uff0c\u6e32\u67d3\u8def\u5f84\uff1a{}", new Object[]{useDataModelBase.getComment(), operation.getName(), visitor.getClass().getName()});
                throw new LcdpException(var, String.format("\u6a21\u578b%s\u6e32\u67d3\u5931\u8d25\uff0c\u5f02\u5e38\uff1a%s", useDataModelBase.getComment(), var.getMessage()));
            }
            if (!backCtx.getUseDataModelBase().getIsPublishResource() || !ToolUtil.isNotEmpty((Object)pageInfoNode)) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
        useDataModelBase.customOption(backCtx);
    }

    public static void render(SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> backCtx, PublishCtx<SqlServerCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        SqlServerRender<SqlServerDataModelBase, SqlServerDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<SqlServerCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(SqlServerCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
        if (HussarUtils.isNotEmpty((Object)backCtx.getParams())) {
            backCtx.getParams().keySet().forEach(key -> {
                if (ToolUtil.isEmpty((Object)publishCtx.getParams())) {
                    publishCtx.addParams(new HashMap());
                }
                publishCtx.getParams().putIfAbsent(key, backCtx.getParam((String)key));
            });
        }
    }
}

