/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.view;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.view.SqlServerViewDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.view.SqlServerViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERVIEWTemplatePrint")
public class SqlServerViewTemplatePrintVisitor
implements SqlServerOperationVisitor<SqlServerViewDataModel, SqlServerViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerViewTemplatePrintVisitor.class);
    private static final String templatePrintDTO = "com.jxdinfo.hussar.common.formDesign.TemplatePrintDTO";
    private static final String templatePrintService = "com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService";
    public static final String OPERATION_NAME = "SQL_SERVERVIEWTemplatePrint";

    @Override
    public void visit(SqlServerBackCtx<SqlServerViewDataModel, SqlServerViewDataModelDTO> backCtx, SqlServerDataModelOperation operation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        SqlServerViewDataModelDTO dataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(operation, dataModelViewDTO);
        String controllerPath = "template/sqlserver/backcode/templatePrint/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelViewDTO.getServiceName());
        String servicePath = "template/sqlserver/backcode/templatePrint/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/sqlserver/backcode/templatePrint/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, "ISysTemplatePrintInfoService");
        backCtx.addServiceImplInversion(modelId, "ISysTemplatePrintInfoHookStrategyService");
        this.renderImport(backCtx, modelId, dataModelViewDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", dataModelViewDTO.getApiPrefix() + "/" + operation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, SqlServerBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(SqlServerBackCtx<SqlServerViewDataModel, SqlServerViewDataModelDTO> backCtx, String modelId, SqlServerViewDataModelDTO dataModelViewDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelViewDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelViewDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, templatePrintDTO);
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, templatePrintDTO);
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, templatePrintDTO);
        backCtx.addServiceImplImport(modelId, templatePrintService);
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoHookStrategyService");
        if (ToolUtil.isNotEmpty(dataModelViewDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
    }

    private Map<String, Object> initParams(SqlServerDataModelOperation operation, SqlServerViewDataModelDTO dataModelViewDTO) {
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", dataModelViewDTO);
        controllerParams.put("returnValue", dataModelViewDTO.getEntityName());
        controllerParams.put("url", dataModelViewDTO.getApiPrefix() + "/" + operation.getName());
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(dataModelViewDTO.getComment() + "\u6a21\u677f\u6253\u5370");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        return controllerParams;
    }
}

