/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.flow.masterslaveflow;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerQueryDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.constant.SqlServerConstUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.masterslave.util.SqlServerMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SerialNumberUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERFLOW_MASTER_SLAVEFormSave")
public class SqlServerMsFlolwFormSaveVisitor
implements SqlServerOperationVisitor<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerMsFlolwFormSaveVisitor.class);
    public static final String OPERATION_NAME = "SQL_SERVERFLOW_MASTER_SLAVEFormSave";

    @Override
    public void visit(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, SqlServerDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        SqlServerMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        SqlServerMsDataModelDTO sqlServerMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = sqlServerMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, Object> controllerParams = operation.getParams();
        SqlServerDataModelFieldDto keyField = sqlServerMsDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map slaveTablePlusSave = (Map)operation.getParams().get("slaveTablePlusSave");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        for (SqlServerDataModelBase sqlServerDataModelBase : dataModelBase.getSlaveTables()) {
            SqlServerDataModelBaseDTO sqlServerDataModelBaseDTO = sqlServerMsDataModelDTO.getDataModelDtoMap().get(sqlServerDataModelBase.getId());
            String slaveModelName = sqlServerDataModelBase.getName();
            for (SqlServerDataModelFieldDto sqlServerDataModelFieldDto : sqlServerDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(sqlServerDataModelFieldDto.getFill())) continue;
                relationTagKeys.put(slaveModelName, sqlServerDataModelFieldDto.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        boolean plusFlag = false;
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        if (plusFlag) {
            for (SqlServerRelationshipDTO relationshipDTO : sqlServerMsDataModelDTO.getRelationshipDtoList()) {
                if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
                slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
            }
            for (SqlServerDataModelBase modelBase : dataModelBase.getSlaveTables()) {
                isLogicallyDelete.put(modelBase.getId(), ((SqlServerBaseDataModel)modelBase).getLogicallyDelete());
                SqlServerDataModelBaseDTO sqlServerDataModelBaseDTO = sqlServerMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
                String slaveModelName = modelBase.getName();
                capitalNameList.put(slaveModelName, SqlServerMasterSlaveUtil.getCapitalName(slaveModelName));
                for (SqlServerDataModelField sqlServerDataModelField : modelBase.getFields()) {
                    if (!"delDefFlag".equals(sqlServerDataModelField.getUsage())) continue;
                    logicallyDelField.put(slaveModelName, sqlServerDataModelField.getName());
                }
                for (SqlServerDataModelFieldDto sqlServerDataModelFieldDto : sqlServerDataModelBaseDTO.getFields()) {
                    if ("primary".equals(sqlServerDataModelFieldDto.getFill())) {
                        primaryKeys.put(slaveModelName, sqlServerDataModelFieldDto.getCapitalName());
                    }
                    if (!"foreign".equals(sqlServerDataModelFieldDto.getFill())) continue;
                    foreignKeys.put(slaveModelName, sqlServerDataModelFieldDto.getCapitalName());
                }
            }
            this.addFormPlusSaveDto(dataModelBase, sqlServerMsDataModelDTO, backCtx, slaveTablePlusSave);
        }
        controllerParams.put("table", sqlServerMsDataModelDTO);
        controllerParams.put("returnValue", sqlServerMsDataModelDTO.getEntityName());
        if (plusFlag) {
            controllerParams.put("returnValue", sqlServerMsDataModelDTO.getEntityName() + "IncrementDTO");
        }
        controllerParams.put("url", url);
        SqlServerDataModelBaseDTO sqlServerDataModelBaseDTO = sqlServerMsDataModelDTO.getDataModelDtoMap().get(dataModelBase.getMasterTable().getId());
        controllerParams.put("masterTable", sqlServerDataModelBaseDTO);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(sqlServerMsDataModelDTO.getComment() + "\u65b0\u589e\u6216\u4fee\u6539");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/sqlserver/flowbackcode/masterslaveflowbackcode/formsave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, sqlServerMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, sqlServerMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, sqlServerMsDataModelDTO.getServiceName());
        String servicePath = "template/sqlserver/flowbackcode/masterslaveflowbackcode/formsave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        this.masterSlaveCode(backCtx, controllerParams);
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        if (plusFlag) {
            controllerParams.put("primaryKeys", primaryKeys);
            controllerParams.put("foreignKeys", foreignKeys);
            controllerParams.put("slaveTable", SqlServerMasterSlaveUtil.ofSlaveParam(dataModelBase, sqlServerMsDataModelDTO));
            controllerParams.put("isPlusSave", true);
            controllerParams.put("isLogicallyDelete", isLogicallyDelete);
            controllerParams.put("logicallyDelField", logicallyDelField);
            controllerParams.put("capitalNameList", capitalNameList);
        }
        String serviceImplPath = "template/sqlserver/flowbackcode/masterslaveflowbackcode/formsave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.dto.Increment");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", url, "\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, SqlServerBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void masterSlaveCode(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        SqlServerMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        SqlServerMsDataModelDTO sqlServerMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<SqlServerRelationshipDTO> relationshipDtoList = sqlServerMsDataModelDTO.getRelationshipDtoList();
        SqlServerDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, SqlServerDataModelBaseDTO> dataModelDtoMap = sqlServerMsDataModelDTO.getDataModelDtoMap();
        SqlServerDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(backCtx, mainDataModelDto, sqlServerMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (SqlServerRelationshipDTO sqlServerRelationshipDTO : relationshipDtoList) {
                List<SqlServerRelationshipFieldDTO> sqlServerRelationshipFieldDTOS;
                String slaveTableId = sqlServerRelationshipDTO.getSlaveTableId();
                String relateModelType = sqlServerRelationshipDTO.getRelateModelType();
                SqlServerDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, sqlServerMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    sqlServerRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(sqlServerRelationshipFieldDTOS = sqlServerRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private void addFormPlusSaveDto(SqlServerMsDataModel dataModelBase, SqlServerMsDataModelDTO dataModelDTO, SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        SqlServerQueryDTO queryDTO = new SqlServerQueryDTO();
        String modelId = dataModelBase.getId();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/sqlserver/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", SqlServerMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", dataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(dataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(dataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = dataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        dataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }

    private String renderFillCode(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, SqlServerDataModelBaseDTO dataModelBaseDTO, SqlServerMsDataModelDTO msDataModelDTO, boolean isMs, SqlServerDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (SqlServerDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("modelId", msDataModelDTO.getId());
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", SqlServerConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", SqlServerConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", SqlServerConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/sqlserver/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }
}

