/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.enclosure;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerEnclosure;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.ResultMapUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.source.SourceUseItem;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.translate.SqlServerTranslate;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerModelBeanUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerPublicEnclosure;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerTemplateUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERFLOW_MASTER_SLAVEENCLOSURE")
public class SqlServerFlowMsEnclosure
implements SqlServerEnclosure<SqlServerFlowMsDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerFlowMsEnclosure.class);
    public static final String ENCLOSURE = "SQL_SERVERFLOW_MASTER_SLAVEENCLOSURE";

    @Override
    public SqlServerDataModelBaseDTO enclosure(SqlServerFlowMsDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        SqlServerFlowMsDataModelDTO dataModelBaseDTO = new SqlServerFlowMsDataModelDTO();
        SqlServerPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        List<SqlServerDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        HashMap<String, SqlServerDataModelBaseDTO> dataModelDtoMap = new HashMap<String, SqlServerDataModelBaseDTO>(slaveTables.size() + 1);
        HashMap<String, SqlServerDataModelBase> dataModelBaseMap = new HashMap<String, SqlServerDataModelBase>(slaveTables.size() + 1);
        SqlServerDataModelBase masterTable = dataModelBase.getMasterTable();
        masterTable.setModelPath(dataModelBase.getModelPath());
        SqlServerDataModelBaseDTO masterDTO = SqlServerModelBeanUtil.getFunctionModelVisitorBean(masterTable.getFunctionType()).enclosure().enclosure(masterTable);
        Map masterPackageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
        masterDTO.setPackageInfo(masterPackageInfo);
        masterDTO.setImportInfo(SqlServerPublicEnclosure.getImportInfo(masterPackageInfo, masterDTO));
        masterDTO.setTablePath(dataModelBaseDTO.getTablePath());
        dataModelDtoMap.put(masterTable.getId(), masterDTO);
        dataModelBaseMap.put(masterTable.getId(), masterTable);
        List<SqlServerTranslate> translates = dataModelBase.getTranslate();
        List<Object> msTranslates = new ArrayList();
        msTranslates = translates;
        ArrayList<String> slaveId = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dataModelBase.getRelationships())) {
            for (SqlServerRelationshipBase relationship : dataModelBase.getRelationships()) {
                if (!"collection".equals(relationship.getRelateModelType())) continue;
                slaveId.add(relationship.getSlaveTableId());
            }
        }
        for (SqlServerDataModelBase slaveTable : slaveTables) {
            slaveTable.setModelPath(dataModelBase.getModelPath());
            SqlServerDataModelBaseDTO slaveDTO = SqlServerModelBeanUtil.getFunctionModelVisitorBean(slaveTable.getFunctionType()).enclosure().enclosure(slaveTable);
            if (slaveId.contains(slaveTable.getId())) {
                List<SqlServerDataModelField> sFields = slaveTable.getFields();
                ArrayList<SqlServerTranslate> slaveTranslates = new ArrayList<SqlServerTranslate>();
                if (ToolUtil.isNotEmpty(translates)) {
                    block2: for (SqlServerDataModelField field : sFields) {
                        for (SqlServerTranslate translate : translates) {
                            if (!translate.getSourceFieldId().equals(field.getId())) continue;
                            slaveTranslates.add(translate);
                            continue block2;
                        }
                    }
                    SqlServerTranslateUtil.translateMsEnclosure(slaveTranslates, dataModelBase, slaveDTO);
                    if (ToolUtil.isNotEmpty(slaveDTO.getTranslateShowFields())) {
                        slaveDTO.setHasTranslate(true);
                        dataModelBaseDTO.setHasTranslate(true);
                    }
                    msTranslates.removeAll(slaveTranslates);
                }
            }
            Map slavePackageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
            slaveDTO.setPackageInfo(slavePackageInfo);
            slaveDTO.setImportInfo(SqlServerPublicEnclosure.getImportInfo(slavePackageInfo, slaveDTO));
            slaveDTO.setTablePath(dataModelBaseDTO.getTablePath());
            dataModelDtoMap.put(slaveTable.getId(), slaveDTO);
            dataModelBaseMap.put(slaveTable.getId(), slaveTable);
        }
        dataModelBaseDTO.setDataModelBaseMap(dataModelBaseMap);
        dataModelBaseDTO.setDataModelDtoMap(dataModelDtoMap);
        dataModelBaseDTO.setResultMapContent(ResultMapUtil.renderResultMap(dataModelBase, dataModelDtoMap, dataModelBaseMap));
        dataModelBaseDTO.setSubSelect(ResultMapUtil.renderSubSelect(dataModelBase, dataModelDtoMap, dataModelBaseMap));
        List<SourcePackageInfo> sourcePackageInfos = this.sourceCodePackage(dataModelBaseDTO, dataModelBase, dataModelDtoMap);
        dataModelBaseDTO.setSourcePackageInfos(sourcePackageInfos);
        this.sourceCodeRelationship(dataModelBaseDTO, dataModelBase);
        List<SqlServerDataModelField> dataModelFieldBases = dataModelBase.getFlowFields();
        if (ToolUtil.isEmpty(dataModelFieldBases)) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new SqlServerFlowMsDataModelDTO();
        }
        ArrayList<SqlServerDataModelFieldDto> tableFields = new ArrayList<SqlServerDataModelFieldDto>();
        for (SqlServerDataModelField dataModelFieldBase : dataModelFieldBases) {
            SqlServerDataModelFieldDto tableField = new SqlServerDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        SqlServerTranslateUtil.translateMsEnclosure(msTranslates, dataModelBase, dataModelBaseDTO);
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            dataModelBaseDTO.setHasTranslate(true);
        }
        PublishTemplateDto publishTemplateDto = SqlServerTemplateUtil.processTemplate(dataModelBase.getId(), slaveTables);
        dataModelBaseDTO.setPublishTemplateDto(publishTemplateDto);
        return dataModelBaseDTO;
    }

    private void sourceCodeRelationship(SqlServerFlowMsDataModelDTO dataModelDto, SqlServerFlowMsDataModel dataModelBase) throws LcdpException {
        ArrayList<SqlServerRelationshipDTO> relationshipDtoList = new ArrayList<SqlServerRelationshipDTO>();
        List<SqlServerDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        block0: for (SqlServerRelationshipBase relationship : dataModelBase.getRelationships()) {
            SqlServerRelationshipDTO relationshipDto = new SqlServerRelationshipDTO();
            BeanUtils.copyProperties((Object)relationship, (Object)relationshipDto);
            SqlServerDataModelBaseDTO masterModelDto = dataModelDto.getTableInfo(relationship.getMasterTableId());
            SqlServerDataModelBase masterModel = dataModelBase.getMasterTable();
            SqlServerDataModelBaseDTO slaveTableDto = dataModelDto.getTableInfo(relationship.getSlaveTableId());
            relationshipDto.setSlaveTableDto(slaveTableDto);
            SqlServerDataModelBase slaveTable = slaveTables.stream().filter(e -> e.getId().equals(relationship.getSlaveTableId())).findFirst().orElse(null);
            if (slaveTable == null) continue;
            relationshipDto.setSlaveTableName(slaveTableDto.getEntityName());
            relationshipDto.setSlaveTableServiceName(slaveTableDto.getServiceEnName());
            ArrayList<SqlServerRelationshipFieldDTO> relationshipFieldDtoList = new ArrayList<SqlServerRelationshipFieldDTO>();
            for (SqlServerRelationshipFieldBase relationshipField : relationship.getRelationships()) {
                SqlServerDataModelField slaveTableField;
                SqlServerRelationshipFieldDTO relationshipFieldDto = new SqlServerRelationshipFieldDTO();
                BeanUtils.copyProperties((Object)relationshipField, (Object)relationshipFieldDto);
                String masterTableFieldId = relationshipField.getMasterTableFieldId();
                String slaveTableFieldId = relationshipField.getSlaveTableFieldId();
                SqlServerDataModelField masterTableField = null;
                if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{masterTableFieldId})) {
                    masterTableField = masterModel.getFields().stream().filter(e -> e.getId().equals(masterTableFieldId)).findFirst().orElse(null);
                }
                if ((slaveTableField = (SqlServerDataModelField)slaveTable.getFields().stream().filter(e -> e.getId().equals(slaveTableFieldId)).findFirst().orElse(null)) == null) continue block0;
                if (masterTableField != null) {
                    relationshipFieldDto.setMasterFieldCap(masterModelDto.getFieldCapitalName(masterTableField.getName()));
                }
                relationshipFieldDto.setSlaveFieldCap(slaveTableDto.getFieldCapitalName(slaveTableField.getName()));
                relationshipFieldDtoList.add(relationshipFieldDto);
            }
            relationshipDto.setRelationshipDtoList(relationshipFieldDtoList);
            if ("collection".equals(relationshipDto.getRelateModelType())) {
                SqlServerDataModelField field = dataModelBase.getFields().stream().filter(fieldBase -> fieldBase.getSourceDataModelId().equals(relationship.getSlaveTableId())).findFirst().orElseThrow(() -> new LcdpException(LcdpExceptionEnum.ERROR, "\u672a\u627e\u5230\u5b50\u8868\u5bf9\u5e94\u4e3b\u5b50\u8868\u4e2d\u7684\u5217"));
                relationshipDto.setSlaveTableAlias(field.getName());
            }
            relationshipDtoList.add(relationshipDto);
        }
        dataModelDto.setRelationshipDtoList(relationshipDtoList);
    }

    private List<SourcePackageInfo> sourceCodePackage(SqlServerFlowMsDataModelDTO dataModelDto, SqlServerFlowMsDataModel dataModelBase, Map<String, SqlServerDataModelBaseDTO> tableInfoMap) {
        List<SqlServerDataModelField> dataModelFieldBases = dataModelBase.getFields();
        HashMap<String, SourcePackageInfo> sourcePackageInfoMap = new HashMap<String, SourcePackageInfo>();
        VoGeneratorInfo voGeneratorInfo = dataModelDto.getVoGeneratorInfo();
        voGeneratorInfo.addImport(Serializable.class.getCanonicalName());
        for (SqlServerDataModelField dataModelFieldBase : dataModelFieldBases) {
            PropertyType propertyType;
            SqlServerDataModelBaseDTO sourceDataModelDto;
            String sourceModelId = dataModelFieldBase.getSourceDataModelId();
            if (!ToolUtil.isNotEmpty((Object)sourceModelId) || !ToolUtil.isNotEmpty((Object)(sourceDataModelDto = tableInfoMap.get(sourceModelId)))) continue;
            if (DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType())) {
                if (ToolUtil.isEmpty(sourcePackageInfoMap.get(sourceModelId))) {
                    SourcePackageInfo sourcePackageInfo = new SourcePackageInfo();
                    sourcePackageInfo.setDataType("object");
                    sourcePackageInfo.setObjectName(sourceDataModelDto.getEntityName());
                    sourcePackageInfo.setObjectEnName(sourceDataModelDto.getEName());
                    String entityImport = sourceDataModelDto.getImportInfo().get("Entity");
                    sourcePackageInfoMap.put(sourceModelId, sourcePackageInfo);
                    dataModelDto.addEntityImport(entityImport);
                }
                SourceUseItem sourceUseItem = new SourceUseItem();
                sourceUseItem.setCurrAttr(dataModelFieldBase.getName());
                SqlServerDataModelFieldDto sourceField = sourceDataModelDto.getCertainField(dataModelFieldBase.getSourceFieldName());
                sourceUseItem.setSourceAttrCapitalName(sourceField.getCapitalName());
                ((SourcePackageInfo)sourcePackageInfoMap.get(sourceModelId)).addSourceItem(sourceUseItem);
                continue;
            }
            List<SqlServerDataModelFieldDto> dataModelFieldDtoList = dataModelDto.getFields();
            List<SqlServerDataModelFieldDto> voFields = voGeneratorInfo.getFields();
            for (SqlServerDataModelFieldDto dataModelFieldDto : dataModelFieldDtoList) {
                if (!dataModelFieldDto.getPropertyName().equals(dataModelFieldBase.getName()) || !ToolUtil.isNotEmpty((Object)(propertyType = SqlServerDataModelUtil.getEntityPropertyType(dataModelFieldBase.getDataType(), sourceDataModelDto)))) continue;
                dataModelFieldDto.setColumnType(propertyType);
                dataModelDto.addEntityImport(sourceDataModelDto.getImportInfo().get("Entity"));
                dataModelDto.addVoImport(sourceDataModelDto.getImportInfo().get("VO"));
            }
            for (SqlServerDataModelFieldDto voField : voFields) {
                if (!voField.getPropertyName().equals(dataModelFieldBase.getName()) || !ToolUtil.isNotEmpty((Object)(propertyType = SqlServerFlowMsEnclosure.getVoPropertyType(dataModelFieldBase.getDataType(), sourceDataModelDto)))) continue;
                voField.setColumnType(propertyType);
                voGeneratorInfo.addImport(sourceDataModelDto.getImportInfo().get("VO"));
            }
            if (!"array".equals(dataModelFieldBase.getDataType())) continue;
            SourcePackageInfo sourcePackageInfo = new SourcePackageInfo();
            sourcePackageInfo.setDataType("array");
            sourcePackageInfo.setObjectName(sourceDataModelDto.getEntityName());
            sourcePackageInfo.setObjectEnName(sourceDataModelDto.getEName());
            sourcePackageInfo.setQuoteAttr(dataModelFieldBase.getName());
            String entityImport = sourceDataModelDto.getImportInfo().get("Entity");
            sourcePackageInfoMap.put(sourceModelId, sourcePackageInfo);
            dataModelDto.addEntityImport(entityImport);
            dataModelDto.addEntityImport("java.util.List");
            voGeneratorInfo.addImport(sourceDataModelDto.getImportInfo().get("VO"));
            voGeneratorInfo.addImport("java.util.List");
        }
        return new ArrayList<SourcePackageInfo>(sourcePackageInfoMap.values());
    }

    private static PropertyType getVoPropertyType(String type, SqlServerDataModelBaseDTO dataModelDto) {
        PropertyType propertyType = null;
        if (ToolUtil.isNotEmpty((Object)type)) {
            propertyType = new PropertyType();
            propertyType.setImportT(dataModelDto.getImportInfo().get("VO"));
            String modelName = dataModelDto.getVoName();
            if (type.equals("array")) {
                propertyType.setType("List<${model}>".replace("${model}", modelName));
            } else if (type.equals("object")) {
                propertyType.setType(modelName);
            }
        }
        return propertyType;
    }
}

