/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.element.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerEnclosure;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SqlServerTaskMsDataModel
extends SqlServerMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(SqlServerTaskMsDataModel.class);
    public static final String FUNCTION_TYPE = "TASK_MASTER_SLAVE";
    public static final String TASK_KEY = "task";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private SqlServerBaseDataModel task;
    private List<SqlServerDataModelField> flowFields;

    public List<SqlServerDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<SqlServerDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"SQL_SERVER.TASK_MASTER_SLAVE", SqlServerTaskMsDataModel.class);
    }

    public SqlServerBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(SqlServerBaseDataModel task) {
        this.task = task;
    }

    @Override
    public SqlServerTaskMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        SqlServerTaskMsDataModel sqlserverTaskMsDataModel;
        try {
            ArrayList<SqlServerDataModelField> fieldList = new ArrayList<SqlServerDataModelField>();
            sqlserverTaskMsDataModel = (SqlServerTaskMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), SqlServerTaskMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                SqlServerDataModelBase master = SqlServerDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(sqlserverTaskMsDataModel.getName() + "Master");
                sqlserverTaskMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<SqlServerDataModelBase> slaveTables = new ArrayList<SqlServerDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    SqlServerDataModelBase slaveTable = SqlServerDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (SqlServerRelationshipBase relationship : sqlserverTaskMsDataModel.getRelationships()) {
                    if (relationship.getMasterTableId().equals(sqlserverTaskMsDataModel.task.getId())) continue;
                    SqlServerDataModelBase dataModelBase = slaveTables.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)relationship.getSlaveTableId())).findFirst().orElseGet(SqlServerBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    SqlServerDataModelField sqlserverDataModelField = new SqlServerDataModelField();
                    sqlserverDataModelField.setId(UUID.randomUUID().toString());
                    sqlserverDataModelField.setName(dataModelBase.getName());
                    sqlserverDataModelField.setComment(dataModelBase.getComment());
                    sqlserverDataModelField.setSourceDataModelId(dataModelBase.getId());
                    sqlserverDataModelField.setDataType("array");
                    fieldList.add(sqlserverDataModelField);
                }
                sqlserverTaskMsDataModel.setSlaveTables(slaveTables);
            }
            sqlserverTaskMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return sqlserverTaskMsDataModel;
    }

    @Override
    public SqlServerEnclosure<SqlServerDataModelBase> enclosure() throws LcdpException {
        return SqlServerModelBeanUtil.getEnclosureBean("SQL_SERVER", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public SqlServerRender<SqlServerDataModelBase, SqlServerDataModelBaseDTO> render() throws LcdpException {
        return SqlServerModelBeanUtil.getRenderBean("SQL_SERVER", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<SqlServerDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<SqlServerDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<SqlServerDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<SqlServerDataModelField>> contrastVOS = this.task.modelContrastTable((FieldsContrastParam<SqlServerDataModelField>)fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable((FieldsContrastParam<SqlServerDataModelField>)fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<SqlServerDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId).getDetails().get(0));
        details.addAll(super.checkTableContrast(modelId).getDetails());
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<SqlServerDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<SqlServerDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.getMasterTable().getId(), "T2");
        List<SqlServerRelationshipBase> relationships = super.getRelationships();
        if (ToolUtil.isNotEmpty(relationships) && !relationships.isEmpty()) {
            for (int i = 0; i < relationships.size(); ++i) {
                SqlServerRelationshipBase relationship = relationships.get(i);
                if (relationship.getSlaveTableId().equals(super.getId())) continue;
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> backCtx) throws LcdpException {
        SqlServerModelBeanUtil.getCustomOperationBean("SQL_SERVER", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

