/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.customOption.task;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.SqlServerCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerCustomOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERTASK_MASTER_SLAVECUSTOM_OPTION")
public class SqlServerTaskMsCustomOption
implements SqlServerCustomOperation<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> {
    public static final String CUSTOM_OPTION = "SQL_SERVERTASK_MASTER_SLAVECUSTOM_OPTION";

    @Override
    public void publishCustomOption(SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx) throws LcdpException {
        this.publishTaskDataBackFill(backCtx);
    }

    private void publishTaskDataBackFill(SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx) throws LcdpException {
        if (ToolUtil.isEmpty((Object)backCtx.getParams()) || ToolUtil.isEmpty(backCtx.getParams().get("identity"))) {
            return;
        }
        SqlServerTaskMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        SqlServerTaskMsDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        if (ToolUtil.isEmpty(useDataModelDTO.getCustomCodeGenerateInfo())) {
            useDataModelDTO.setCustomCodeGenerateInfo(new HashMap<String, SqlServerCodeGenerateInfo>());
        }
        useDataModelDTO.getCustomCodeGenerateInfo().put(useDataModelBase.getId(), this.genTaskDataBackFillCode(backCtx));
    }

    private SqlServerCodeGenerateInfo genTaskDataBackFillCode(SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx) throws LcdpException {
        SqlServerTaskMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        SqlServerTaskMsDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        SqlServerBaseDataModel task = useDataModelBase.getTask();
        String taskId = task.getId();
        SqlServerDataModelBaseDTO userTaskModelDTO = useDataModelDTO.getDataModelDtoMap().get(taskId);
        SqlServerDataModelBaseDTO userBusinessModelDTO = useDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        String modulePath = useDataModelDTO.getTablePath().toLowerCase();
        String fileName = userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl";
        String writePath = modulePath + File.separator + "Task".toLowerCase() + File.separator + fileName + ".java";
        String dataBackFillPath = "template/sqlserver/taskbackcode/mscode/task_data_backfill_service_impl.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("package", userTaskModelDTO.getPackageInfo().get("Task"));
        params.put("className", fileName);
        params.put("identity", backCtx.getParams().get("identity"));
        TreeSet<String> imports = new TreeSet<String>();
        params.put("implementServiceNameImportInfo", "com.jxdinfo.hussar.workflow.task.model.service.TaskModelService");
        params.put("implementServiceName", "TaskModelService");
        params.put("ProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto");
        params.put("DeletedProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto");
        params.put("ProcessNodeInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto");
        params.put("CompleteTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto");
        params.put("UpdateTaskUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto");
        params.put("WorkflowUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto");
        params.put("TaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto");
        params.put("DeletedTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto");
        params.put("taskEntity", userTaskModelDTO.getEntityName());
        params.put("taskEntityImportInfo", userTaskModelDTO.getImportInfo().get("Entity"));
        params.put("taskServiceName", userTaskModelDTO.getServiceName());
        params.put("taskServiceImportInfo", userTaskModelDTO.getImportInfo().get("Service"));
        params.put("businessServiceName", userBusinessModelDTO.getServiceName());
        params.put("businessServiceImportInfo", userBusinessModelDTO.getImportInfo().get("Service"));
        params.put("businessEntity", userBusinessModelDTO.getEntityName());
        params.put("businessEntityImportInfo", userBusinessModelDTO.getImportInfo().get("Entity"));
        HashMap<String, String> businessColumn = new HashMap<String, String>();
        List<SqlServerDataModelFieldDto> businessFields = userBusinessModelDTO.getFields();
        for (SqlServerDataModelFieldDto sqlServerDataModelFieldDto : businessFields) {
            if (!ToolUtil.isNotEmpty((Object)sqlServerDataModelFieldDto.getFill())) continue;
            businessColumn.put(sqlServerDataModelFieldDto.getFill(), sqlServerDataModelFieldDto.getName());
            if (!"primary".equals(sqlServerDataModelFieldDto.getFill())) continue;
            params.put("primaryType", sqlServerDataModelFieldDto.getColumnType().getType());
            if (!ToolUtil.isNotEmpty((Object)sqlServerDataModelFieldDto.getColumnType().getImportT())) continue;
            imports.add(sqlServerDataModelFieldDto.getColumnType().getImportT());
        }
        params.put("businessColumn", businessColumn);
        List<SqlServerDataModelField> fields = task.getFields();
        for (SqlServerDataModelField field : fields) {
            if ("foreign".equals(field.getUsage())) {
                params.put("taskForeign", field.getSourceFieldName());
            }
            if (!"taskId".equals(field.getName())) continue;
            params.put("taskTaskId", field.getSourceFieldName());
        }
        params.put("dataSourceName", useDataModelBase.getDataSourceName());
        params.put("imports", imports);
        SqlServerCodeGenerateInfo sqlServerCodeGenerateInfo = new SqlServerCodeGenerateInfo();
        sqlServerCodeGenerateInfo.setFileWriteRelativePath(writePath);
        sqlServerCodeGenerateInfo.setFileContent(RenderUtil.renderTemplate((String)dataBackFillPath, params));
        sqlServerCodeGenerateInfo.setFileType("serviceImpl");
        sqlServerCodeGenerateInfo.setFileId(useDataModelDTO.getId());
        sqlServerCodeGenerateInfo.setFileName(userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl" + ".java");
        return sqlServerCodeGenerateInfo;
    }
}

