/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.view;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.view.SqlServerViewDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.view.SqlServerViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerQueryDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryConditionField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortConditionField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.render.SqlServerViewRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.constant.SqlServerConstUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERVIEWTableQuery")
public class SqlServerViewTableQueryVisitor
implements SqlServerOperationVisitor<SqlServerViewDataModel, SqlServerViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerViewTableQueryVisitor.class);
    public static final String OPERATION_NAME = "SQL_SERVERVIEWTableQuery";

    @Override
    public void visit(SqlServerBackCtx<SqlServerViewDataModel, SqlServerViewDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        SqlServerViewDataModel useDataModelBase = backCtx.getUseDataModelBase();
        SqlServerViewDataModelDTO dataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelViewDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelViewDTO);
        controllerParams.put("returnValue", dataModelViewDTO.getEntityName());
        controllerParams.put("url", url);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelViewDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelViewDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        Boolean isPagination = Boolean.valueOf(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", Boolean.valueOf(isPagination.toString()));
        boolean isSortOverall = true;
        boolean isSelectCondition = this.renderSelectAndSort(backCtx, dataModelOperation, modelId, useDataModelBase, dataModelViewDTO, controllerParams, isPagination, isSortOverall);
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, dataModelViewDTO, controllerParams);
        String controllerPath = "template/sqlserver/backcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelViewDTO.getServiceName());
        String servicePath = "template/sqlserver/backcode/tableQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/sqlserver/backcode/tableQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        if (isSelectCondition) {
            backCtx.addServiceImplInversion(modelId, dataModelViewDTO.getMapperName());
            String mapperPath = "template/sqlserver/backcode/tableQuery/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String xmlPath = "template/sqlserver/backcode/tableQuery/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        this.renderImport(backCtx, modelId, dataModelViewDTO, isSelectCondition, isPagination, isSortOverall);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", url, "\u67e5\u8be2");
        backCtx.addApi(modelId, SqlServerViewRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(SqlServerBackCtx<SqlServerViewDataModel, SqlServerViewDataModelDTO> backCtx, String modelId, SqlServerViewDataModelDTO dataModelBaseDTO, boolean isSelectCondition, boolean isPagination, boolean isSortOverall) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.exception.HussarException");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            if (isPagination) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            } else {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            }
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isPagination) {
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
    }

    private boolean renderSelectAndSort(SqlServerBackCtx<SqlServerViewDataModel, SqlServerViewDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation, String modelId, SqlServerViewDataModel useDataModelBase, SqlServerViewDataModelDTO dataModelViewDTO, Map<String, Object> controllerParams, Boolean isPagination, boolean isSortOverall) throws LcdpException {
        SqlServerSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{sortConditionName}) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(SqlServerSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<SqlServerSortConditionField> sortConditionFields;
            if (!isPagination.booleanValue()) {
                sortConditionFields = sortCondition.getFields();
                for (SqlServerSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            } else {
                sortConditionFields = sortCondition.getFields();
                for (SqlServerSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            if (isPagination.booleanValue()) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        boolean isSelectCondition = false;
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            SqlServerQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
            ArrayList<String> likeQueryFields = new ArrayList<String>();
            for (SqlServerQueryConditionField queryConditionField : queryCondition.getFields()) {
                String fromModelField = queryConditionField.getFromModelField();
                List<SqlServerDataModelField> fields = useDataModelBase.getFields();
                boolean isStringType = true;
                for (SqlServerDataModelField field : fields) {
                    if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                    isStringType = false;
                    break;
                }
                if (!isStringType) continue;
                String symbol = queryConditionField.getSymbol();
                if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
                likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
            }
            controllerParams.put("likeQueryFields", likeQueryFields);
            if (Optional.ofNullable(queryCondition).map(SqlServerQueryCondition::getFields).isPresent() && !queryCondition.getFields().isEmpty()) {
                DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
                SqlServerQueryDTO queryDTO = SqlServerDataModelUtil.getQueryDto(dataSet, dataModelViewDTO);
                dataModelViewDTO.addQueryDto(queryDTO);
                String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), SqlServerConstUtil.FALSE, ConnectEnum._AND.getType(), null, dataModelViewDTO, null);
                controllerParams.put("QueryObj", queryDTO.getEntityName());
                controllerParams.put("queryObj", queryDTO.getName());
                controllerParams.put("whereSql", finalWhereSql);
                isSelectCondition = true;
                controllerParams.put("isSelectCondition", SqlServerConstUtil.TRUE);
                String importInfo = queryDTO.getImportInfo();
                backCtx.addControllerImport(modelId, importInfo);
                backCtx.addServiceImport(modelId, importInfo);
                backCtx.addServiceImplImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            }
        }
        return isSelectCondition;
    }

    private void renderPageVo(SqlServerBackCtx<SqlServerViewDataModel, SqlServerViewDataModelDTO> backCtx, String modelId, SqlServerViewDataModelDTO dataModelViewDTO, Map<String, Object> controllerParams) {
        SqlServerDataModelUtil.addQueryPageViewVo(dataModelViewDTO);
        String voEntityName = dataModelViewDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelViewDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

