/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.util;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleConfigDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeSaveDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeUpdateDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.formdesign.back.common.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.back.common.util.JsonParser;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SerialNumberUtil {
    public static String structureCodeRule(String fieldName, String fieldId) {
        return fieldName.replace("_", "") + ":" + fieldId.replace("-", "_");
    }

    public static void saveCodeRule(JSONObject jsonObject, String tableComment, String tableName, String fieldName, Map<String, Object> controllerParams, boolean isMs, String fieldId) {
        JSONObject msjsonObject = null;
        if (isMs) {
            msjsonObject = (JSONObject)jsonObject.get((Object)"masterTable");
        }
        ArrayList<String> list = new ArrayList<String>();
        String ruleCode = SerialNumberUtil.structureCodeRule(fieldName, fieldId);
        String title = ToolUtil.isNotEmpty((Object)tableComment) ? tableComment : tableName;
        SysCodeRuleDto sysCodeRuleDto = new SysCodeRuleDto();
        sysCodeRuleDto.setRuleCode(ruleCode);
        sysCodeRuleDto.setPageNo(Integer.valueOf(1));
        sysCodeRuleDto.setPageSize(Integer.valueOf(10));
        ISysCodeRuleService iSysCodeRuleService = (ISysCodeRuleService)SpringUtil.getBean(ISysCodeRuleService.class);
        Page pageApiResponse = iSysCodeRuleService.getPageListCodeRules(sysCodeRuleDto);
        List records = pageApiResponse.getRecords();
        Optional modelFields = JsonParser.array((Object)(isMs ? msjsonObject : jsonObject), (String)"$.fields", SqlServerDataModelField.class);
        if (!modelFields.isPresent()) {
            return;
        }
        List<Object> serialNumRuleDTOS = new ArrayList();
        for (Object dataModelFieldBase : (List)modelFields.get()) {
            if (!HussarUtils.equals((Object)dataModelFieldBase.getUsage(), (Object)"serialNumber")) continue;
            serialNumRuleDTOS = dataModelFieldBase.getSerialNum();
            break;
        }
        if (ToolUtil.isEmpty(serialNumRuleDTOS)) {
            return;
        }
        ArrayList<SysCodeRuleConfigDto> sysCodeSaveDTOs = new ArrayList<SysCodeRuleConfigDto>();
        for (SerialNumRuleDTO codeRule : serialNumRuleDTOS) {
            SysCodeRuleConfigDto sysCodeRuleInfo = new SysCodeRuleConfigDto();
            String type = codeRule.getType();
            String name = codeRule.getName();
            sysCodeRuleInfo.setElementType(type);
            Long id = codeRule.getConfig().getId();
            if (HussarUtils.isEmpty((Object)id)) {
                id = IdWorker.getId((Object)sysCodeRuleInfo);
                codeRule.getConfig().setId(id);
            }
            sysCodeRuleInfo.setCodeRuleInfoId(id);
            if (HussarUtils.equals((Object)type, (Object)"serialNumber")) {
                sysCodeRuleInfo.setElementPattern("1");
                sysCodeRuleInfo.setSerialNumberLength(codeRule.getConfig().getCountLength());
                sysCodeRuleInfo.setSerialNumberStart(codeRule.getConfig().getInitialVal());
                sysCodeRuleInfo.setResetPeriod(codeRule.getConfig().getResetType());
            }
            if (HussarUtils.equals((Object)type, (Object)"constant") || HussarUtils.equals((Object)type, (Object)"codeDateTime")) {
                sysCodeRuleInfo.setElementPattern(codeRule.getConfig().getValue());
            }
            if (HussarUtils.equals((Object)type, (Object)"modelFields")) {
                sysCodeRuleInfo.setElementType("variable");
                sysCodeRuleInfo.setElementPattern(codeRule.getConfig().getValue());
                list.add(codeRule.getConfig().getValue());
            }
            if (HussarUtils.equals((Object)type, (Object)"userInfo")) {
                sysCodeRuleInfo.setElementType("variable");
                sysCodeRuleInfo.setElementPattern(name);
                list.add(name);
            }
            sysCodeSaveDTOs.add(sysCodeRuleInfo);
        }
        controllerParams.put("variables", list);
        if (HussarUtils.isNotEmpty((Object)records)) {
            SysCodeUpdateDto sysCodeUpdateDto = new SysCodeUpdateDto();
            SysCodeRuleVo sysCodeRuleVo = (SysCodeRuleVo)pageApiResponse.getRecords().get(0);
            Long codeRuleId = sysCodeRuleVo.getCodeRuleId();
            sysCodeUpdateDto.setCodeRuleId(codeRuleId);
            sysCodeUpdateDto.setCodeRuleCode(ruleCode);
            sysCodeUpdateDto.setCodeRuleName(title);
            sysCodeUpdateDto.setCodeRuleDesc(title);
            sysCodeUpdateDto.setSys("0");
            sysCodeUpdateDto.setLevel("0");
            sysCodeUpdateDto.setSysCodeRuleConfigList(sysCodeSaveDTOs);
            iSysCodeRuleService.updateCodeRule(sysCodeUpdateDto);
        } else {
            SysCodeSaveDto sysCodeSaveDto = new SysCodeSaveDto();
            sysCodeSaveDto.setCodeRuleName(title);
            sysCodeSaveDto.setCodeRuleCode(ruleCode);
            sysCodeSaveDto.setCodeRuleDesc(title);
            sysCodeSaveDto.setSys("0");
            sysCodeSaveDto.setLevel("0");
            sysCodeSaveDto.setSysCodeRuleConfigList(sysCodeSaveDTOs);
            iSysCodeRuleService.saveCodeRule(sysCodeSaveDto);
        }
    }
}

