/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.flow.masterslaveflow.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerQueryDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.masterslave.util.SqlServerMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SqlServerFlowMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";
    private static final String FLOW_INCREMENT_NAME = "FlowIncrementDTO";

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx) throws LcdpException {
        SqlServerFlowMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx) throws LcdpException {
        SqlServerFlowMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        SqlServerMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        SqlServerMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        SqlServerDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<SqlServerRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        SqlServerDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (SqlServerRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (SqlServerRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = SqlServerFlowMsUtil.getDelStr(relationshipDtoList, masterDto);
        SqlServerFlowMsUtil.renderTransaction(backCtx, params, currentModelId);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (SqlServerRelationshipDTO sqlserverRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            SqlServerDataModelBaseDTO SqlServerDataModelBaseDTO2 = baseDataModelDTO.getDataModelDtoMap().get(sqlserverRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, SqlServerDataModelBaseDTO2.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, SqlServerDataModelBaseDTO2.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, SqlServerDataModelBaseDTO2.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        SqlServerMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        SqlServerMsDataModelDTO SqlServerMsDataModelDTO2 = backCtx.getUseDataModelDtoMap().get(modelId);
        List<SqlServerRelationshipDTO> relationshipDtoList = SqlServerMsDataModelDTO2.getRelationshipDtoList();
        SqlServerDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, SqlServerDataModelBaseDTO> dataModelDtoMap = SqlServerMsDataModelDTO2.getDataModelDtoMap();
        SqlServerDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        SqlServerFlowMsUtil.renderTransaction(backCtx, controllerParams, modelId);
        String masterFillCode = SqlServerFlowMsUtil.renderFillCode(backCtx, mainDataModelDto, SqlServerMsDataModelDTO2);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (SqlServerRelationshipDTO relationshipDTO : relationshipDtoList) {
                List<SqlServerRelationshipFieldDTO> sqlserverRelationshipFieldDTOS;
                String slaveTableId = relationshipDTO.getSlaveTableId();
                String relateModelType = relationshipDTO.getRelateModelType();
                SqlServerDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = SqlServerFlowMsUtil.renderFillCode(backCtx, slaveModelDto, SqlServerMsDataModelDTO2);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    relationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(sqlserverRelationshipFieldDTOS = relationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams, String modelId) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, SqlServerDataModelBaseDTO dataModelBaseDTO, SqlServerMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (SqlServerDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("modelId", msDataModelDTO.getId());
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/sqlserver/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<SqlServerRelationshipDTO> relationshipDtoList, SqlServerDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (SqlServerRelationshipDTO relationtMap : relationshipDtoList) {
            List<SqlServerRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            SqlServerRelationshipFieldDTO sqlserverRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                Optional<SqlServerDataModelFieldDto> relationTag;
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(sqlserverRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
                List<SqlServerDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    SqlServerDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(sqlserverRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                Optional<SqlServerDataModelFieldDto> relationTag;
                SqlServerRelationshipFieldDTO sqlserverRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(sqlserverRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(sqlserverRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(sqlserverRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(SqlServerFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(sqlserverRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(sqlserverRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(SqlServerFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(sqlserverRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                List<SqlServerDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    SqlServerDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void generateIncrementDTO(SqlServerMsDataModelDTO sqlServerFlowDataModelDTO, SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation) {
        Map<String, Object> params = dataModelOperation.getParams();
        Map slaveTablePlusSave = (Map)params.get("slaveTablePlusSave");
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        SqlServerMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        for (SqlServerDataModelBase sqlServerDataModelBase : dataModelBase.getSlaveTables()) {
            String slaveModelName = sqlServerDataModelBase.getName();
            SqlServerDataModelBaseDTO sqlServerDataModelBaseDTO = sqlServerFlowDataModelDTO.getDataModelDtoMap().get(sqlServerDataModelBase.getId());
            for (SqlServerDataModelFieldDto field : sqlServerDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(field.getFill())) continue;
                relationTagKeys.put(slaveModelName, field.getCapitalName());
            }
        }
        params.put("relationTagKeys", relationTagKeys);
        boolean plusFlag = false;
        if (HussarUtils.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        params.put("ifPlusSave", plusFlag);
        if (!plusFlag) {
            return;
        }
        for (SqlServerRelationshipDTO relationshipDTO : sqlServerFlowDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        SqlServerFlowMsUtil.addIncrementTable(sqlServerFlowDataModelDTO, slaveTablePlusSave, dataModelBase);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        for (SqlServerDataModelBase modelBase : dataModelBase.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((SqlServerBaseDataModel)modelBase).getLogicallyDelete());
            SqlServerDataModelBaseDTO sqlServerDataModelBaseDTO = sqlServerFlowDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, SqlServerMasterSlaveUtil.getCapitalName(slaveModelName));
            for (SqlServerDataModelField sqlServerDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(sqlServerDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, sqlServerDataModelField.getName());
                break;
            }
            for (SqlServerDataModelFieldDto sqlServerDataModelFieldDto : sqlServerDataModelBaseDTO.getFields()) {
                if ("primary".equals(sqlServerDataModelFieldDto.getFill())) {
                    hashMap.put(slaveModelName, sqlServerDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(sqlServerDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, sqlServerDataModelFieldDto.getCapitalName());
            }
        }
        params.put("primaryKeys", hashMap);
        params.put("foreignKeys", foreignKeys);
        params.put("slaveTablePlusSave", slaveTablePlusSave);
        params.put("slaveTable", SqlServerMasterSlaveUtil.ofSlaveParam(dataModelBase, sqlServerFlowDataModelDTO));
        params.put("isLogicallyDelete", isLogicallyDelete);
        params.put("logicallyDelField", logicallyDelField);
        params.put("capitalNameList", capitalNameList);
        String modelId = backCtx.getUseDataModelBase().getId();
        if (HussarUtils.isEmpty((Object)sqlServerFlowDataModelDTO.getQueryDtoMap().get(sqlServerFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME))) {
            SqlServerQueryDTO oldDTO = sqlServerFlowDataModelDTO.getQueryDtoMap().get(sqlServerFlowDataModelDTO.getName());
            SqlServerQueryDTO sqlServerQueryDTO = (SqlServerQueryDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oldDTO), SqlServerQueryDTO.class);
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            newParams.put("queryDto", sqlServerQueryDTO);
            HashMap<String, Boolean> table = new HashMap<String, Boolean>();
            table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
            newParams.put("table", table);
            sqlServerQueryDTO.setParams(newParams);
            String string = sqlServerFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME;
            String plusTableName = sqlServerFlowDataModelDTO.getEntityName() + "IncrementTable";
            for (SqlServerQueryFieldDTO dto : sqlServerQueryDTO.getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                dto.getDbColumnType().setType(plusTableName);
                dto.getDbColumnType().setImportT(sqlServerQueryDTO.getPackageInfo() + "." + plusTableName);
                params.put("incrementTable", dto.getDbColumnType());
                backCtx.addServiceImplImport(modelId, dto.getDbColumnType().getImportT());
                break;
            }
            sqlServerQueryDTO.setName(sqlServerQueryDTO.getName() + FLOW_INCREMENT_NAME);
            sqlServerQueryDTO.setEntityName(string);
            sqlServerQueryDTO.setImportInfo(sqlServerQueryDTO.getPackageInfo() + "." + string);
            sqlServerQueryDTO.setWriteFilePath(FileUtil.systemPath((String[])new String[]{sqlServerFlowDataModelDTO.getTablePath(), "dto", string + ".java"}));
            sqlServerFlowDataModelDTO.getQueryDtoMap().put(sqlServerQueryDTO.getName(), sqlServerQueryDTO);
            params.put("parameter", string);
            backCtx.addControllerImport(modelId, sqlServerQueryDTO.getImportInfo());
            backCtx.addServiceImport(modelId, sqlServerQueryDTO.getImportInfo());
            backCtx.addServiceImplImport(modelId, sqlServerQueryDTO.getImportInfo());
        } else {
            for (SqlServerQueryFieldDTO dto : sqlServerFlowDataModelDTO.getQueryDtoMap().get(sqlServerFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME).getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                params.put("incrementTable", dto.getDbColumnType());
                break;
            }
            params.put("parameter", sqlServerFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME);
        }
    }

    private static void addIncrementTable(SqlServerMsDataModelDTO dataModelBaseDTO, Map<String, Boolean> slaveTablePlusSave, SqlServerMsDataModel dataModelBase) {
        SqlServerQueryDTO queryDTO = new SqlServerQueryDTO();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/sqlserver/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelBaseDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", SqlServerMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setName(dataModelBaseDTO.getName() + "IncrementTable");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "IncrementTable");
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }
}

