/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.flow.masterslaveflow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerQueryDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortConditionField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.translate.SqlServerTranslate;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.translate.SqlServerTranslateField;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerBackRenderUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERFLOW_MASTER_SLAVEExcelExport")
public class SqlServerMsFlowExcelExportVisitor
implements SqlServerOperationVisitor<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerMsFlowExcelExportVisitor.class);
    public static final String OPERATION_NAME = "SQL_SERVERFLOW_MASTER_SLAVEExcelExport";

    @Override
    public void visit(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        SqlServerFlowMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        List<SqlServerDataModelBase> sqlServerDataModelBases = dataModelBase.getSlaveTables();
        SqlServerDataModelBase masterTable = dataModelBase.getMasterTable();
        SqlServerFlowMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, SqlServerDataModelBaseDTO> dataModelDtoMap = dataModelBaseDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("operationName", controllerParams.get("name"));
        controllerParams.put("selectCondition", dataModelBaseDTO.getEntityName());
        SqlServerDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortCondition = this.renderSort(backCtx, dataModelOperation, modelId, controllerParams, dataModelBase);
        boolean isSortOverall = true;
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderFilter(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/sqlserver/masterslavebackcode/excelExport/controller.ftl";
        controllerParams.put("QueryObj", dataModelBaseDTO.getEntityName() + "SelectCondition");
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelExportDto");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            for (SqlServerDataModelFieldDto field : dataModelBaseDTO.getFields()) {
                String typeName = "";
                String fieldAnnotation = field.getFieldAnnotation();
                if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                    int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                    int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                    if (startIndex != -1 && endIndex != -1) {
                        typeName = fieldAnnotation.substring(startIndex, endIndex);
                    }
                }
                field.setDictTyeName(typeName);
            }
            dataModelBaseDTO.getDataModelDtoMap().entrySet().stream().filter(a -> !masterTable.getId().equals(a.getKey())).forEach(entry -> {
                for (SqlServerDataModelFieldDto field : ((SqlServerDataModelBaseDTO)entry.getValue()).getFields()) {
                    String typeName = "";
                    String fieldAnnotation = field.getFieldAnnotation();
                    if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                        int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                        int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                        if (startIndex != -1 && endIndex != -1) {
                            typeName = fieldAnnotation.substring(startIndex, endIndex);
                        }
                    }
                    field.setDictTyeName(typeName);
                }
            });
            backCtx.addServiceImplInversion(modelId, "ISysDicRefService");
        }
        String servicePath = "template/sqlserver/masterslavebackcode/excelExport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImport(modelId, "java.util.List");
        DataModelBase dataModelBaseNew = DataModelUtil.getDataModelBase((String)modelId);
        SqlServerDataModelBase currentModelBase = SqlServerDataModelUtil.transfer(dataModelBaseNew);
        List<SqlServerTranslate> sqlServerTranslates = currentModelBase.getTranslate();
        controllerParams.put("modelTranslate", false);
        HashMap<String, String> transMap = new HashMap<String, String>();
        ArrayList<String> slaveTableName = new ArrayList<String>();
        HashMap<String, String> slaveTableNameMap = new HashMap<String, String>();
        for (SqlServerTranslate sqlServerTranslate : sqlServerTranslates) {
            if (!sqlServerTranslate.getTranslateType().equals("modelTranslate")) continue;
            JSONArray allFields = (JSONArray)DataModelUtil.getDataModelJson((String)sqlServerTranslate.getSourceId()).get((Object)"fields");
            if (HussarUtils.isEmpty((Object)allFields)) {
                allFields = (JSONArray)DataModelUtil.getDataModelJson((String)sqlServerTranslate.getSourceId()).getJSONObject("masterTable").get((Object)"fields");
            }
            for (int i = 0; i < masterTable.getFields().size(); ++i) {
                if (!masterTable.getFields().get(i).getId().equals(sqlServerTranslate.getSourceFieldId())) continue;
                List<SqlServerTranslateField> fields = sqlServerTranslate.getTranslateFields();
                for (SqlServerTranslateField sqlServerTranslateField : fields) {
                    for (int j = 0; j < allFields.size(); ++j) {
                        if (!sqlServerTranslateField.getTranslateSource().equals(((JSONObject)allFields.get(j)).get((Object)"id"))) continue;
                        transMap.put(masterTable.getTableDesc() + masterTable.getFields().get(i).getSourceFieldName(), sqlServerTranslateField.getName());
                    }
                }
            }
            for (SqlServerDataModelBase modelBase : sqlServerDataModelBases) {
                if (!slaveTableName.contains(modelBase.getName().substring(0, 1).toUpperCase() + modelBase.getName().substring(1))) {
                    slaveTableName.add(modelBase.getName().substring(0, 1).toUpperCase() + modelBase.getName().substring(1));
                    slaveTableNameMap.put(modelBase.getName().substring(0, 1).toUpperCase() + modelBase.getName().substring(1), modelBase.getComment().substring(0, 1).toUpperCase() + modelBase.getComment().substring(1));
                }
                for (int i = 0; i < modelBase.getFields().size(); ++i) {
                    if (!modelBase.getFields().get(i).getId().equals(sqlServerTranslate.getSourceFieldId())) continue;
                    List<SqlServerTranslateField> fields = sqlServerTranslate.getTranslateFields();
                    for (SqlServerTranslateField sqlServerTranslateField : fields) {
                        for (int j = 0; j < allFields.size(); ++j) {
                            if (!sqlServerTranslateField.getTranslateSource().equals(((JSONObject)allFields.get(j)).get((Object)"id"))) continue;
                            transMap.put(modelBase.getTableDesc() + modelBase.getFields().get(i).getSourceFieldName(), sqlServerTranslateField.getName());
                        }
                    }
                }
            }
            controllerParams.put("modelTranslate", true);
        }
        String transResult = transMap.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(", "));
        controllerParams.put("transMap", transResult);
        controllerParams.put("slaveTableName", slaveTableName);
        String transResult2 = slaveTableNameMap.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(", "));
        controllerParams.put("slaveTableNameMap", transResult2);
        String serviceImplPath = "template/sqlserver/masterslavebackcode/excelExport/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.annotations.QueryAlias");
        backCtx.addServiceImplImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.model.DicSingle");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.util.ExcelUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.vo.DictVo");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "java.util.Objects");
        backCtx.addServiceImplImport(modelId, "io.swagger.annotations.ApiModelProperty");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.annotation.TableId");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.service.ISysDicRefService");
        backCtx.addServiceImplImport(modelId, "java.util.Set");
        backCtx.addServiceImplImport(modelId, "java.util.LinkedHashMap");
        backCtx.addServiceImplImport(modelId, "java.lang.reflect.Field");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/sqlserver/masterslavebackcode/excelExport/mapper.ftl";
        String finalReturn = SqlReturnUtil.renderReturn(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName());
        controllerParams.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "java.util.LinkedHashMap");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        String xmlPath = "template/sqlserver/masterslavebackcode/excelExport/xml.ftl";
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "downloadResource", url, "\u6d41\u7a0b\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
        backCtx.addApi(modelId, SqlServerBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private boolean renderSort(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation, String modelId, Map<String, Object> controllerParams, SqlServerFlowMsDataModel useDataModelBase) throws LcdpException {
        SqlServerSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(SqlServerSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<SqlServerSortConditionField> sortConditionFields = sortCondition.getFields();
            for (SqlServerSortConditionField sortConditionField : sortConditionFields) {
                sortConditionField.replaceFieldName(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            return true;
        }
        return false;
    }

    private boolean renderFilter(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation, String modelId, SqlServerMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("showFilter"));
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        controllerParams.put("showFilter", true);
        SqlServerQueryDTO queryDTO = SqlServerDataModelUtil.getFilterDto(dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(queryDTO);
        controllerParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private void renderPageVo(SqlServerBackCtx<SqlServerFlowMsDataModel, SqlServerFlowMsDataModelDTO> backCtx, String modelId, SqlServerMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        SqlServerDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

