<#include "../../../auditLog/ds.ftl">
<#assign isSave = 1>
<#assign methodName = name >
<#include "../../../saveordel/saveordel.ftl">

@Override
<#if !isRemote>${ds!}</#if>
public ApiResponse<String> ${name!}(${parameter} ${parameter?uncap_first}){
    try {
    <#if !ifPlusSave>
        ${table.entityName} ${table.EName} = ${parameter?uncap_first}.getFormdata();
    <#else>
        ${incrementTable.type!} ${table.EName} = ${parameter?uncap_first}.getFormdata();
    </#if>
        String taskId = ${parameter?uncap_first}.getTaskId();
        String comment = ${parameter?uncap_first}.getComment();
        boolean isSubmit = ${parameter?uncap_first}.isSubmit();
        ${saveOrDel!}
        this.formrecall<#if ifPlusSave>Plus</#if>(taskId,comment,isSubmit);
        return ApiResponse.success();
    } catch (Exception e) {
        throw new HussarException(e.getMessage(),e);
    }
}

@Override
${ds!}
${dataSourceAnnotation!}
public void formrecall<#if ifPlusSave>Plus</#if>(String taskId, String comment,boolean isSubmit){
    if(HussarUtils.isEmpty(BaseSecurityUtil.getUser())){
        <#if table?? && table.transDisposition?? && table.transDisposition>
        throw new HussarException(TfModelEnum.TF_FAILED_T0_OBTAIN_USER_INFORMATION.getMessage());
        <#else>
        throw new HussarException("获取用户信息失败");
        </#if>
    }
    String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
    BpmResponseResult check;
    BpmResponseResult revoke;
    try {
        check = TaskEngineService.withdrawState(taskId);
        if (BpmConstant.ERROR_CODE.equals(check.getCode())) {
            throw new HussarException(check.getMsg());
        }
        if (!(Boolean) check.getResult().get(0)) {
            if (check.getResult().size() > 1 && ToolUtil.isNotEmpty(check.getResult().get(1))) {
                throw new HussarException(check.getResult().get(1).toString());
            }
            <#if table?? && table.transDisposition?? && table.transDisposition>
            throw new HussarException(TfModelEnum.TF_THE_CURRENT_NODE_CANNOT_BE_RECALLED.getMessage());
            <#else>
            throw new HussarException("当前节点不能撤回");
            </#if>
        }
        revoke = TaskEngineService.revokeTask(taskId, userId, comment, isSubmit, null);
        if (BpmConstant.ERROR_CODE.equals(revoke.getCode())) {
            throw new HussarException(revoke.getMsg());
        }
    } catch(Exception e){
        throw new HussarException(e.getMessage(),e);
    }
}
