package ${table.packageInfo.Entity!};

<#assign entity = table.entityGenerateInfo!>
<#include "../../swagger/swagger_model.ftl">
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import org.apache.ibatis.type.Alias;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
<#list entity.imports! as import>
import ${import};
</#list>
${entityimport}

/**
* ${table.comment!}实体类
*/
@Alias("${entity.qualifyBeanName!}")
<#if table.sourceDataModelName?? && table.sourceDataModelName != ''>
@TableName("${table.sourceDataModelName!}")
<#--@ApiModel(value = "${table.comment}")-->
</#if>
${apimodel!}
public class ${table.entityName!} implements BaseEntity {

    private static final long serialVersionUID = 1L;

<#assign keyPropertyName = "">
<#list table.fields! as field>
    /**
    * ${field.comment}
    */
<#if table.useMybatisPlus && "" != field.name>
    <#if field.keyFlag>
        <#assign keyPropertyName= field.propertyName>
    @TableId("${field.name ? upper_case}")
<#--    @ApiModelProperty(value = "${field.comment}")-->
    <#else >
    @TableField(
        <#if field.type != "array">value=</#if>"${field.name ? upper_case}"
        <#if field.type != "array">,updateStrategy = FieldStrategy.NOT_EMPTY</#if>
    )
    </#if>
</#if>
    <#if table.validateAnnotations?? && (table.validateAnnotations?size>0)>
        <#list table.validateAnnotations[field.propertyName]! as annotation>
            ${annotation}
        </#list>
    </#if>
    <#if field.fieldAnnotation??>
        ${field.fieldAnnotation}
    </#if>
    <#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
        <#if field.comment?? && field.comment!=''>
            @ApiModelProperty(value = "${field.comment!}")
        <#else>
            @ApiModelProperty(value = "${field.propertyName}")
        </#if>
    </#if>
    private ${field.propertyType} ${field.propertyName};

</#list>

<#list table.translateShowFields! as field>
    /**
    * ${field.comment}
    */
    @TableField(exist = false)
    <#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
        <#if field.comment?? && field.comment!=''>
            @ApiModelProperty(value = "${field.comment!}")
        <#else>
            @ApiModelProperty(value = "${field.propertyName}")
        </#if>
    </#if>
    private ${field.propertyType} ${field.propertyName};
</#list>

/* @begin property #自定义属性 */
/* @end property */

<#list table.fields! as field>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName!}() {
        return ${field.propertyName};
    }

    public void set${field.capitalName!}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }

</#list>

<#list table.translateShowFields! as field>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName!}() {
            return ${field.propertyName};
        }

    public void set${field.capitalName!}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }
</#list>

/* @begin getAndSet #自定义get、set */
/* @end getAndSet */

    @Override
    public String toString() {
    return "${table.enName}{" +
    <#list table.fields! as field>
        <#if field_index == 0>
            "${field.propertyName}=" + ${field.propertyName} +
        <#else>
            ", ${field.propertyName}=" + ${field.propertyName} +
        </#if>
    </#list>
    "}";
    }
}
