/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.task.masterslavetask.util;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SqlServerTaskMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";

    private SqlServerTaskMsUtil() {
    }

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx) throws LcdpException {
        SqlServerTaskMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx) {
        SqlServerTaskMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        SqlServerMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        SqlServerMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        SqlServerDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<SqlServerRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        SqlServerDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (SqlServerRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (SqlServerRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = SqlServerTaskMsUtil.getDelStr(relationshipDtoList, masterDto);
        SqlServerTaskMsUtil.renderTransaction(backCtx, params);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (SqlServerRelationshipDTO sqlserverRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            SqlServerDataModelBaseDTO sqlserverDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(sqlserverRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, sqlserverDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, sqlserverDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, sqlserverDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        SqlServerMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        SqlServerMsDataModelDTO sqlserverMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<SqlServerRelationshipDTO> relationshipDtoList = sqlserverMsDataModelDTO.getRelationshipDtoList();
        SqlServerDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, SqlServerDataModelBaseDTO> dataModelDtoMap = sqlserverMsDataModelDTO.getDataModelDtoMap();
        SqlServerDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        SqlServerTaskMsUtil.renderTransaction(backCtx, controllerParams);
        String masterFillCode = SqlServerTaskMsUtil.renderFillCode(mainDataModelDto, sqlserverMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (SqlServerRelationshipDTO sqlserverRelationshipDTO : relationshipDtoList) {
                List<SqlServerRelationshipFieldDTO> sqlserverRelationshipFieldDTOS;
                String slaveTableId = sqlserverRelationshipDTO.getSlaveTableId();
                String relateModelType = sqlserverRelationshipDTO.getRelateModelType();
                SqlServerDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = SqlServerTaskMsUtil.renderFillCode(slaveModelDto, sqlserverMsDataModelDTO);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    sqlserverRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(sqlserverRelationshipFieldDTOS = sqlserverRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(SqlServerDataModelBaseDTO dataModelBaseDTO, SqlServerMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (SqlServerDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/sqlserver/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<SqlServerRelationshipDTO> relationshipDtoList, SqlServerDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (SqlServerRelationshipDTO relationtMap : relationshipDtoList) {
            List<SqlServerRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            SqlServerRelationshipFieldDTO sqlserverRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(sqlserverRelationshipFieldDTO.getSlaveFieldCap()).append(",idList));\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(sqlserverRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                SqlServerRelationshipFieldDTO sqlserverRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(sqlserverRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(sqlserverRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(sqlserverRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(SqlServerTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(sqlserverRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(sqlserverRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(SqlServerTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(sqlserverRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void transferControllerCode(SqlServerDataModelBaseDTO fromDataModelBaseDTO, SqlServerDataModelBaseDTO toDataModelBaseDTO) {
        ControllerGenerateInfo businessController = fromDataModelBaseDTO.getControllerGenerateInfo();
        ControllerGenerateInfo taskController = toDataModelBaseDTO.getControllerGenerateInfo();
        if (HussarUtils.isEmpty((Object)taskController)) {
            taskController = new ControllerGenerateInfo();
            toDataModelBaseDTO.setControllerGenerateInfo(taskController);
        }
        if (HussarUtils.isNotEmpty((Object)businessController)) {
            if (HussarUtils.isNotEmpty(businessController.getImports())) {
                if (HussarUtils.isEmpty(taskController.getImports())) {
                    taskController.setImports(new HashSet<String>());
                }
                taskController.getImports().addAll(businessController.getImports());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversions())) {
                if (HussarUtils.isEmpty(taskController.getInversions())) {
                    taskController.setInversions(new HashSet<String>());
                }
                taskController.getInversions().addAll(businessController.getInversions());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversionsWithName())) {
                if (HussarUtils.isEmpty(taskController.getInversionsWithName())) {
                    taskController.setInversionsWithName(new HashMap<String, String>());
                }
                taskController.getInversionsWithName().putAll(businessController.getInversionsWithName());
            }
            if (HussarUtils.isNotEmpty(businessController.getCodes())) {
                if (HussarUtils.isEmpty(taskController.getCodes())) {
                    taskController.setCodes(new ArrayList<String>());
                }
                taskController.getCodes().addAll(businessController.getCodes());
            }
        }
        if (HussarUtils.isNotEmpty(fromDataModelBaseDTO.getApis())) {
            if (HussarUtils.isEmpty(toDataModelBaseDTO.getApis())) {
                toDataModelBaseDTO.setApis(new ArrayList<String>());
            }
            toDataModelBaseDTO.getApis().addAll(fromDataModelBaseDTO.getApis());
        }
    }
}

