/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.flow.baseflow.util.SqlServerFlowBaseUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerBackRenderUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERFLOWFlowFormSubmit")
public class SqlServerFlowFormSubmitCodeVisitor
implements SqlServerOperationVisitor<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerFlowFormSubmitCodeVisitor.class);
    public static final String OPERATION_NAME = "SQL_SERVERFLOWFlowFormSubmit";

    @Override
    public void visit(SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        SqlServerFlowDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        SqlServerDataModelFieldDto keyField = dataModelBaseDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        dataModelBaseDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().ifPresent(fieldDto -> controllerParams.put("securityLevel", fieldDto.getCapitalName()));
        String controllerPath = "template/sqlserver/flowbackcode/baseflowbackcode/flowformsubmit/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/sqlserver/flowbackcode/baseflowbackcode/flowformsubmit/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String fillCode = SqlServerFlowBaseUtil.renderFillCode(backCtx, dataModelBaseDTO);
        if (fillCode != null) {
            controllerParams.put("fillCode", fillCode);
        }
        String serviceImplPath = "template/sqlserver/flowbackcode/baseflowbackcode/flowformsubmit/service_impl.ftl";
        controllerParams.put("isRemote", VfgModeTool.isRemote());
        controllerParams.put("primaryField", keyField.getCapitalName());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355");
        backCtx.addApi(modelId, SqlServerBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> backCtx, String modelId, SqlServerFlowDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.Map");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
    }

    private Map<String, Object> initParams(SqlServerDataModelOperation dataModelOperation, SqlServerFlowDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("dataSourceAnnotation", SqlServerDataSourceUtil.getMethodDataSourceAnnotation());
        controllerParams.put("parameter", dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

