@Override
public void ${operationName!}(HttpServletResponse response, List<ExcelCommonDto> tableInfo, String fileName, boolean isEmpty) {
    //导出的表数量
    int num = tableInfo.size();
    // 将 Sheet 页添加到集合中
    Map<String, List<List<Object>>> sheets = new LinkedHashMap<>();
    //下拉框 <sheet页名, [<第几列（从0开始）, 下拉框选项值>]>
    Map<String, List<Map<Integer, List<String>>>> selectMap =new HashMap<>();
    <#if table.hasTranslate?? && table.hasTranslate!>
        //字典
        Map<String, Map<String, String>> dict = new HashMap<>();
        //字段与字典对应关系
        Map<String, String> map = new HashMap<>();
        <#list table.fields as field>
            <#if field.dictTyeName?? && field.dictTyeName != ''>
                map.put("${field.propertyName}","${field.dictTyeName}");
            </#if>
        </#list>
        <#list table.dataModelDtoMap as key, value>
            <#list value.fields as field>
                <#if field.dictTyeName?? && field.dictTyeName != ''>
                    map.put("${field.propertyName}","${field.dictTyeName}");
                </#if>
            </#list>
        </#list>
        List<DictVo> dictVosByTypeNames = iSysDicRefService.getDictVosByTypeNames(new ArrayList<>(map.values()));
        Map<String, List<DictVo>> group = dictVosByTypeNames.stream().collect(Collectors.groupingBy(DictVo::getTypeName));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            List<DictVo> dictVos = group.get(entry.getValue());
            if (HussarUtils.isNotEmpty(dictVos)){
                Map<String, String> collect = dictVos.get(0).getSingleList().stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
                dict.put(entry.getKey(), collect);
            }
        }
    </#if>
    for (int i = 0; i < num; i++) {
        List<List<Object>> sheet = new ArrayList<>();
        ExcelCommonDto excelCommonDto = tableInfo.get(i);
        //添加表头
        List<Object> sheetHead = new ArrayList<>(excelCommonDto.getColumnInfo().values());
        sheet.add(sheetHead);
        <#if table.hasTranslate?? && table.hasTranslate!>
            List<Map<Integer, List<String>>> selectList = new ArrayList<>();
            for (int j = 0; j < excelCommonDto.getColumnInfo().size(); j++) {
                String s = (new ArrayList<>(excelCommonDto.getColumnInfo().keySet())).get(j);
                if (dict.containsKey(s) || dict.containsKey(s.toUpperCase())) {
                    Map<String, String> keyValue = dict.get(s) == null ? dict.get(s.toUpperCase()) : dict.get(s);
                    Map<Integer, List<String>> temp = new HashMap<>();
                    temp.put(j, new ArrayList<>(keyValue.values()));
                    selectList.add(temp);
                }
            }
            selectMap.put(excelCommonDto.getTableComment(), selectList);
        </#if>
        //不是空模板需要查数据
        if (!isEmpty) {
            StringBuilder sb = new StringBuilder("select ");
            sb.append(String.join(",", ExcelUtils.camelToSnake(new ArrayList<>(excelCommonDto.getColumnInfo().keySet()))));
            sb.append(" from ");
            sb.append(excelCommonDto.getTableName());
            List<LinkedHashMap<String, Object>> list = ${table.mapperName?uncap_first}.getList(sb.toString());
            if (HussarUtils.isNotEmpty(list)) {
                for (LinkedHashMap<String, Object> values : list) {
                <#if table.hasTranslate?? && table.hasTranslate!>
                    //替换字典项
                    if (HussarUtils.isNotEmpty(dict) && ExcelUtils.haveCommonKeys(dict, values)){
                        values.replaceAll((k,v)-> {
                            if (HussarUtils.isNotEmpty(v) && dict.containsKey(k)) {
                                return dict.get(k).getOrDefault(v.toString(), v.toString());
                            }
                            return v;
                        });
                    }
                </#if>
                sheet.add(new ArrayList<>(values.values()));
                }
            }
        }
        //给sheet命名
        sheets.put(excelCommonDto.getTableComment(), sheet);
    }
    //导出
    ExcelUtils.exportManySheet(response, fileName, sheets, selectMap);
}