/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.task.masterslavetask;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERTASK_MASTER_SLAVEExcelImport")
public class SqlServerMsTaskExcelImportVisitor
implements SqlServerOperationVisitor<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerMsTaskExcelImportVisitor.class);
    public static final String OPERATION_NAME = "SQL_SERVERTASK_MASTER_SLAVEExcelImport";

    @Override
    public void visit(SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        SqlServerTaskMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        SqlServerDataModelBase masterTable = dataModelBase.getMasterTable();
        SqlServerTaskMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, SqlServerDataModelBaseDTO> dataModelDtoMap = dataModelBaseDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        controllerParams.put("slaveTable", SqlServerMsTaskExcelImportVisitor.getSlaveArrayTables(dataModelBaseDTO, dataModelBase));
        controllerParams.put("primaryField", dataModelBaseDTO.getKeyPropertyName());
        SqlServerDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
        controllerParams.put("masterServiceName", masterDTO.getServiceName());
        for (SqlServerDataModelBaseDTO gaussDataModelBaseDTO : dataModelDtoMap.values()) {
            backCtx.addServiceImplImport(modelId, gaussDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplImport(modelId, gaussDataModelBaseDTO.getImportInfo().get("Entity"));
        }
        backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u4e3b\u5b50\u8868Excel\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        String controllerPath = "template/sqlserver/masterslavebackcode/excelImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/sqlserver/masterslavebackcode/excelImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            for (SqlServerDataModelFieldDto sqlServerDataModelFieldDto : dataModelBaseDTO.getFields()) {
                String typeName = "";
                String fieldAnnotation = sqlServerDataModelFieldDto.getFieldAnnotation();
                if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                    int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                    int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                    if (startIndex != -1 && endIndex != -1) {
                        typeName = fieldAnnotation.substring(startIndex, endIndex);
                    }
                }
                sqlServerDataModelFieldDto.setDictTyeName(typeName);
            }
            dataModelBaseDTO.getDataModelDtoMap().entrySet().stream().skip(1L).forEach(entry -> {
                for (SqlServerDataModelFieldDto field : ((SqlServerDataModelBaseDTO)entry.getValue()).getFields()) {
                    String typeName = "";
                    String fieldAnnotation = field.getFieldAnnotation();
                    if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                        int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                        int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                        if (startIndex != -1 && endIndex != -1) {
                            typeName = fieldAnnotation.substring(startIndex, endIndex);
                        }
                    }
                    field.setDictTyeName(typeName);
                }
            });
            backCtx.addServiceImplInversion(modelId, "ISysDicRefService");
        }
        String serviceImplPath = "template/sqlserver/masterslavebackcode/excelImport/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.vo.DictVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.service.ISysDicRefService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.model.DicSingle");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.util.ExcelUtils");
        backCtx.addServiceImplImport(modelId, "java.lang.reflect.Field");
        backCtx.addServiceImplImport(modelId, "java.util.function.Function");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.Collections");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getServiceName());
        for (SqlServerDataModelBaseDTO gaussDataModelBaseDTO : dataModelBaseDTO.getDataModelDtoMap().values()) {
            backCtx.addServiceImplInversion(modelId, gaussDataModelBaseDTO.getServiceName());
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", url, "\u4efb\u52a1\u4e3b\u5b50\u8868Excel\u5bfc\u5165");
        backCtx.addApi(modelId, SqlServerBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<SqlServerDataModelBase> getSlaveArrayTables(SqlServerTaskMsDataModelDTO dataModelBaseDTO, SqlServerTaskMsDataModel dataModelBase) {
        CopyOnWriteArrayList<SqlServerDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<SqlServerDataModelBase>(dataModelBase.getSlaveTables());
        block0: for (SqlServerDataModelBase slaveArrayTable : slaveArrayTables) {
            for (SqlServerDataModelField field : slaveArrayTable.getFields()) {
                if (!"foreign".equals(field.getUsage())) continue;
                slaveArrayTable.setForeignField(field.getName());
                continue block0;
            }
        }
        return slaveArrayTables;
    }
}

