/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.task.masterslavetask;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERTASK_MASTER_SLAVEExcelExport")
public class SqlServerMsTaskExcelExportVisitor
implements SqlServerOperationVisitor<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerMsTaskExcelExportVisitor.class);
    public static final String OPERATION_NAME = "SQL_SERVERTASK_MASTER_SLAVEExcelExport";

    @Override
    public void visit(SqlServerBackCtx<SqlServerTaskMsDataModel, SqlServerTaskMsDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        SqlServerTaskMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        SqlServerDataModelBase masterTable = dataModelBase.getMasterTable();
        SqlServerTaskMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, SqlServerDataModelBaseDTO> dataModelDtoMap = dataModelBaseDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("operationName", controllerParams.get("name"));
        SqlServerDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        String controllerPath = "template/sqlserver/masterslavebackcode/excelExport/controller.ftl";
        controllerParams.put("QueryObj", dataModelBaseDTO.getEntityName() + "SelectCondition");
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelExportDto");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            for (SqlServerDataModelFieldDto field : dataModelBaseDTO.getFields()) {
                String typeName = "";
                String fieldAnnotation = field.getFieldAnnotation();
                if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                    int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                    int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                    if (startIndex != -1 && endIndex != -1) {
                        typeName = fieldAnnotation.substring(startIndex, endIndex);
                    }
                }
                field.setDictTyeName(typeName);
            }
            dataModelBaseDTO.getDataModelDtoMap().entrySet().stream().filter(a -> !masterTable.getId().equals(a.getKey())).forEach(entry -> {
                for (SqlServerDataModelFieldDto field : ((SqlServerDataModelBaseDTO)entry.getValue()).getFields()) {
                    String typeName = "";
                    String fieldAnnotation = field.getFieldAnnotation();
                    if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                        int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                        int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                        if (startIndex != -1 && endIndex != -1) {
                            typeName = fieldAnnotation.substring(startIndex, endIndex);
                        }
                    }
                    field.setDictTyeName(typeName);
                }
            });
            backCtx.addServiceImplInversion(modelId, "ISysDicRefService");
        }
        String servicePath = "template/sqlserver/masterslavebackcode/excelExport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImport(modelId, "java.util.List");
        String serviceImplPath = "template/sqlserver/masterslavebackcode/excelExport/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.model.DicSingle");
        backCtx.addServiceImplImport(modelId, "scala.collection.mutable.StringBuilder");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.util.ExcelUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.vo.DictVo");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.service.ISysDicRefService");
        backCtx.addServiceImplImport(modelId, "java.util.LinkedHashMap");
        backCtx.addServiceImplImport(modelId, "java.util.Set");
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/sqlserver/masterslavebackcode/excelExport/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "java.util.LinkedHashMap");
        String xmlPath = "template/sqlserver/masterslavebackcode/excelExport/xml.ftl";
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "downloadResource", url, "\u4efb\u52a1\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
        backCtx.addApi(modelId, SqlServerBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

