/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.task.basetask;

import com.jxdinfo.hussar.formdesign.back.common.constant.QueryType;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.task.SqlServerTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerQueryDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryConditionField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortConditionField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.render.SqlServerBaseRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.constant.SqlServerConstUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.task.basetask.SqlServerTaskTableQuery;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.task.basetask.SqlServerTaskTableQueryFlowTotals;
import com.jxdinfo.hussar.formdesign.sqlserver.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERTASKTableQuery")
public class SqlServerTaskTableQueryVisitor
implements SqlServerOperationVisitor<SqlServerTaskDataModel, SqlServerTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerTaskTableQueryVisitor.class);
    public static String TASK_PAGE_VO = "TaskPageVO";
    public static final String OPERATION_NAME = "SQL_SERVERTASKTableQuery";

    @Override
    public void visit(SqlServerBackCtx<SqlServerTaskDataModel, SqlServerTaskDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        SqlServerTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        SqlServerTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        if (QueryType.isTask((String)((String)dataModelOperation.getParams().get("queryType")))) {
            String businessId = modelId;
            SqlServerFlowDataModel businessDataModelBase = (SqlServerFlowDataModel)useDataModelDTO.getDataModelBaseMap().get(businessId);
            SqlServerFlowDataModelDTO businessDataModelDTO = (SqlServerFlowDataModelDTO)useDataModelDTO.getDataModelDtoMap().get(businessId);
            SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> newBackCtx = new SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO>();
            newBackCtx.setUseDataModelBase(businessDataModelBase);
            HashMap<String, SqlServerFlowDataModelDTO> map = new HashMap<String, SqlServerFlowDataModelDTO>();
            map.put(businessId, businessDataModelDTO);
            newBackCtx.setUseDataModelDtoMap(map);
            SqlServerTaskTableQuery.visit(newBackCtx, dataModelOperation);
            return;
        }
        if (QueryType.isFlowTotals((String)((String)dataModelOperation.getParams().get("queryType")))) {
            SqlServerTaskTableQueryFlowTotals.visit(backCtx, dataModelOperation);
            return;
        }
        boolean isLogicallyDelete = useDataModelBase.getLogicallyDelete();
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, useDataModelDTO, useDataModelBase);
        String mastId = useDataModelBase.getId();
        SqlServerDataModelFieldDto fieldDto = useDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto);
            String securityLevelSql = useDataModelBase.getModelAliasName().get(mastId) + "." + fieldDto.getName() + " &lt;= #{securityLevel}";
            controllerParams.put("securityLevelSql", securityLevelSql);
            hasSecurityLevel = true;
        }
        if (isLogicallyDelete) {
            controllerParams.put("deleteFlag", useDataModelDTO.getFieldCapitalName(useDataModelBase.getDeleteFlag().getName()));
        }
        Boolean isPagination = Boolean.valueOf(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), useDataModelDTO);
        boolean isSortOverall = true;
        boolean isSelectCondition = this.renderSelectAndSort(backCtx, dataModelOperation, modelId, useDataModelBase, useDataModelDTO, controllerParams, isPagination, isSortOverall);
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, useDataModelDTO, controllerParams);
        String controllerPath = "template/backcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/sqlserver/taskbackcode/basetaskbackcode/query/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/sqlserver/taskbackcode/basetaskbackcode/query/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        String finalReturn = SqlReturnUtil.renderReturn(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, useDataModelDTO.getMapperName());
        String mapperPath = "template/sqlserver/taskbackcode/basetaskbackcode/query/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String finalRelation = SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), useDataModelDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        String xmlPath = "template/sqlserver/taskbackcode/basetaskbackcode/query/xml.ftl";
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, useDataModelDTO, isSelectCondition, isPagination, isLogicallyDelete, isSortOverall, hasSecurityLevel);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, SqlServerBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(SqlServerBackCtx<SqlServerTaskDataModel, SqlServerTaskDataModelDTO> backCtx, String modelId, SqlServerBaseDataModelDTO dataModelBaseDTO, boolean isSelectCondition, boolean isPagination, boolean isLogicallyDelete, boolean isSortOverall, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "java.util.List");
            if (isPagination) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            } else {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            }
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isLogicallyDelete) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(SqlServerDataModelOperation dataModelOperation, SqlServerTaskDataModelDTO dataModelBaseDTO, SqlServerBaseDataModel sqlserverBaseDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        boolean isLogicallyDelete = sqlserverBaseDataModel.getLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        String queryType = (String)dataModelOperation.getParams().get("queryType");
        if (isLogicallyDelete) {
            SqlServerDataModelField logicallyField = sqlserverBaseDataModel.getDeleteFlag();
            controllerParams.put("logicallyFlag", logicallyField.getSourceFieldName());
            String logicallyFieldName = logicallyField.getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("getLogicallyFlag", String.valueOf(chars));
            controllerParams.put("deleteFlagName", logicallyField.getSourceFieldName());
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : "") + QueryType.getLabel((String)queryType));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : "") + QueryType.getLabel((String)queryType));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelectAndSort(SqlServerBackCtx<SqlServerTaskDataModel, SqlServerTaskDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation, String modelId, SqlServerTaskDataModel useDataModelBase, SqlServerTaskDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams, Boolean isPagination, boolean isSortOverall) throws LcdpException {
        SqlServerSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{sortConditionName}) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(SqlServerSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<SqlServerSortConditionField> sortConditionFields;
            List<SqlServerSortConditionField> fields = sortCondition.getFields();
            block0: for (SqlServerSortConditionField sqlServerSortConditionField : fields) {
                String fromModelFieldIdSort = sqlServerSortConditionField.getFromModelFieldIdSort();
                List<SqlServerDataModelField> fromModelFieldSort = useDataModelBase.getFields();
                for (SqlServerDataModelField sqlServerDataModelField : fromModelFieldSort) {
                    if (!sqlServerDataModelField.getId().equals(fromModelFieldIdSort)) continue;
                    sqlServerSortConditionField.setFromModelFieldSort(sqlServerDataModelField.getName());
                    continue block0;
                }
            }
            if (!isPagination.booleanValue()) {
                sortConditionFields = sortCondition.getFields();
                for (SqlServerSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            } else {
                sortConditionFields = sortCondition.getFields();
                for (SqlServerSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            if (Boolean.TRUE.equals(isPagination)) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        boolean isSelectCondition = false;
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        SqlServerQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            SqlServerDataModelFieldDto sqlServerDataModelFieldDto = (SqlServerDataModelFieldDto)controllerParams.get("securityLevel");
            SqlServerQueryConditionField field = new SqlServerQueryConditionField();
            field.setConnect("and");
            field.setFromModelField(sqlServerDataModelFieldDto.getId());
            field.setQueryAttrName(sqlServerDataModelFieldDto.getPropertyName());
            field.setFromModelId(useDataModelBase.getId());
            field.setType("row");
            field.setSymbol("<=");
            queryCondition.getFields().add(field);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SqlServerQueryConditionField queryConditionField : queryCondition.getFields()) {
            String fromModelField = queryConditionField.getFromModelField();
            List<SqlServerDataModelField> fields = useDataModelBase.getFields();
            boolean isStringType = true;
            for (SqlServerDataModelField field : fields) {
                if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                isStringType = false;
                break;
            }
            if (!isStringType) continue;
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            arrayList.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        controllerParams.put("likeQueryFields", arrayList);
        if (!Optional.ofNullable(queryCondition).map(SqlServerQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
        SqlServerDataModelField sqlserverDataModelField = useDataModelBase.getDeleteFlag();
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, sqlserverDataModelField.getName(), useDataModelBase.getId());
        }
        SqlServerQueryDTO queryDTO = SqlServerDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            SqlServerDataModelFieldDto fieldDto = (SqlServerDataModelFieldDto)controllerParams.get("securityLevel");
            SqlServerQueryFieldDTO field = new SqlServerQueryFieldDTO();
            field.setPropertyName(fieldDto.getPropertyName());
            field.setDbColumnType(fieldDto.getColumnType());
            field.setType(fieldDto.getType());
            field.setComment(fieldDto.getComment());
            queryDTO.getQueryFields().add(field);
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = QueryConditionUtil.renderTaskQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, useDataModelBase.getModelAliasName(), sqlserverDataModelField == null ? "" : sqlserverDataModelField.getSourceFieldName());
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        controllerParams.put("whereSql", finalWhereSql);
        isSelectCondition = true;
        controllerParams.put("isSelectCondition", SqlServerConstUtil.TRUE);
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return isSelectCondition;
    }

    private void renderPageVo(SqlServerBackCtx<SqlServerTaskDataModel, SqlServerTaskDataModelDTO> backCtx, String modelId, SqlServerBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        SqlServerDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + SqlServerDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private void renderTaskPageVo(SqlServerBackCtx<SqlServerTaskDataModel, SqlServerTaskDataModelDTO> backCtx, String modelId, SqlServerBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        SqlServerQueryDTO queryDTO = new SqlServerQueryDTO();
        queryDTO.setFtlPath("template/sqlserver/taskbackcode/code/taskPage.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + TASK_PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + TASK_PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + TASK_PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

