/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerEnclosure;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SqlServerFlowMsDataModel
extends SqlServerMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(SqlServerFlowMsDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW_MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<SqlServerDataModelField> flowFields;

    public List<SqlServerDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<SqlServerDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"SQL_SERVER.FLOW_MASTER_SLAVE", SqlServerFlowMsDataModel.class);
    }

    @Override
    public SqlServerFlowMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        SqlServerFlowMsDataModel sqlserverFlowMsDataModel;
        try {
            ArrayList<SqlServerDataModelField> fieldList = new ArrayList<SqlServerDataModelField>();
            sqlserverFlowMsDataModel = (SqlServerFlowMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), SqlServerFlowMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                SqlServerDataModelBase master = SqlServerDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(sqlserverFlowMsDataModel.getName() + "Master");
                sqlserverFlowMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<SqlServerDataModelBase> slaveTables = new ArrayList<SqlServerDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    SqlServerDataModelBase slaveTable = SqlServerDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (SqlServerRelationshipBase relationship : sqlserverFlowMsDataModel.getRelationships()) {
                    SqlServerDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(SqlServerBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    SqlServerDataModelField SqlServerDataModelField2 = new SqlServerDataModelField();
                    SqlServerDataModelField2.setId(UUID.randomUUID().toString());
                    SqlServerDataModelField2.setName(dataModelBase.getName());
                    SqlServerDataModelField2.setComment(dataModelBase.getComment());
                    SqlServerDataModelField2.setSourceDataModelId(dataModelBase.getId());
                    SqlServerDataModelField2.setDataType("array");
                    fieldList.add(SqlServerDataModelField2);
                }
                sqlserverFlowMsDataModel.setSlaveTables(slaveTables);
            }
            sqlserverFlowMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return sqlserverFlowMsDataModel;
    }

    @Override
    public SqlServerEnclosure<SqlServerDataModelBase> enclosure() throws LcdpException {
        return SqlServerModelBeanUtil.getEnclosureBean("SQL_SERVER", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public SqlServerRender<SqlServerDataModelBase, SqlServerDataModelBaseDTO> render() throws LcdpException {
        return SqlServerModelBeanUtil.getRenderBean("SQL_SERVER", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<SqlServerDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<SqlServerDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<SqlServerDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTable((FieldsContrastParam<SqlServerDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<SqlServerDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return super.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<SqlServerDataModelField> fieldsContrastParam) throws Exception {
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<SqlServerDataModelField> fieldsContrastParam) throws Exception {
        return super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

