/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.provider;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FormDesignStringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerModelFunction;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.service.SqlServerWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SqlServerModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"SQL_SERVER", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + FormDesignStringUtil.underlineToHump((String)dataModelBase.getName());
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            String tenantCodePrefix = Optional.ofNullable(AppContextUtil.getAppInfo()).map(e -> "/" + e.getTenantId()).orElse("");
            return FileUtil.posixPath((String[])new String[]{tenantCodePrefix, apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        SqlServerModelFunction modelFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        SqlServerDataModelBase lrDataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(SqlServerDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        SqlServerModelFunction modelFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        SqlServerDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (SqlServerDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId) throws LcdpException, IOException, CloneNotSupportedException {
        return new SqlServerWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        SqlServerModelFunction modelFunction = SqlServerModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        SqlServerDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> sqlserverDataModelFields = new ArrayList<DataModelFieldBase>();
        List<SqlServerDataModelField> fields = dataModelBase.getFields();
        if (ToolUtil.isNotEmpty(fields)) {
            sqlserverDataModelFields.addAll(fields);
        } else {
            List<SqlServerDataModelBase> slaveTables = null;
            SqlServerDataModelBase masterTable = new SqlServerBaseDataModel();
            if (modelFunction instanceof SqlServerFlowMsDataModel) {
                slaveTables = ((SqlServerFlowMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((SqlServerFlowMsDataModel)dataModelBase).getMasterTable();
            } else if (modelFunction instanceof SqlServerMsDataModel) {
                slaveTables = ((SqlServerMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((SqlServerFlowMsDataModel)dataModelBase).getMasterTable();
            }
            sqlserverDataModelFields.addAll(masterTable.getFields());
            if (ToolUtil.isNotEmpty(slaveTables)) {
                for (SqlServerDataModelBase slaveTable : slaveTables) {
                    sqlserverDataModelFields.addAll(slaveTable.getFields());
                }
            }
        }
        return sqlserverDataModelFields;
    }

    public void delete(String s) throws LcdpException {
    }
}

