/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.SqlServerMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerQueryDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryConditionField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortConditionField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.render.SqlServerBaseRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.constant.SqlServerConstUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERMASTER_SLAVETableQuery")
public class SqlServerMsTableQueryVisitor
implements SqlServerOperationVisitor<SqlServerMsDataModel, SqlServerMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerMsTableQueryVisitor.class);
    public static final String OPERATION_NAME = "SQL_SERVERMASTER_SLAVETableQuery";

    @Override
    public void visit(SqlServerBackCtx<SqlServerMsDataModel, SqlServerMsDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        SqlServerMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        SqlServerMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isSortOverall")));
        boolean isSortCondition = this.renderSort(backCtx, dataModelOperation, modelId, controllerParams, useDataModelBase, isSortOverall);
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/sqlserver/masterslavebackcode/query/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/sqlserver/masterslavebackcode/query/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/sqlserver/masterslavebackcode/query/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String finalReturn = SqlReturnUtil.renderReturn(useDataModelBase, useDataModelBase.getModelAliasName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/sqlserver/masterslavebackcode/query/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/sqlserver/masterslavebackcode/query/xml.ftl";
        String finalRelation = SqlReturnUtil.renderRelation(useDataModelBase, dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSelectCondition, isSortCondition, isSortOverall);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, SqlServerBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(SqlServerBackCtx<SqlServerMsDataModel, SqlServerMsDataModelDTO> backCtx, String modelId, SqlServerMsDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSelectCondition, boolean isSortCondition, boolean isSortOverall) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
        } else if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isSortCondition) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(SqlServerDataModelOperation dataModelOperation, SqlServerMsDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelect(SqlServerBackCtx<SqlServerMsDataModel, SqlServerMsDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation, String modelId, SqlServerMsDataModelDTO dataModelBaseDTO, Map<String, Object> templateParams) {
        SqlServerMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean logicallyDelete = useDataModelBase.isLogicallyDelete();
        SqlServerDataModelField deleteField = useDataModelBase.getDeleteFlag();
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        if (!StringUtil.isNotBlank((CharSequence)selectConditionName)) {
            if (logicallyDelete) {
                templateParams.put("addLogicallyCondition", true);
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + deleteField.getSourceFieldName();
                templateParams.put("logicallyFlag", logicallyFlag);
            }
            return false;
        }
        SqlServerQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
        ArrayList<String> likeQueryFields = new ArrayList<String>();
        for (SqlServerQueryConditionField queryConditionField : queryCondition.getFields()) {
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        templateParams.put("likeQueryFields", likeQueryFields);
        if (!Optional.ofNullable(queryCondition).map(SqlServerQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        templateParams.put("isSelectCondition", SqlServerConstUtil.TRUE);
        DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
        if (logicallyDelete) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, deleteField.getName(), useDataModelBase.getMasterTable().getId());
        }
        SqlServerQueryDTO queryDTO = SqlServerDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = "";
        finalWhereSql = logicallyDelete ? QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), SqlServerConstUtil.FALSE, ConnectEnum._AND.getType(), null, dataModelBaseDTO, backCtx.getUseDataModelBase().getModelAliasName(), useDataModelBase.getDeleteFlag().getSourceFieldName()) : QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), SqlServerConstUtil.FALSE, ConnectEnum._AND.getType(), null, dataModelBaseDTO, backCtx.getUseDataModelBase().getModelAliasName());
        if (useDataModelBase.isLogicallyDelete()) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        templateParams.put("whereSql", finalWhereSql);
        templateParams.put("QueryObj", queryDTO.getEntityName());
        templateParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private boolean renderSort(SqlServerBackCtx<SqlServerMsDataModel, SqlServerMsDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation, String modelId, Map<String, Object> controllerParams, SqlServerMsDataModel useDataModelBase, boolean isSortOverall) throws LcdpException {
        SqlServerSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(SqlServerSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            if (!isSortOverall) {
                List<SqlServerSortConditionField> sortConditionFields = sortCondition.getFields();
                for (SqlServerSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", SqlServerConstUtil.TRUE);
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            return true;
        }
        return false;
    }

    private void renderPageVo(SqlServerBackCtx<SqlServerMsDataModel, SqlServerMsDataModelDTO> backCtx, String modelId, SqlServerMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        SqlServerDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + SqlServerDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

