/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerEnclosure;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerPublicEnclosure;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERFLOWENCLOSURE")
public class SqlServerFlowEnclosure
implements SqlServerEnclosure<SqlServerFlowDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerFlowEnclosure.class);
    public static final String ENCLOSURE = "SQL_SERVERFLOWENCLOSURE";

    @Override
    public SqlServerDataModelBaseDTO enclosure(SqlServerFlowDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        List<SqlServerDataModelField> dataModelFieldBases;
        SqlServerFlowDataModelDTO dataModelBaseDTO = new SqlServerFlowDataModelDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        SqlServerPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isEmpty(dataModelFieldBases = dataModelBase.getFlowFields())) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new SqlServerFlowDataModelDTO();
        }
        ArrayList<SqlServerDataModelFieldDto> tableFields = new ArrayList<SqlServerDataModelFieldDto>();
        for (SqlServerDataModelField dataModelFieldBase : dataModelFieldBases) {
            SqlServerDataModelFieldDto tableField = new SqlServerDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        return dataModelBaseDTO;
    }
}

