<#include "../../../auditLog/ds.ftl">
@Override
${ds!}
public ApiResponse<String> ${name!}(${parameter} ${parameter?uncap_first}) {
    ${table.entityName} ${table.EName} = ${parameter?uncap_first}.getFormdata();
    try {
        <#if fillCode??>
            ${fillCode!}
        </#if>
        this.saveOrUpdate(${table.EName});
    } catch(Exception e) {
        logger.error(e.getMessage(), e);
        throw new HussarException(e.getMessage());
    }
    ((${table.serviceName})AopContext.currentProxy()).formsubmit(${parameter?uncap_first},String.valueOf(${table.EName}.get${primaryField!}()));
    return ApiResponse.success(String.valueOf(${table.EName}.get${primaryField!}()), "提交流程表单成功");
}

@Override
${ds!}
@HussarDs("${flowDatasourceName!}")
public void formsubmit(${parameter} ${parameter?uncap_first},String businessKey){
    if(HussarUtils.isEmpty(BaseSecurityUtil.getUser())){
        throw new HussarException("获取用户信息失败");
    }
    Map<String, String> appointMap = new HashMap<>();
    Map<String, Object> variable = new HashMap<>();
    String taskId = ${parameter?uncap_first}.getTaskId();
    String comment = ${parameter?uncap_first}.getComment();
    if (${parameter?uncap_first}.getFlowSelect() == null) {
        appointMap.put(BpmConstant.STATIC_APPOINT_ASSIGNEE, ${parameter?uncap_first}.getParticipantSelect());
    } else {
        appointMap.put(${parameter?uncap_first}.getFlowSelect(), ${parameter?uncap_first}.getParticipantSelect());
        variable.put(BpmConstant.BPM_NEXT_NODE, ${parameter?uncap_first}.getFlowSelect());
    }
    if (${parameter?uncap_first}.getSelectBranches() != null) {
    List<String> nextNodeIds = new ArrayList<>();
        for (Map<String, String> map : ${parameter?uncap_first}.getSelectBranches()) {
            appointMap.put(map.get("flowSelect"), map.get("participants"));
            nextNodeIds.add(map.get("flowSelect"));
        }
        variable.put(BpmConstant.BPM_NEXT_NODE, String.join(",", nextNodeIds));
    }

    // 判断是否设置会签
    if (${parameter?uncap_first}.getMultiType() != null){
        variable.put(BpmConstant.MULTI_TYPE, ${parameter?uncap_first}.getMultiType());
        variable.put(BpmConstant.MULTI_FINISH_CONDITION, ${parameter?uncap_first}.getMultiFinishCondition());
    }
    if (${parameter?uncap_first}.getNodeParticipantSelect() != null) {
        variable.put(BpmConstant.PUBLIC_APPOINT_ASSIGNEE, ${parameter?uncap_first}.getNodeParticipantSelect());
     }
     String processDefinitionKey = ${parameter?uncap_first}.getProcessDefinitionKey();
     String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
     if (HussarUtils.isEmpty(taskId)) {
        BpmResponseResult startResult = InstanceEngineService.startProcessInstanceByKey(processDefinitionKey, userId, businessKey, variable);
        if (BpmConstant.SUCCESS_CODE.equals(startResult.getCode())) {
            taskId = (String)startResult.getResult().getJSONObject(0).get("taskId");
        } else {
            logger.error(startResult.getMsg());
            throw new HussarException(startResult.getMsg());
        }
     }
     BpmResponseResult bpmResponseResult = TaskEngineService.completeTask(taskId, userId, appointMap, null, comment, variable);
     if (!BpmConstant.SUCCESS_CODE.equals(bpmResponseResult.getCode())) {
         logger.error(bpmResponseResult.getMsg());
         throw new HussarException(bpmResponseResult.getMsg());
     }
}
