<#include "../../../auditLog/ds.ftl">
@Override
${ds!}
public ApiResponse<String> ${name!}(String id){
    try{
        <#if logicallyDelete?? && logicallyDelete!>
            ${table.mapperEnName!}.${name!}(Collections.singletonList(id));
        <#else>
            this.removeByIds(Collections.singletonList(id));
        </#if>
        return ((${table.serviceName}) AopContext.currentProxy()).flagDeleteProcessInstance(id);
    } catch(Exception e){
        logger.error(e.getMessage(),e);
        throw new HussarException(e.getMessage());
    }

}

@Override
${ds!}
public ApiResponse<String> ${name!}UnStart(String id){
    // 验证流程状态
    BpmResponseResult validateResult;
    try {
        validateResult = ((${table.serviceName}) AopContext.currentProxy()).getFlagValidateResult(id);
        if (BpmConstant.SUCCESS_CODE.equals(validateResult.getCode())) {
            String state = validateResult.getResult().get(0) == null ? "" : validateResult.getResult().get(0).toString();
            switch (state) {
                //1 代表流程已经启动，并且节点处于第一节点，可以删除业务数据和流程数据
                case BpmConstant.SUCCESS_CODE:
                    //删除业务数据
                    <#if logicallyDelete?? && logicallyDelete!>
                        ${table.mapperEnName!}.${name!}(Collections.singletonList(id));
                    <#else>
                        this.removeByIds(Collections.singletonList(id));
                    </#if>
                    // 删除流程数据
                    return ((${table.serviceName}) AopContext.currentProxy()).flagDeleteProcessInstance(id);
                //2 代表流程已经启动，并且节点不处于第一节点，不可以删除业务数据和流程数据
                case "2":
                    <#--只有抛出异常才能阻止审计日志记录-->
                    <#--return ApiResponse.fail(validateResult.getMsg());-->
                    throw new HussarException(validateResult.getMsg());
                //0 代表流程没有启动，可以删除业务数据，不需要删除流程数据
                case BpmConstant.ERROR_CODE:
                    // 删除业务数据
                    <#if logicallyDelete?? && logicallyDelete!>
                        ${table.mapperEnName!}.${name!}(Collections.singletonList(id));
                    <#else>
                        this.removeByIds(Collections.singletonList(id));
                    </#if>
                    return ApiResponse.success("");
                default:
                    logger.error("删除失败！");
                    throw new HussarException("删除失败！");
            }
        }
        logger.error("删除失败！");
        throw new HussarException("删除失败！");
    } catch(Exception e) {
        logger.error(e.getMessage(),e);
        throw new HussarException(e.getMessage());
        }
}

@Override
${ds!}
@HussarDs("${flowDatasourceName!}")
public BpmResponseResult getFlagValidateResult(String id) {
    return InstanceEngineService.validateDeleteByBusinessKey(String.valueOf(id));
}

@Override
${ds!}
@HussarDs("${flowDatasourceName!}")
public ApiResponse<String> flagDeleteProcessInstance(String id) {
    BpmResponseResult bpmResponseResult;
    try {
        bpmResponseResult =  InstanceEngineService.deleteProcessInstanceByBusinessKey(id);
        if (BpmConstant.SUCCESS_CODE.equals(bpmResponseResult.getCode())){
            return ApiResponse.success("");
        }
        logger.error(bpmResponseResult.getMsg());
        throw new HussarException(bpmResponseResult.getMsg());
    } catch(Exception e){
        logger.error(e.getMessage(),e);
        throw new HussarException(e.getMessage());
    }

}