/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.util;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.JavaCodeFormatUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.MicroAppInfo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.sqlserver.code.SqlServerCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.result.SqlServerCodeResult;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class SqlServerCodeMergeUtil {
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static VersionManageService versionManageService = (VersionManageService)SpringContextUtil.getBean(VersionManageService.class);
    private static MicroAppInfoService microAppInfoService = (MicroAppInfoService)SpringContextUtil.getBean(MicroAppInfoService.class);
    private static ResourcePathService resourcePathService = (ResourcePathService)SpringContextUtil.getBean(ResourcePathService.class);
    private static FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
    private static CodeMergeService codeMergeService = (CodeMergeService)SpringContextUtil.getBean(CodeMergeService.class);
    private static final String CLIENT_TYPE = "publishIds";

    public static List<SqlServerCodeResult> mergeBack(List<SqlServerCodeGenerateInfo> codeGenerateInfos, SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> backCtx) throws IOException, LcdpException {
        ArrayList<SqlServerCodeResult> results = new ArrayList<SqlServerCodeResult>();
        if (ToolUtil.isNotEmpty(codeGenerateInfos)) {
            List<Object> publishIds = new ArrayList();
            if (null != Optional.ofNullable(backCtx.getParams()).orElseGet(HashMap::new).get(CLIENT_TYPE)) {
                publishIds = Arrays.asList(backCtx.getParams().get(CLIENT_TYPE).toString().split(","));
            }
            for (SqlServerCodeGenerateInfo codeGenerateInfo : codeGenerateInfos) {
                if ("js".equals(codeGenerateInfo.getFileType()) && ToolUtil.isNotEmpty(publishIds)) {
                    for (String string : publishIds) {
                        results.add(SqlServerCodeMergeUtil.mergeBackCode(codeGenerateInfo, string, backCtx));
                    }
                    continue;
                }
                results.add(SqlServerCodeMergeUtil.mergeBackCode(codeGenerateInfo, "", backCtx));
            }
        }
        return results;
    }

    private static SqlServerCodeResult mergeBackCode(SqlServerCodeGenerateInfo codeGenerateInfo, String publishId, SqlServerBackCtx<SqlServerDataModelBase, SqlServerDataModelBaseDTO> backCtx) throws IOException, LcdpException {
        BaseFile baseFile = HussarUtils.isNotEmpty((Object)backCtx.getBaseFile()) ? backCtx.getBaseFile() : new BaseFile();
        String absolutePath = resourcePathService.backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
        SqlServerCodeResult genCodeResult = new SqlServerCodeResult();
        genCodeResult.setResultType(ResultBeanEnum.SQL_SERVER_RESULT);
        SqlServerCodeMergeUtil.formatCode(codeGenerateInfo);
        if (!codeGenerateInfo.isCodeFormatSucceed()) {
            genCodeResult.setId(baseFile.getId());
            genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
            genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
            genCodeResult.setCodeFormatMessages(codeGenerateInfo.getCodeFormatMessages());
            genCodeResult.setCodeFormatMsg(codeGenerateInfo.getCodeFormatMsg());
            genCodeResult.setCodeFormatSucceed(codeGenerateInfo.isCodeFormatSucceed());
            return genCodeResult;
        }
        String mergeCode = "";
        String microAppId = "";
        if (baseFile instanceof PageInfo) {
            PageInfo pageInfo = (PageInfo)baseFile;
            if (ToolUtil.isNotEmpty((Object)pageInfo) && ToolUtil.isNotEmpty((Object)pageInfo.getMicroApp())) {
                microAppId = pageInfo.getMicroApp();
            }
        } else {
            baseFile.setId(backCtx.getUseDataModelBase().getId());
        }
        if (ToolUtil.isNotEmpty((Object)publishId) && !"WebPage".equals(publishId)) {
            microAppId = publishId;
        }
        String dataId = SqlServerCodeMergeUtil.getVersionFileKey(codeGenerateInfo);
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            String writeFile;
            Optional<String> currentCode;
            if ("js".equals(codeGenerateInfo.getFileType())) {
                String jsPath = SqlServerCodeMergeUtil.isWebPublish(baseFile, publishId) ? resourcePathService.webProjectApi(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath() : resourcePathService.mobileProjectApi(formDesignProperties.getMobProjectPath(), new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(jsPath));
            } else {
                String currentPath = resourcePathService.backProjectJava(new String[]{AppContextUtil.getAppBackCodePrefix(), codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(currentPath));
            }
            Optional<String> versionCode = Optional.ofNullable(versionManageService.getAncestorCodeById(dataId));
            String lastFileCode = versionManageService.getLastFileCode(dataId);
            if (currentCode.isPresent() && versionCode.isPresent()) {
                MergeResult mergeResult;
                SqlServerDataModelBase jsInfo = backCtx.getUseDataModelBase();
                String pageName = jsInfo.getName();
                FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
                String moduleRelatePath = fileMappingService.getFormatParentPath(jsInfo.getId());
                String jsPath = resourcePathService.webProjectApi(new String[]{moduleRelatePath, pageName + formDesignProperties.getJsSuffix()}).getLocalPath();
                String currentFile = currentCode.get();
                String lastPublish = versionCode.get();
                if (codeGenerateInfo.getFileType().equals("xml")) {
                    currentFile = CodeSplitUtil.setEndOnlyLine((String)currentFile);
                    lastPublish = CodeSplitUtil.setEndOnlyLine((String)lastPublish);
                }
                if ((mergeResult = codeMergeService.structuralMerge(jsPath, ExtractFileType.JS, lastPublish, currentFile, codeGenerateInfo.getFileContent(), lastFileCode, false)).isConflict()) {
                    genCodeResult.setExistConflict(true);
                    genCodeResult.setMergeCode(mergeResult.getMergedCode());
                    genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                    genCodeResult.setOriginCode(currentCode.get());
                    genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
                    genCodeResult.setLastPublish(mergeResult.getLastPublish());
                    genCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                    genCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                    genCodeResult.setMergeInfo(mergeResult.getMergeInfo());
                } else {
                    mergeCode = mergeResult.getMergedCode();
                }
                switch (codeGenerateInfo.getFileType()) {
                    case "controller": 
                    case "entity": 
                    case "service": 
                    case "serviceImpl": {
                        genCodeResult.setType("java");
                        break;
                    }
                    case "mapper": 
                    case "xml": {
                        genCodeResult.setType("xml");
                        break;
                    }
                    case "js": {
                        genCodeResult.setType("javascript");
                        break;
                    }
                }
            }
            String string = writeFile = ToolUtil.isEmpty((Object)mergeCode) ? codeGenerateInfo.getFileContent() : mergeCode;
            if (!genCodeResult.isExistConflict()) {
                absolutePath = SqlServerCodeMergeUtil.writeNoConflictCode(codeGenerateInfo, baseFile, publishId, absolutePath, microAppId, dataId, writeFile);
            } else if ("js".equals(codeGenerateInfo.getFileType())) {
                if (SqlServerCodeMergeUtil.isWebPublish(baseFile, publishId)) {
                    absolutePath = resourcePathService.webProjectApi(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                } else if (ToolUtil.isNotEmpty((Object)((Object)codeGenerateInfo)) && HussarUtils.equals((Object)"MobilePage", (Object)codeGenerateInfo.getPageType())) {
                    MicroAppInfo microAppInfo = (MicroAppInfo)microAppInfoService.get(baseFile.getId());
                    microAppInfo.setProjectPath(formDesignProperties.getMobProjectPath());
                    if (ToolUtil.isNotEmpty((Object)microAppInfo)) {
                        absolutePath = resourcePathService.mobileProjectApi(microAppInfo.getProjectPath(), new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                    }
                }
            } else {
                absolutePath = resourcePathService.backProjectJava(new String[]{AppContextUtil.getAppBackCodePrefix(), codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
            }
        }
        genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
        genCodeResult.setDataId(dataId);
        genCodeResult.setId(baseFile.getId());
        return genCodeResult;
    }

    private static void formatCode(SqlServerCodeGenerateInfo codeGenerateInfo) {
        String fileType = codeGenerateInfo.getFileType();
        if (ToolUtil.isNotEmpty((Object)fileType) && ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            if (fileType.equals("controller") || fileType.equals("entity") || fileType.equals("mapper") || fileType.equals("service") || fileType.equals("serviceImpl") || fileType.equals("queryEntity") || fileType.equals("vo")) {
                codeGenerateInfo.setFileContent(JavaCodeFormatUtil.format((String)codeGenerateInfo.getFileContent()));
            }
            if (fileType.equals("js")) {
                CodeFormatResult codeFormatResult = CodeFormatter.formatterHtml((String)codeGenerateInfo.getFileContent(), (String)"typescript");
                codeGenerateInfo.setFileContent(codeFormatResult.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult.isSucceed());
                codeGenerateInfo.setCodeFormatMsg(codeFormatResult.getMsg());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult.getMessages());
            }
            if (fileType.equals("xml")) {
                codeGenerateInfo.setFileContent(CodeSplitUtil.setEndOnlyLine((String)codeGenerateInfo.getFileContent()));
            }
        }
    }

    public static String writeNoConflictCode(SqlServerCodeGenerateInfo codeGenerateInfo, BaseFile baseFile, String publishId, String absolutePath, String microAppId, String dataId, String writeFile) throws LcdpException, IOException {
        if ("js".equals(codeGenerateInfo.getFileType())) {
            if (SqlServerCodeMergeUtil.isWebPublish(baseFile, publishId)) {
                absolutePath = filePublishService.writeWebApiCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), baseFile.getId());
            } else if (HussarUtils.isNotEmpty((Object)((Object)codeGenerateInfo)) && HussarUtils.equals((Object)"MobilePage", (Object)codeGenerateInfo.getPageType())) {
                MicroAppInfo microAppInfo = (MicroAppInfo)microAppInfoService.get(baseFile.getId());
                microAppInfo.setProjectPath(formDesignProperties.getMobProjectPath());
                if (ToolUtil.isNotEmpty((Object)microAppInfo)) {
                    String apiPath = resourcePathService.mobileProjectApi(microAppInfo.getProjectPath(), new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                    absolutePath = filePublishService.writeIonicApiCode(writeFile, apiPath, baseFile.getId());
                }
            }
        } else {
            absolutePath = filePublishService.writeMVCCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), baseFile.getId());
        }
        versionManageService.saveCacheLastPublishCode(dataId, codeGenerateInfo.getFileContent(), baseFile.getId());
        versionManageService.saveCacheLastFileCode(dataId, writeFile, baseFile.getId());
        return absolutePath;
    }

    private static boolean isWebPublish(BaseFile baseFile, String publishId) {
        String baseFileType = Optional.ofNullable(baseFile).map(BaseFile::getType).orElse("");
        return baseFile == null || baseFile != null && "WebPage".equals(baseFile.getType()) || "Workflow".equals(baseFileType) || "WebPage".equals(publishId);
    }

    private static String getVersionFileKey(SqlServerCodeGenerateInfo codeGenerateInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(codeGenerateInfo.getFileId());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getPageType()) && !"WebPage".equals(codeGenerateInfo.getPageType()) && !"MobilePage".equals(codeGenerateInfo.getPageType())) {
            stringBuilder.append(codeGenerateInfo.getPageType());
        }
        stringBuilder.append(codeGenerateInfo.getFileType());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileName())) {
            stringBuilder.append(codeGenerateInfo.getFileName());
        }
        return stringBuilder.toString();
    }
}

