/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.render.SqlServerBaseRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.flow.baseflow.util.SqlServerFlowBaseUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERFLOWInitialNodeReject")
public class SqlServerInitialNodeRejectCodeVisitor
implements SqlServerOperationVisitor<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerInitialNodeRejectCodeVisitor.class);
    public static final String OPERATION_NAME = "SQL_SERVERFLOWInitialNodeReject";

    @Override
    public void visit(SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> backCtx, SqlServerDataModelOperation operation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        SqlServerFlowDataModelDTO dataModelBaseDto = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(operation, dataModelBaseDto);
        String controllerPath = "template/sqlserver/flowbackcode/baseflowbackcode/initialnodereject/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        this.renderImpl(backCtx, modelId, dataModelBaseDto);
        backCtx.addControllerInversion(modelId, dataModelBaseDto.getServiceName());
        String servicePath = "template/sqlserver/flowbackcode/baseflowbackcode/initialnodereject/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String fillCode = SqlServerFlowBaseUtil.renderFillCode(dataModelBaseDto);
        if (fillCode != null) {
            controllerParams.put("fillCode", fillCode);
        }
        String implPath = "template/sqlserver/flowbackcode/baseflowbackcode/initialnodereject/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, controllerParams));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", dataModelBaseDto.getApiPrefix() + "/" + operation.getName(), "\u9a73\u56de\u5230\u521d\u59cb\u8282\u70b9", null);
        backCtx.addApi(modelId, SqlServerBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private Map<String, Object> initParams(SqlServerDataModelOperation operation, SqlServerFlowDataModelDTO dataModelBaseDto) {
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("flowDatasourceName", SqlServerDataSourceUtil.getDefaultDataSourceName());
        controllerParams.put("table", dataModelBaseDto);
        controllerParams.put("parameter", dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getEntityName());
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(dataModelBaseDto.getComment() + "\u9a73\u56de\u81f3\u521d\u59cb\u8282\u70b9");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        return controllerParams;
    }

    private void renderImpl(SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> backCtx, String modelId, SqlServerFlowDataModelDTO dataModelBaseDto) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, dataModelBaseDto.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDto.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
    }
}

