/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerOperationVisitor;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.flow.SqlServerFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerQueryDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.operation.SqlServerDataModelOperation;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryConditionField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortConditionField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.render.SqlServerBaseRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.visitor.constant.SqlServerConstUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERFLOWTableQuery")
public class SqlServerFlowTableQueryVisitor
implements SqlServerOperationVisitor<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerFlowTableQueryVisitor.class);
    public static final String OPERATION_NAME = "SQL_SERVERFLOWTableQuery";

    @Override
    public void visit(SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        SqlServerFlowDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = useDataModelBase.getLogicallyDelete();
        SqlServerFlowDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, useDataModelDTO, isLogicallyDelete);
        Boolean isPagination = Boolean.valueOf(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isSortOverall")));
        controllerParams.put("isSortOverall", isSortOverall);
        if (isLogicallyDelete) {
            controllerParams.put("deleteFlag", useDataModelDTO.getFieldCapitalName(useDataModelBase.getDeleteFlag().getName()));
            controllerParams.put("deleteFlagName", useDataModelBase.getDeleteFlag().getSourceFieldName());
        }
        boolean isSelectCondition = this.renderSelectAndSort(backCtx, dataModelOperation, modelId, useDataModelBase, useDataModelDTO, controllerParams, isPagination, isSortOverall);
        this.renderPageVo(backCtx, modelId, useDataModelDTO, controllerParams);
        String controllerPath = "template/sqlserver/backcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/sqlserver/backcode/tableQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/sqlserver/backcode/tableQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        if (isSelectCondition) {
            backCtx.addServiceImplInversion(modelId, useDataModelDTO.getMapperName());
            String mapperPath = "template/sqlserver/backcode/tableQuery/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String xmlPath = "template/sqlserver/backcode/tableQuery/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        this.renderImport(backCtx, modelId, useDataModelDTO, isSelectCondition, isPagination, isLogicallyDelete, isSortOverall);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, SqlServerBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> backCtx, String modelId, SqlServerBaseDataModelDTO dataModelBaseDTO, boolean isSelectCondition, boolean isPagination, boolean isLogicallyDelete, boolean isSortOverall) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            if (isPagination) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            } else {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            }
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isLogicallyDelete) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(SqlServerDataModelOperation dataModelOperation, SqlServerFlowDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelectAndSort(SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> backCtx, SqlServerDataModelOperation dataModelOperation, String modelId, SqlServerFlowDataModel useDataModelBase, SqlServerFlowDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams, Boolean isPagination, boolean isSortOverall) throws LcdpException {
        SqlServerSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{sortConditionName}) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(SqlServerSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            if (!isSortOverall) {
                List<SqlServerSortConditionField> sortConditionFields = sortCondition.getFields();
                for (SqlServerSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            if (isPagination.booleanValue()) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        boolean isSelectCondition = false;
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        SqlServerQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
        ArrayList<String> likeQueryFields = new ArrayList<String>();
        for (SqlServerQueryConditionField queryConditionField : queryCondition.getFields()) {
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        controllerParams.put("likeQueryFields", likeQueryFields);
        if (!Optional.ofNullable(queryCondition).map(SqlServerQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, useDataModelBase.getDeleteFlag().getName(), useDataModelBase.getId());
        }
        SqlServerQueryDTO queryDTO = SqlServerDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = "";
        finalWhereSql = useDataModelBase.getLogicallyDelete() ? QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>(), useDataModelBase.getDeleteFlag().getSourceFieldName()) : QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>());
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        controllerParams.put("whereSql", finalWhereSql);
        isSelectCondition = true;
        controllerParams.put("isSelectCondition", SqlServerConstUtil.TRUE);
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return isSelectCondition;
    }

    private void renderPageVo(SqlServerBackCtx<SqlServerFlowDataModel, SqlServerFlowDataModelDTO> backCtx, String modelId, SqlServerBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        SqlServerDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + SqlServerDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

