/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerEnclosure;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.base.SqlServerBaseDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.masterslave.relationship.SqlServerRelationshipBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBase;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.field.SqlServerDataModelField;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.querycondition.SqlServerQueryObject;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.sortcondition.SqlServerSortCondition;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerDataModelUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SqlServerMsDataModel
extends SqlServerDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(SqlServerMsDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<SqlServerQueryCondition> queryConditions;
    private List<SqlServerQueryObject> queryObject;
    private SqlServerDataModelBase masterTable;
    private List<SqlServerDataModelBase> slaveTables;
    private List<SqlServerRelationshipBase> relationships;
    private boolean logicallyDelete;
    private List<SqlServerSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"SQL_SERVER.MASTER_SLAVE", SqlServerMsDataModel.class);
    }

    @Override
    public SqlServerMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        SqlServerMsDataModel sqlserverMsDataModel;
        try {
            ArrayList<SqlServerDataModelField> fieldList = new ArrayList<SqlServerDataModelField>();
            sqlserverMsDataModel = (SqlServerMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), SqlServerMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                SqlServerDataModelBase master = SqlServerDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(sqlserverMsDataModel.getName() + "Master");
                sqlserverMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<SqlServerDataModelBase> slaveTables = new ArrayList<SqlServerDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    SqlServerDataModelBase slaveTable = SqlServerDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (SqlServerRelationshipBase relationship : sqlserverMsDataModel.getRelationships()) {
                    SqlServerDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(SqlServerBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    SqlServerDataModelField SqlServerDataModelField2 = new SqlServerDataModelField();
                    SqlServerDataModelField2.setId(UUID.randomUUID().toString());
                    SqlServerDataModelField2.setName(dataModelBase.getName());
                    SqlServerDataModelField2.setComment(dataModelBase.getComment());
                    SqlServerDataModelField2.setSourceDataModelId(dataModelBase.getId());
                    SqlServerDataModelField2.setDataType("array");
                    fieldList.add(SqlServerDataModelField2);
                }
                sqlserverMsDataModel.setSlaveTables(slaveTables);
            }
            sqlserverMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return sqlserverMsDataModel;
    }

    @Override
    public SqlServerEnclosure<SqlServerDataModelBase> enclosure() throws LcdpException {
        return SqlServerModelBeanUtil.getEnclosureBean("SQL_SERVER", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public SqlServerRender<SqlServerDataModelBase, SqlServerDataModelBaseDTO> render() throws LcdpException {
        return SqlServerModelBeanUtil.getRenderBean("SQL_SERVER", FUNCTION_TYPE, "RENDER");
    }

    public SqlServerDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(SqlServerDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<SqlServerDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<SqlServerDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<SqlServerRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<SqlServerRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<SqlServerQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<SqlServerQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<SqlServerQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<SqlServerQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<SqlServerSortCondition> getSortCondition() {
        return this.sortCondition;
    }

    public void setSortCondition(List<SqlServerSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public boolean isLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public SqlServerQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (SqlServerQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public SqlServerSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (SqlServerSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return "";
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.masterTable.getId(), "T2");
        if (ToolUtil.isNotEmpty(this.relationships) && !this.relationships.isEmpty()) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                SqlServerRelationshipBase relationship = this.relationships.get(i);
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        return finalMap;
    }

    public DataSet getDataSetById(String dataSetId) {
        if (this.getDataSets() != null) {
            for (DataSet dataSet : this.getDataSets()) {
                if (!dataSet.getId().equals(dataSetId)) continue;
                return dataSet;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<SqlServerDataModelField>> findTableContrast() throws IOException, LcdpException {
        List<ContrastVO<SqlServerDataModelField>> tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<SqlServerDataModelField>> tableContrastModel(FieldsContrastParam<SqlServerDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<SqlServerDataModelField>> tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<SqlServerDataModelField>> modelContrastTable(FieldsContrastParam<SqlServerDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<SqlServerDataModelField>> tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.masterTable.checkTableContrast(modelId).getDetails().get(0));
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            details.add(this.slaveTables.get(i).checkTableContrast(modelId).getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<SqlServerDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            this.slaveTables.get(i).updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<SqlServerDataModelField> fieldsContrastParam) throws Exception {
        String sql = this.masterTable.copyTableByModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            sql = sql + this.slaveTables.get(i).copyTableByModel(fieldsContrastParam);
        }
        return sql;
    }

    public SqlServerDataModelField getDeleteFlag() {
        return this.getMasterTable().getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public SqlServerDataModelField getPrimaryKey() {
        return this.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }
}

