@Override
<#--有查询条件-->
<#if isSelectCondition?? && isSelectCondition!>
    public ApiResponse<${vo!}> ${name!}(${QueryObj!} ${queryObj!}){
    try {
    ${vo!} ${vo?uncap_first} = new ${vo!}();
    <#if isPagination?? && isPagination!>
        Page<${returnValue}> pager = new Page<>(${queryObj!}.getCurrent(), ${queryObj!}.getSize());
    <#--        全局排序-->
        <#if isSortOverall?? && isSortOverall!>
            Map<String, String[]> parameterMap = new HashMap<>();
            String[] orderParameter = new String[1];
            if (${queryObj!}.getOrders() != null) {
                for (OrderItem orderItem : ${queryObj!}.getOrders()) {
                    if (orderItem.isAsc()) {
                        orderParameter[0] = orderItem.getColumn() + ",asc;";
                    }else {
                        orderParameter[0] = orderItem.getColumn() + ",desc;";
                    }
                }
            }
            parameterMap.put("orderRule",orderParameter);
        </#if>
    <#--    排序条件，分页排序条件加载page对象中,sortConditionObj排序对象-->
        <#if sortConditionObj??>
            <#if isSortOverall?? && isSortOverall!>
                String[] defaultOrderParameter = new String[1];
                String defaultOrder = "";
                <#assign sortFields = sortConditionObj.fields!>
                <#list sortFields as f>
                <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                    defaultOrder += "${f.fromModelFieldSort!}" + ",<#if f.sortCondition == "asc">asc<#else>desc</#if>;";
                </#list>
                defaultOrderParameter[0] = defaultOrder;
                parameterMap.put("defaultOrderRule",defaultOrderParameter);
            <#else>
                <#assign sortFields = sortConditionObj.fields!>
                <#list sortFields as f>
                <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                    pager.addOrder(new OrderItem("${f.fromModelFieldSort!}", <#if f.sortCondition == "asc">true<#else>false</#if>));
                </#list>
            </#if>
        </#if>
    <#--        新建一个vo-->
        <#if likeQueryFields??>
            <#list likeQueryFields! as queryField >
                ${queryObj!}.set${queryField}(${queryObj!}.get${queryField}()
                .replaceAll("/", "//").replaceAll("%", "/%")
                .replaceAll("_","/_").replaceAll("\\[","/[").replaceAll("]","/]"));
            </#list>
        </#if>
        <#if isSortOverall?? && isSortOverall!>
        // 查询条件构造器,将排序条件封装成QueryWrapper
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper<${returnValue}> queryWrapper = singleTableQueryGenerator.initQueryWrapper(new ${returnValue}(), parameterMap);
        </#if>
        List<${returnValue}> list = ${table.mapperEnName!}.${name!}(pager, ${queryObj!}<#if isSortOverall?? && isSortOverall!>, queryWrapper</#if>);
        ${vo?uncap_first}.setData(list);
        ${vo?uncap_first}.setCount(pager.getTotal());
    <#else>
    <#--    是否有排序条件 如果有增加一个排序条件的QueryWrapper-->
        <#if sortConditionObj??>
            <#assign sortFields = sortConditionObj.fields!>
            List<${returnValue}> list = ${table.mapperEnName!}.${name!}(${queryObj!}, new QueryWrapper<${returnValue}>()
            <#list sortFields as f>
                <#if f.sortCondition == "asc">
                    .orderByAsc("${f.fromModelFieldSort!}")
                <#else>
                    .orderByDesc("${f.fromModelFieldSort!}")
                </#if>
            </#list>
            );
        <#else>
            <#if likeQueryFields??>
                <#list likeQueryFields! as queryField >
                    ${queryObj!}.set${queryField}(${queryObj!}.get${queryField}()
                    .replaceAll("/", "//").replaceAll("%", "/%")
                    .replaceAll("_","/_").replaceAll("\\[","/[").replaceAll("]","/]"));
                </#list>
            </#if>
            List<${returnValue}> list = ${table.mapperEnName!}.${name!}(${queryObj!});
        </#if>
        ${vo?uncap_first}.setData(list);
    <#--        无分页count存当前list长度-->
        if(HussarUtils.isNotEmpty(list)){
        ${vo?uncap_first}.setCount((long) list.size());
        }
    </#if>
<#else>
<#--    无查询条件-->
    <#if isPagination?? && isPagination!>
        public ApiResponse<${vo!}> ${name!}(Page<${returnValue}> page){
        try {
        Page<${returnValue}> pager = new Page<>(page.getCurrent(), page.getSize());
    <#--        全局排序-->
        <#if isSortOverall?? && isSortOverall!>
            Map<String, String[]> parameterMap = new HashMap<>();
            String[] orderParameter = new String[1];
            if (page.orders() != null) {
                for (OrderItem orderItem : page.orders()) {
                    if (orderItem.isAsc()) {
                        orderParameter[0] = orderItem.getColumn() + ",asc;";
                    }else {
                        orderParameter[0] = orderItem.getColumn() + ",desc;";
                    }
                }
            }
            parameterMap.put("orderRule",orderParameter);
        </#if>
    <#--    排序条件，分页排序条件加载page对象中,sortConditionObj排序对象-->
        <#if sortConditionObj??>
            <#if isSortOverall?? && isSortOverall!>
                String[] defaultOrderParameter = new String[1];
                String defaultOrder = "";
                <#assign sortFields = sortConditionObj.fields!>
                <#list sortFields as f>
                <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                    defaultOrder += "${f.fromModelFieldSort!}" + ",<#if f.sortCondition == "asc">asc<#else>desc</#if>;";
                </#list>
                defaultOrderParameter[0] = defaultOrder;
                parameterMap.put("defaultOrderRule",defaultOrderParameter);
            <#else>
                <#assign sortFields = sortConditionObj.fields!>
                <#list sortFields as f>
                <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                    pager.addOrder(new OrderItem("${f.fromModelFieldSort!}", <#if f.sortCondition == "asc">true<#else>false</#if>));
                </#list>
            </#if>
        </#if>
        ${vo!} ${vo?uncap_first} = new ${vo!}();
        <#if isSortOverall?? && isSortOverall!>
        // 查询条件构造器,将排序条件封装成QueryWrapper
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper<${returnValue}> queryWrapper = singleTableQueryGenerator.initQueryWrapper(new ${returnValue}(), parameterMap);
        </#if>
        <#if logicallyDelete?? && logicallyDelete!>
            <#if isSortOverall?? && isSortOverall!>
                List<${returnValue}> list = this.page(pager,queryWrapper.lambda().and(wrapper -> wrapper.ne(${returnValue}::get${deleteFlag!}, "1").or().isNull(${returnValue}::get${deleteFlag!}))).getRecords();
            <#else>
                List<${returnValue}> list = this.page(pager,new QueryWrapper<${returnValue}>().lambda().ne(${returnValue}::get${deleteFlag!}, "1").or().isNull(${returnValue}::get${deleteFlag!})).getRecords();
            </#if>
        <#else>
            List<${returnValue}> list = this.page(pager<#if isSortOverall?? && isSortOverall!>, queryWrapper</#if>).getRecords();
        </#if>
        ${vo?uncap_first}.setData(list);
        ${vo?uncap_first}.setCount(pager.getTotal());
    <#else>
        public ApiResponse<${vo!}> ${name!}(){
        try {
        ${vo!} ${vo?uncap_first} = new ${vo!}();
    <#--    是否有排序条件 如果有增加一个排序条件的QueryWrapper-->
        <#if sortConditionObj??>
            <#assign sortFields = sortConditionObj.fields!>
            List<${returnValue}> list = this.list(new QueryWrapper<${returnValue}>()
            <#list sortFields as f>
                <#if f.sortCondition == "asc">
                    <#if logicallyDelete?? && logicallyDelete!>
                        .ne("${deleteFlagName}","1").or().isNull("${deleteFlagName}"})
                    </#if>
                    .orderByAsc("${f.fromModelFieldSort!}")
                <#else>
                    <#if logicallyDelete?? && logicallyDelete!>
                        .ne("${deleteFlagName}","1").or().isNull("${deleteFlagName}"})
                    </#if>
                    .orderByDesc("${f.fromModelFieldSort!}")
                </#if>
            </#list>
            );
        <#else>
            <#if logicallyDelete?? && logicallyDelete!>
                List<${returnValue}> list = this.list(new QueryWrapper<${returnValue}>().lambda().ne(${returnValue}::get${deleteFlag!}, "1").or().isNull(${returnValue}::get${deleteFlag!}));
            <#else>
                List<${returnValue}> list = this.list();
            </#if>
        </#if>
        ${vo?uncap_first}.setData(list);
        if(HussarUtils.isNotEmpty(list)){
        ${vo?uncap_first}.setCount((long) list.size());
        }
    </#if>
</#if>
<#--共有部分-->
${vo?uncap_first}.setCode(RETURN_CODE);
return ApiResponse.success(${vo?uncap_first});
} catch (Exception e) {
    logger.error(e.getMessage(), e);
    throw new HussarException("表格查询失败");
    }
}
