/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.sqlserver.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.sqlserver.code.SqlServerCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.AspectGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.EntityGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.sqlserver.ctx.SqlServerBackCtx;
import com.jxdinfo.hussar.formdesign.sqlserver.function.SqlServerRender;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.view.SqlServerViewDataModel;
import com.jxdinfo.hussar.formdesign.sqlserver.function.element.view.SqlServerViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.function.modelentity.SqlServerQueryDTO;
import com.jxdinfo.hussar.formdesign.sqlserver.util.SqlServerBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SQL_SERVERVIEWRENDER")
public class SqlServerViewRender
implements SqlServerRender<SqlServerViewDataModel, SqlServerViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerViewRender.class);
    public static final String RENDER = "SQL_SERVERVIEWRENDER";

    @Override
    public List<SqlServerCodeGenerateInfo> renderCode(SqlServerBackCtx<SqlServerViewDataModel, SqlServerViewDataModelDTO> backCtx) throws LcdpException, IOException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<SqlServerCodeGenerateInfo> sqlServerCodeGenerateInfos = new ArrayList<SqlServerCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        SqlServerViewDataModelDTO dataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        sqlServerCodeGenerateInfos.add(this.genEntityCode(dataModelViewDTO));
        sqlServerCodeGenerateInfos.add(this.genVoCode(dataModelViewDTO));
        sqlServerCodeGenerateInfos.add(this.genControllerCode(dataModelViewDTO));
        sqlServerCodeGenerateInfos.add(this.genServiceCode(dataModelViewDTO));
        sqlServerCodeGenerateInfos.add(this.genServiceImplCode(dataModelViewDTO));
        sqlServerCodeGenerateInfos.add(this.genMapperCode(dataModelViewDTO));
        sqlServerCodeGenerateInfos.add(this.genXmlCode(dataModelViewDTO));
        sqlServerCodeGenerateInfos.add(this.genApiCode(dataModelViewDTO, baseFile));
        Map<String, SqlServerQueryDTO> queryDtoMap = dataModelViewDTO.getQueryDtoMap();
        if (ToolUtil.isNotEmpty(queryDtoMap)) {
            for (Map.Entry<String, SqlServerQueryDTO> queryDTOEntry : queryDtoMap.entrySet()) {
                SqlServerQueryDTO queryDTO = queryDTOEntry.getValue();
                SqlServerCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, dataModelViewDTO);
                if (null == queryCodeGenerateInfo) continue;
                sqlServerCodeGenerateInfos.add(queryCodeGenerateInfo);
            }
        }
        Map<String, AspectGenerateInfo> aspectGenerateInfoMap = dataModelViewDTO.getAspectGenerateInfoMap();
        if (ToolUtil.isNotEmpty(dataModelViewDTO.getAnnotationNames()) && ToolUtil.isNotEmpty(aspectGenerateInfoMap)) {
            for (String annotationName : dataModelViewDTO.getAnnotationNames()) {
                sqlServerCodeGenerateInfos.add(this.genAnnotationCode(dataModelViewDTO, annotationName));
                AspectGenerateInfo aspectGenerateInfo = Optional.ofNullable(aspectGenerateInfoMap.get(aspectGenerateInfoMap.keySet().stream().filter(key -> key.equals(annotationName)).findFirst().orElse(""))).orElseGet(AspectGenerateInfo::new);
                sqlServerCodeGenerateInfos.add(this.genAspectCode(dataModelViewDTO, annotationName, aspectGenerateInfo));
            }
        }
        return sqlServerCodeGenerateInfos;
    }

    private SqlServerCodeGenerateInfo genEntityCode(SqlServerViewDataModelDTO dataModelViewDTO) throws LcdpException {
        String modulePath = dataModelViewDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "model" + File.separator + dataModelViewDTO.getEntityName() + ".java";
        String filePath = "template/sqlserver/backcode/code/entity.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelViewDTO.getEntityName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelViewDTO.getEntityGenerateInfo())) {
            EntityGenerateInfo entityGenerateInfo = new EntityGenerateInfo();
            entityGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelViewDTO.setEntityGenerateInfo(entityGenerateInfo);
        } else {
            dataModelViewDTO.getEntityGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = SqlServerBackRenderUtil.renderTemplate(filePath, dataModelViewDTO);
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("entity");
        codeGenerateInfo.setFileId(dataModelViewDTO.getId());
        codeGenerateInfo.setFileName(dataModelViewDTO.getEntityName() + ".java");
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo genVoCode(SqlServerViewDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dataModelBaseDTO.getVoName() + ".java";
        String filePath = "template/sqlserver/backcode/code/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setVoGeneratorInfo(info);
        } else {
            dataModelBaseDTO.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = SqlServerBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("queryEntity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo genControllerCode(SqlServerViewDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String filePath = "template/sqlserver/backcode/code/controller.ftl";
        String newCode = SqlServerBackRenderUtil.renderTemplate(filePath, dataModelDto);
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo genServiceCode(SqlServerViewDataModelDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "template/sqlserver/backcode/code/service.ftl";
        String newCode = SqlServerBackRenderUtil.renderTemplate(filePath, dataModelDto);
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo genServiceImplCode(SqlServerViewDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "template/sqlserver/backcode/code/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = SqlServerBackRenderUtil.renderTemplate(filePath, dataModelDto);
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo genMapperCode(SqlServerViewDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "template/sqlserver/backcode/code/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = SqlServerBackRenderUtil.renderTemplate(filePath, dataModelDto);
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo genXmlCode(SqlServerViewDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "template/sqlserver/backcode/code/xml.ftl";
        String newCode = SqlServerBackRenderUtil.renderTemplate(filePath, dataModelDto);
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo dynamicModelCode(SqlServerQueryDTO queryDTO, SqlServerDataModelBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private SqlServerCodeGenerateInfo genAnnotationCode(SqlServerViewDataModelDTO dataModelDto, String annotationName) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "annotation" + File.separator + annotationName + ".java";
        String filePath = "template/sqlserver/backcode/code/annotation.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("annotation");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(annotationName);
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo genApiCode(SqlServerViewDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = HussarUtils.isNotEmpty((Object)baseFile) && HussarUtils.equals((Object)"MobilePage", (Object)baseFile.getType()) ? "template/preview/api/api-mobile-file.ftl" : "template/preview/api/api-file.ftl";
        String newCode = SqlServerBackRenderUtil.renderTemplate(filePath, dataModelDto);
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo genPreviewApiCode(SqlServerViewDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/sqlserver/preview/api/api-file.ftl";
        String newCode = SqlServerBackRenderUtil.renderTemplate(filePath, dataModelDto);
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private SqlServerCodeGenerateInfo genAspectCode(SqlServerViewDataModelDTO dataModelDto, String annotationName, AspectGenerateInfo aspectGenerateInfo) throws LcdpException {
        String aspectName = annotationName + NamingStrategy.capitalFirst((String)"aspect");
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "aspect" + File.separator + aspectName + ".java";
        String filePath = "template/sqlserver/backcode/code/aspect.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("aspectName", aspectName);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        params.put("aspect", aspectGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        SqlServerCodeGenerateInfo codeGenerateInfo = new SqlServerCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("aspect");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(aspectName);
        return codeGenerateInfo;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }
}

