/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.task.masterslavetask.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.pgQueryDTO;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PgTaskMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";
    private static final String FLOW_INCREMENT_NAME = "FlowIncrementDTO";

    private PgTaskMsUtil() {
    }

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, PgBackCtx<PgTaskMsDataModel, PgTaskMsDataModelDTO> backCtx) throws LcdpException {
        PgTaskMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, PgBackCtx<PgTaskMsDataModel, PgTaskMsDataModelDTO> backCtx) {
        PgTaskMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(PgBackCtx<PgTaskMsDataModel, PgTaskMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        PgMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        PgMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        PgDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<PgRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        PgDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (PgRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (PgRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = PgTaskMsUtil.getDelStr(relationshipDtoList, masterDto);
        PgTaskMsUtil.renderTransaction(backCtx, params);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (PgRelationshipDTO pgRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            PgDataModelBaseDTO pgDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(pgRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, pgDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, pgDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, pgDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(PgBackCtx<PgTaskMsDataModel, PgTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        PgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        PgMsDataModelDTO pgMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<PgRelationshipDTO> relationshipDtoList = pgMsDataModelDTO.getRelationshipDtoList();
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, PgDataModelBaseDTO> dataModelDtoMap = pgMsDataModelDTO.getDataModelDtoMap();
        PgDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        PgTaskMsUtil.renderTransaction(backCtx, controllerParams);
        String masterFillCode = PgTaskMsUtil.renderFillCode(mainDataModelDto, pgMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (PgRelationshipDTO pgRelationshipDTO : relationshipDtoList) {
                List<PgRelationshipFieldDTO> pgRelationshipFieldDTOS;
                String slaveTableId = pgRelationshipDTO.getSlaveTableId();
                String relateModelType = pgRelationshipDTO.getRelateModelType();
                PgDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = PgTaskMsUtil.renderFillCode(slaveModelDto, pgMsDataModelDTO);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    pgRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(pgRelationshipFieldDTOS = pgRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(PgBackCtx<PgTaskMsDataModel, PgTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(PgDataModelBaseDTO dataModelBaseDTO, PgMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (PgDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/pg/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<PgRelationshipDTO> relationshipDtoList, PgDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (PgRelationshipDTO relationtMap : relationshipDtoList) {
            List<PgRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            PgRelationshipFieldDTO pgRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDTO.getSlaveFieldCap()).append(",idList));\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                PgRelationshipFieldDTO pgRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(pgRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(pgRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(PgTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(pgRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(PgTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(pgRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void transferControllerCode(PgDataModelBaseDTO fromDataModelBaseDTO, PgDataModelBaseDTO toDataModelBaseDTO) {
        ControllerGenerateInfo businessController = fromDataModelBaseDTO.getControllerGenerateInfo();
        ControllerGenerateInfo taskController = toDataModelBaseDTO.getControllerGenerateInfo();
        if (HussarUtils.isEmpty((Object)taskController)) {
            taskController = new ControllerGenerateInfo();
            toDataModelBaseDTO.setControllerGenerateInfo(taskController);
        }
        if (HussarUtils.isNotEmpty((Object)businessController)) {
            if (HussarUtils.isNotEmpty(businessController.getImports())) {
                if (HussarUtils.isEmpty(taskController.getImports())) {
                    taskController.setImports(new HashSet<String>());
                }
                taskController.getImports().addAll(businessController.getImports());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversions())) {
                if (HussarUtils.isEmpty(taskController.getInversions())) {
                    taskController.setInversions(new HashSet<String>());
                }
                taskController.getInversions().addAll(businessController.getInversions());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversionsWithName())) {
                if (HussarUtils.isEmpty(taskController.getInversionsWithName())) {
                    taskController.setInversionsWithName(new HashMap<String, String>());
                }
                taskController.getInversionsWithName().putAll(businessController.getInversionsWithName());
            }
            if (HussarUtils.isNotEmpty(businessController.getCodes())) {
                if (HussarUtils.isEmpty(taskController.getCodes())) {
                    taskController.setCodes(new ArrayList<String>());
                }
                taskController.getCodes().addAll(businessController.getCodes());
            }
        }
        if (HussarUtils.isNotEmpty(fromDataModelBaseDTO.getApis())) {
            if (HussarUtils.isEmpty(toDataModelBaseDTO.getApis())) {
                toDataModelBaseDTO.setApis(new ArrayList<String>());
            }
            toDataModelBaseDTO.getApis().addAll(fromDataModelBaseDTO.getApis());
        }
    }

    public static void generateIncrementDTO(PgMsDataModelDTO pgFlowDataModelDTO, PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) {
        Map<String, Object> params = dataModelOperation.getParams();
        Map slaveTablePlusSave = (Map)params.get("slaveTablePlusSave");
        boolean plusFlag = false;
        if (HussarUtils.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        params.put("ifPlusSave", plusFlag);
        if (!plusFlag) {
            return;
        }
        PgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        PgTaskMsUtil.addIncrementTable(pgFlowDataModelDTO, slaveTablePlusSave, dataModelBase);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        block1: for (PgDataModelBase modelBase : dataModelBase.getSlaveTables()) {
            String slaveModelName = modelBase.getName();
            for (PgDataModelField field : modelBase.getFields()) {
                if (!"primary".equals(field.getUsage())) continue;
                primaryKeys.put(slaveModelName, field.getName());
                break;
            }
            for (PgDataModelField field : modelBase.getFields()) {
                if (!"foreign".equals(field.getUsage())) continue;
                foreignKeys.put(slaveModelName, field.getName());
                continue block1;
            }
        }
        params.put("primaryKeys", primaryKeys);
        params.put("foreignKeys", foreignKeys);
        params.put("slaveTablePlusSave", slaveTablePlusSave);
        params.put("slaveTable", dataModelBase.getSlaveTables());
        String modelId = backCtx.getUseDataModelBase().getId();
        if (HussarUtils.isEmpty((Object)pgFlowDataModelDTO.getQueryDtoMap().get(pgFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME))) {
            pgQueryDTO oldDTO = pgFlowDataModelDTO.getQueryDtoMap().get(pgFlowDataModelDTO.getName());
            pgQueryDTO pgQueryDTO2 = (pgQueryDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oldDTO), pgQueryDTO.class);
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            newParams.put("queryDto", pgQueryDTO2);
            HashMap<String, Boolean> table = new HashMap<String, Boolean>();
            table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
            newParams.put("table", table);
            pgQueryDTO2.setParams(newParams);
            String plusDtoName = pgFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME;
            String plusTableName = pgFlowDataModelDTO.getEntityName() + "IncrementTable";
            for (PgQueryFieldDTO dto : pgQueryDTO2.getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                dto.getDbColumnType().setType(plusTableName);
                dto.getDbColumnType().setImportT(pgQueryDTO2.getPackageInfo() + "." + plusTableName);
                params.put("incrementTable", dto.getDbColumnType());
                backCtx.addServiceImplImport(modelId, dto.getDbColumnType().getImportT());
                break;
            }
            pgQueryDTO2.setName(pgQueryDTO2.getName() + FLOW_INCREMENT_NAME);
            pgQueryDTO2.setEntityName(plusDtoName);
            pgQueryDTO2.setImportInfo(pgQueryDTO2.getPackageInfo() + "." + plusDtoName);
            pgQueryDTO2.setWriteFilePath(FileUtil.systemPath((String[])new String[]{pgFlowDataModelDTO.getTablePath(), "dto", plusDtoName + ".java"}));
            pgFlowDataModelDTO.getQueryDtoMap().put(pgQueryDTO2.getName(), pgQueryDTO2);
            params.put("parameter", plusDtoName);
            backCtx.addControllerImport(modelId, pgQueryDTO2.getImportInfo());
            backCtx.addServiceImport(modelId, pgQueryDTO2.getImportInfo());
            backCtx.addServiceImplImport(modelId, pgQueryDTO2.getImportInfo());
        } else {
            for (PgQueryFieldDTO dto : pgFlowDataModelDTO.getQueryDtoMap().get(pgFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME).getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                params.put("incrementTable", dto.getDbColumnType());
                break;
            }
            params.put("parameter", pgFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME);
        }
    }

    private static void addIncrementTable(PgMsDataModelDTO dataModelBaseDTO, Map<String, Boolean> slaveTablePlusSave, PgMsDataModel dataModelBase) {
        pgQueryDTO queryDTO = new pgQueryDTO();
        boolean containDate = false;
        String masterId = dataModelBase.getMasterTable().getId();
        for (PgDataModelField dataModelField : dataModelBase.getMasterTable().getFields()) {
            if (!"date".equals(dataModelField.getDataType())) continue;
            containDate = true;
            break;
        }
        queryDTO.setFtlPath("template/pg/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelBaseDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", dataModelBase.getSlaveTables());
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("Entity"));
        params.put("containDate", containDate);
        params.put("queryDto", queryDTO);
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        queryDTO.setParams(params);
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setName(dataModelBaseDTO.getName() + "IncrementTable");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "IncrementTable");
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }
}

