/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.element.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgEnclosure;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PgTaskMsDataModel
extends PgMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(PgTaskMsDataModel.class);
    public static final String FUNCTION_TYPE = "TASK_MASTER_SLAVE";
    public static final String TASK_KEY = "task";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private PgBaseDataModel task;
    private List<PgDataModelField> flowFields;

    public List<PgDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<PgDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"POSTGRE_SQL.TASK_MASTER_SLAVE", PgTaskMsDataModel.class);
    }

    public PgBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(PgBaseDataModel task) {
        this.task = task;
    }

    @Override
    public PgTaskMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        PgTaskMsDataModel pgTaskMsDataModel;
        try {
            ArrayList<PgDataModelField> fieldList = new ArrayList<PgDataModelField>();
            pgTaskMsDataModel = (PgTaskMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), PgTaskMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                PgDataModelBase master = PgDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(pgTaskMsDataModel.getName() + "Master");
                pgTaskMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<PgDataModelBase> slaveTables = new ArrayList<PgDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    PgDataModelBase slaveTable = PgDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (PgRelationshipBase relationship : pgTaskMsDataModel.getRelationships()) {
                    if (relationship.getMasterTableId().equals(pgTaskMsDataModel.task.getId())) continue;
                    PgDataModelBase dataModelBase = slaveTables.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)relationship.getSlaveTableId())).findFirst().orElseGet(PgBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    PgDataModelField pgDataModelField = new PgDataModelField();
                    pgDataModelField.setId(UUID.randomUUID().toString());
                    pgDataModelField.setName(dataModelBase.getName());
                    pgDataModelField.setComment(dataModelBase.getComment());
                    pgDataModelField.setSourceDataModelId(dataModelBase.getId());
                    pgDataModelField.setDataType("array");
                    fieldList.add(pgDataModelField);
                }
                pgTaskMsDataModel.setSlaveTables(slaveTables);
            }
            pgTaskMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return pgTaskMsDataModel;
    }

    @Override
    public PgEnclosure<PgDataModelBase> enclosure() throws LcdpException {
        return PgModelBeanUtil.getEnclosureBean("POSTGRE_SQL", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public PgRender<PgDataModelBase, PgDataModelBaseDTO> render() throws LcdpException {
        return PgModelBeanUtil.getRenderBean("POSTGRE_SQL", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<PgDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<PgDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<PgDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<PgDataModelField>> contrastVOS = this.task.modelContrastTable((FieldsContrastParam<PgDataModelField>)fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable((FieldsContrastParam<PgDataModelField>)fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<PgDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId).getDetails().get(0));
        details.addAll(super.checkTableContrast(modelId).getDetails());
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<PgDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        this.task.updateIndexForSystemTask(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public Boolean updateIndex(FieldsContrastParam<PgDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        return this.task.updateIndexForSystemTask(fieldsContrastParam);
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<PgDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.getMasterTable().getId(), "T2");
        List<PgRelationshipBase> relationships = super.getRelationships();
        if (ToolUtil.isNotEmpty(relationships) && !relationships.isEmpty()) {
            for (int i = 0; i < relationships.size(); ++i) {
                PgRelationshipBase relationship = relationships.get(i);
                if (relationship.getSlaveTableId().equals(super.getId())) continue;
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx) throws LcdpException {
        PgModelBeanUtil.getCustomOperationBean("POSTGRE_SQL", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

