/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.render.PgBaseRender;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.flow.baseflow.util.PgFlowBaseUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLFLOWInitialNodeReject")
public class PgInitialNodeRejectCodeVisitor
implements PgOperationVisitor<PgFlowDataModel, PgFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgInitialNodeRejectCodeVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLFLOWInitialNodeReject";

    @Override
    public void visit(PgBackCtx<PgFlowDataModel, PgFlowDataModelDTO> backCtx, PgDataModelOperation operation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        PgFlowDataModelDTO dataModelBaseDto = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(operation, dataModelBaseDto);
        String controllerPath = "template/pg/flowbackcode/baseflowbackcode/initialnodereject/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        this.renderImpl(backCtx, modelId, dataModelBaseDto);
        backCtx.addControllerInversion(modelId, dataModelBaseDto.getServiceName());
        String servicePath = "template/pg/flowbackcode/baseflowbackcode/initialnodereject/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String fillCode = PgFlowBaseUtil.renderFillCode(dataModelBaseDto);
        if (fillCode != null) {
            controllerParams.put("fillCode", fillCode);
        }
        String implPath = "template/pg/flowbackcode/baseflowbackcode/initialnodereject/service_impl.ftl";
        controllerParams.put("isRemote", VfgModeTool.isRemote());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, controllerParams));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", dataModelBaseDto.getApiPrefix() + "/" + operation.getName(), "\u9a73\u56de\u5230\u521d\u59cb\u8282\u70b9", null);
        backCtx.addApi(modelId, PgBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private Map<String, Object> initParams(PgDataModelOperation operation, PgFlowDataModelDTO dataModelBaseDto) {
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("dataSourceAnnotation", PgDataSourceUtil.getMethodDataSourceAnnotation());
        controllerParams.put("table", dataModelBaseDto);
        controllerParams.put("parameter", dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getEntityName());
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(dataModelBaseDto.getComment() + "\u9a73\u56de\u81f3\u521d\u59cb\u8282\u70b9");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        return controllerParams;
    }

    private void renderImpl(PgBackCtx<PgFlowDataModel, PgFlowDataModelDTO> backCtx, String modelId, PgFlowDataModelDTO dataModelBaseDto) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, dataModelBaseDto.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDto.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs");
        backCtx.addServiceImplImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
    }
}

